/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.parsing.KotlinScriptDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzerScriptParameter;

public class KotlinScriptDefinitionProvider {
    private final Map<String, KotlinScriptDefinition> scripts = new HashMap<String, KotlinScriptDefinition>();
    private final Set<PsiFile> scriptsFiles = new HashSet<PsiFile>();
    private static final KotlinScriptDefinition standardScript = new KotlinScriptDefinition(".kts", Collections.<AnalyzerScriptParameter>emptyList());

    public static KotlinScriptDefinitionProvider getInstance(Project project) {
        return ServiceManager.getService(project, KotlinScriptDefinitionProvider.class);
    }

    public KotlinScriptDefinitionProvider() {
        this.addScriptDefinition(standardScript);
    }

    public void markFileAsScript(KtFile file) {
        this.scriptsFiles.add(file);
    }

    public KotlinScriptDefinition findScriptDefinition(PsiFile psiFile) {
        boolean force = this.scriptsFiles.contains(psiFile);
        String name = psiFile.getName();
        for (Map.Entry<String, KotlinScriptDefinition> e : this.scripts.entrySet()) {
            if (!name.endsWith(e.getKey())) continue;
            return e.getValue();
        }
        if (force) {
            return standardScript;
        }
        return null;
    }

    public boolean isScript(PsiFile psiFile) {
        return this.findScriptDefinition(psiFile) != null;
    }

    public void addScriptDefinition(@NotNull KotlinScriptDefinition scriptDefinition) {
        if (scriptDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDefinition", "org/jetbrains/kotlin/parsing/KotlinScriptDefinitionProvider", "addScriptDefinition"));
        }
        this.scripts.put(scriptDefinition.getExtension(), scriptDefinition);
    }

    public void addScriptDefinitions(List<KotlinScriptDefinition> definitions) {
        for (KotlinScriptDefinition definition : definitions) {
            this.addScriptDefinition(definition);
        }
    }
}

