/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtElementImpl
extends ASTWrapperPsiElement
implements KtElement {
    public KtElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtElementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        if (kotlinLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtElementImpl", "getLanguage"));
        }
        return kotlinLanguage;
    }

    @Override
    public String toString() {
        return this.getNode().getElementType().toString();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtElementImpl", "accept"));
        }
        if (visitor2 instanceof KtVisitor) {
            this.accept((KtVisitor)visitor2, null);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public KtFile getContainingKtFile() {
        PsiFile file = this.getContainingFile();
        assert (file instanceof KtFile) : "JetElement not inside JetFile: " + file + " " + file.getText();
        KtFile ktFile = (KtFile)file;
        if (ktFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtElementImpl", "getContainingKtFile"));
        }
        return ktFile;
    }

    @Override
    public <D> void acceptChildren(@NotNull KtVisitor<Void, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtElementImpl", "acceptChildren"));
        }
        KtPsiUtil.visitChildren(this, visitor2, data);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtElementImpl", "accept"));
        }
        return visitor2.visitKtElement(this, data);
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references.length == 1) {
            return references[0];
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtElementImpl", "getReferences"));
        }
        return psiReferenceArray;
    }
}

