/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationImpl;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtMultiDeclaration
extends KtDeclarationImpl
implements KtValVarKeywordOwner {
    public KtMultiDeclaration(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtMultiDeclaration", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtMultiDeclaration", "accept"));
        }
        return visitor2.visitMultiDeclaration(this, data);
    }

    @NotNull
    public List<KtMultiDeclarationEntry> getEntries() {
        List<KtMultiDeclarationEntry> list = this.findChildrenByType(KtNodeTypes.MULTI_VARIABLE_DECLARATION_ENTRY);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtMultiDeclaration", "getEntries"));
        }
        return list;
    }

    @Nullable
    public KtExpression getInitializer() {
        ASTNode eqNode = this.getNode().findChildByType(KtTokens.EQ);
        if (eqNode == null) {
            return null;
        }
        return PsiTreeUtil.getNextSiblingOfType(eqNode.getPsi(), KtExpression.class);
    }

    @Override
    @Nullable
    public PsiElement getValOrVarKeyword() {
        return this.findChildByType(TokenSet.create(KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD));
    }

    @Nullable
    public PsiElement getRPar() {
        return this.findChildByType(KtTokens.RPAR);
    }

    @Nullable
    public PsiElement getLPar() {
        return this.findChildByType(KtTokens.LPAR);
    }
}

