/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"Q\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u000f\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\u0012C\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001\u0001B\u0006\r\u0001e!\u0011BA\u0005\u00021\u0005A\n!G\u0001\u0019\u0004e!\u0011BA\u0005\u00021\u0005A\"!)\t\u0005\u0017%!\u0001RA\u0007\u0003\u0019\u0003A\u0012!C\u0002\t\u00075\t\u0001tA\u0005\u0004\u0011\u0011i\u0011\u0001'\u0003R\u0007\u0005AQ!i\b\n\t!\u0015QB\u0001G\u00011\u0005I1\u0001C\u0002\u000e\u0003a-\u0011b\u0001\u0005\u0005\u001b\u0005AJ!U\u0002\u0002\u0011\u0019)3\u0002B\u0006\t\u000e5!\u0011BA\u0005\u00021\u001fAr!G\u0002\t\u00115\t\u0001tAS\n\t-A\t\"\u0004\u0003\n\u0005%\t\u00014\u0003\r\n#\u000e\t\u0001BC\u0013\u0005\t-A)\"D\u0001\u0019\u0017\u0015:Aa\u0003E\f\u001b\u0011I!!C\u0001\u0019\u0004aaQ\u0005\u0002\u0003\f\u0011\u0011i\u0011\u0001'\u0003&\t\u0011Y\u0001\u0012D\u0007\u00021\u000fIs\u0001B!\t\u0011\u0011i\u0011\u0001'\u0003R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A1!D\u0001\u0019\fE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "Lcom/intellij/psi/stubs/PsiFileStubImpl;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "Lcom/intellij/psi/stubs/PsiClassHolderFileStub;", "jetFile", "packageName", "", "isScript", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;Z)V", "Lcom/intellij/util/io/StringRef;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/util/io/StringRef;Z)V", "findImportsByAlias", "", "Lorg/jetbrains/kotlin/psi/stubs/KotlinImportDirectiveStub;", "alias", "getClasses", "", "Lcom/intellij/psi/PsiClass;", "()[Lcom/intellij/psi/PsiClass;", "getPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getType", "Lcom/intellij/psi/tree/IStubFileElementType;", "toString"}, moduleName="kotlin-compiler")
public class KotlinFileStubImpl
extends PsiFileStubImpl<KtFile>
implements PsiClassHolderFileStub<KtFile>,
KotlinFileStub {
    private final StringRef packageName;
    private final boolean isScript;

    @Override
    @NotNull
    public FqName getPackageFqName() {
        String string = StringRef.toString(this.packageName);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return new FqName(string);
    }

    @Override
    public boolean isScript() {
        return this.isScript;
    }

    @Override
    @NotNull
    public IStubFileElementType<KotlinFileStub> getType() {
        IStubFileElementType iStubFileElementType = KtStubElementTypes.FILE;
        Intrinsics.checkExpressionValueIsNotNull(iStubFileElementType, "KtStubElementTypes.FILE");
        return iStubFileElementType;
    }

    @Override
    @NotNull
    public String toString() {
        return "PsiJetFileStubImpl[" + "package=" + this.getPackageFqName().asString() + "]";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiClass[] getClasses() {
        Iterable $receiver;
        Iterable $receiver2 = this.getChildrenStubs();
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            if (!(element instanceof PsiClassStub)) continue;
            destination.add(element);
        }
        $receiver2 = (List)destination;
        $receiver = $receiver2;
        destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it;
            PsiClassStub $i$f$filterIsInstanceTo = (PsiClassStub)item;
            Collection collection = destination;
            PsiClass psiClass = (PsiClass)it.getPsi();
            collection.add(psiClass);
        }
        $receiver2 = (List)destination;
        Collection thisCollection = (Collection)$receiver2;
        PsiClass[] psiClassArray = thisCollection.toArray(new PsiClass[thisCollection.size()]);
        if (psiClassArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (PsiClass[])((Object[])psiClassArray);
    }

    @Override
    @NotNull
    public List<KotlinImportDirectiveStub> findImportsByAlias(@NotNull String alias) {
        Collection destination;
        Iterable $receiver;
        Object v0;
        Object element2;
        Iterable $receiver2;
        block4: {
            Intrinsics.checkParameterIsNotNull(alias, "alias");
            $receiver2 = this.getChildrenStubs();
            for (Object element2 : $receiver2) {
                StubElement it = (StubElement)element2;
                if (!Intrinsics.areEqual(it.getStubType(), KtStubElementTypes.IMPORT_LIST)) continue;
                v0 = element2;
                break block4;
            }
            v0 = null;
        }
        StubElement stubElement = v0;
        if (stubElement == null) {
            return CollectionsKt.emptyList();
        }
        StubElement importList = stubElement;
        $receiver2 = importList.getChildrenStubs();
        Iterable iterable = $receiver2;
        element2 = new ArrayList();
        for (Object element3 : $receiver) {
            if (!(element3 instanceof KotlinImportDirectiveStub)) continue;
            destination.add(element3);
        }
        $receiver2 = (List)destination;
        $receiver = $receiver2;
        destination = new ArrayList();
        for (Object element3 : $receiver) {
            KotlinImportDirectiveStub it = (KotlinImportDirectiveStub)element3;
            if (!Intrinsics.areEqual(it.getAliasName(), alias)) continue;
            destination.add(element3);
        }
        return (List)destination;
    }

    public KotlinFileStubImpl(@Nullable KtFile jetFile, @NotNull StringRef packageName, boolean isScript) {
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        super((PsiFile)jetFile);
        this.packageName = packageName;
        this.isScript = isScript;
    }

    public KotlinFileStubImpl(@Nullable KtFile jetFile, @NotNull String packageName, boolean isScript) {
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        StringRef stringRef = StringRef.fromString(packageName);
        if (stringRef == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(stringRef, "StringRef.fromString(packageName)!!");
        this(jetFile, stringRef, isScript);
    }
}

