/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0002\u0019\u0005a\u0001!G\u0001\u0019\u0002\u0005\u0016\u0011kA\u0001\t\u0003\u0015\"Ba\u0003E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u00063\rAY!D\u0001\u0019\r\u0015BA!\u0001E\u0007\u001b\u0005Ar!G\u0002\t\b5\t\u0001t\u0002"}, strings={"Lorg/jetbrains/kotlin/resolve/InfixModifierChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isApplicable", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;"}, moduleName="kotlin-compiler")
public final class InfixModifierChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!functionDescriptor2.isInfix()) {
            return;
        }
        PsiElement psiElement2 = declaration.getModifierList();
        if (psiElement2 == null || (psiElement2 = psiElement2.getModifier(KtTokens.INFIX_KEYWORD)) == null) {
            return;
        }
        PsiElement modifier = psiElement2;
        if (!this.isApplicable(functionDescriptor2)) {
            diagnosticHolder.report(Errors.INAPPLICABLE_INFIX_MODIFIER.on(modifier));
        }
    }

    private final boolean isApplicable(FunctionDescriptor descriptor2) {
        if (descriptor2.getDispatchReceiverParameter() == null && descriptor2.getExtensionReceiverParameter() == null) {
            return false;
        }
        if (descriptor2.getValueParameters().size() != 1) {
            return false;
        }
        ValueParameterDescriptor singleParameter = CollectionsKt.first(descriptor2.getValueParameters());
        return !DescriptorUtilsKt.hasDefaultValue(singleParameter) && singleParameter.getVarargElementType() == null;
    }
}

