/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"7\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u000e$!\u0001QB\u0001G\u00011\u0003I2\u0001C\u0001\u000e\u0003a\r\u0011d\u0001\u0005\u0003\u001b\u0005A*!G\u0002\t\u00075\t\u0001t\u0001+\u0004\t5IB!\u0001E\u0005\u001b\u0005AR!F\u0001\u0019\u0002e%\u0001bA\u0007\u00021\u000f\u00016\u0011AM\u0005\u0011\u0017i\u0011\u0001\u0007\u0004Q\u0007\u0005IZ\u0001#\u0004\u000e\u00051\u0005\u0001d\u0002)\u0004\u0004Q\u001bA!\u0004\r\t\u00105\t\u0001$B\u000b\u00021\u0003IJ\u0001C\u0002\u000e\u0003a\u001d\u0001k!\u0001\u001a\n!-Q\"\u0001\r\u0007!\u000e\t\u00114\u0002E\u0007\u001b\ta\t\u0001G\u0004Q\u0007\u0007!6\u0001BG\u0013\u0011!i!\u0001$\u0001\u0019\u0012U\t\u0001\u0014AM\u0005\u0011\ri\u0011\u0001g\u0002Q\u0007\u0003IJ\u0001c\u0003\u000e\u0003a1\u0001kA\u0001U\u0007\u0011i\u0011\u0004B\u0001\t\u00135\t\u0001dB\u000b\u00021\u0003IJ\u0001C\u0002\u000e\u0003a\u001d\u0001k!\u0001\u001a\n!-Q\"\u0001\r\u0007!\u000e\t\u00114\u0002E\u0007\u001b\ta\t\u0001G\u0004Q\u0007\u0007!6\u0001\u0002"}, strings={"createQualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/QualifierReceiver;", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "QualifierKt", "resolveAndRecordReferenceTarget", "", "symbolUsageValidator", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "selector", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolveAsReceiverInQualifiedExpression", "resolveAsStandaloneExpression", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveReferenceTarget"}, moduleName="kotlin-compiler")
public final class QualifierKt {
    @Nullable
    public static final QualifierReceiver createQualifier(@NotNull KtSimpleNameExpression expression, @NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context) {
        QualifierReceiver qualifierReceiver;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(receiver, "receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        HierarchicalScope receiverScope = !receiver.exists() ? (HierarchicalScope)context.scope : (receiver instanceof QualifierReceiver ? (HierarchicalScope)ScopeUtilsKt.memberScopeAsImportingScope$default(((QualifierReceiver)receiver).getScope(), null, 1) : (HierarchicalScope)ScopeUtilsKt.memberScopeAsImportingScope$default(receiver.getType().getMemberScope(), null, 1));
        Name name = expression.getReferencedNameAsName();
        PackageViewDescriptor packageViewDescriptor = ScopeUtilsKt.findPackage(receiverScope, name);
        ClassifierDescriptor classifierDescriptor = ScopeUtilsKt.findClassifier(receiverScope, name, new KotlinLookupLocation(expression));
        if (packageViewDescriptor == null && classifierDescriptor == null) {
            return null;
        }
        BindingTrace bindingTrace = context.trace;
        LexicalScope lexicalScope2 = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope2, "context.scope");
        BindingContextUtilsKt.recordScope(bindingTrace, lexicalScope2, expression);
        if (receiver instanceof PackageQualifier) {
            if (packageViewDescriptor != null) {
                qualifierReceiver = new PackageQualifier(expression, packageViewDescriptor);
            } else {
                ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
                if (classifierDescriptor2 == null) {
                    Intrinsics.throwNpe();
                }
                qualifierReceiver = new ClassifierQualifier(expression, classifierDescriptor2);
            }
        } else if (classifierDescriptor != null) {
            qualifierReceiver = new ClassifierQualifier(expression, classifierDescriptor);
        } else {
            PackageViewDescriptor packageViewDescriptor2 = packageViewDescriptor;
            if (packageViewDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            qualifierReceiver = new PackageQualifier(expression, packageViewDescriptor2);
        }
        QualifierReceiver qualifier2 = qualifierReceiver;
        context.trace.record(BindingContext.QUALIFIER, qualifier2.getExpression(), qualifier2);
        return qualifier2;
    }

    @Nullable
    public static final KotlinType resolveAsStandaloneExpression(QualifierReceiver $receiver, @NotNull ExpressionTypingContext context, @NotNull SymbolUsageValidator symbolUsageValidator) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        ClassifierDescriptor classifier2 = $receiver.getClassifier();
        QualifierKt.resolveAndRecordReferenceTarget($receiver, context, symbolUsageValidator, null);
        if (classifier2 instanceof TypeParameterDescriptor) {
            context.trace.report(Errors.TYPE_PARAMETER_IS_NOT_AN_EXPRESSION.on((KtSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression()), (TypeParameterDescriptor)classifier2));
        } else if (classifier2 instanceof ClassDescriptor && !DescriptorUtilsKt.getHasClassObjectType((ClassDescriptor)classifier2)) {
            context.trace.report(Errors.NO_COMPANION_OBJECT.on((KtSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression()), classifier2));
        } else if ($receiver.getPackageView() != null) {
            context.trace.report(Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND.on((KtSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression())));
        }
        return null;
    }

    public static final void resolveAsReceiverInQualifiedExpression(QualifierReceiver $receiver, @NotNull ExpressionTypingContext context, @NotNull SymbolUsageValidator symbolUsageValidator, @Nullable DeclarationDescriptor selector) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        ClassifierDescriptor classifier2 = $receiver.getClassifier();
        QualifierKt.resolveAndRecordReferenceTarget($receiver, context, symbolUsageValidator, selector);
        if (classifier2 instanceof TypeParameterDescriptor) {
            context.trace.report(Errors.TYPE_PARAMETER_ON_LHS_OF_DOT.on((KtSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression()), (TypeParameterDescriptor)classifier2));
        } else if (classifier2 instanceof ClassDescriptor && DescriptorUtilsKt.getHasClassObjectType((ClassDescriptor)classifier2)) {
            context.trace.recordType($receiver.getExpression(), DescriptorUtilsKt.getClassObjectType((ClassDescriptor)classifier2));
        }
    }

    private static final void resolveAndRecordReferenceTarget(QualifierReceiver $receiver, ExpressionTypingContext context, SymbolUsageValidator symbolUsageValidator, DeclarationDescriptor selector) {
        $receiver.setResultingDescriptor(QualifierKt.resolveReferenceTarget($receiver, context, symbolUsageValidator, selector));
        context.trace.record(BindingContext.REFERENCE_TARGET, $receiver.getReferenceExpression(), $receiver.getResultingDescriptor());
    }

    private static final DeclarationDescriptor resolveReferenceTarget(QualifierReceiver $receiver, ExpressionTypingContext context, SymbolUsageValidator symbolUsageValidator, DeclarationDescriptor selector) {
        ClassDescriptor companionObjectDescriptor2;
        DeclarationDescriptor selectorContainer;
        DeclarationDescriptor declarationDescriptor;
        ClassifierDescriptor classifier2 = $receiver.getClassifier();
        PackageViewDescriptor packageView = $receiver.getPackageView();
        if (classifier2 instanceof TypeParameterDescriptor) {
            return classifier2;
        }
        if (selector instanceof ConstructorDescriptor) {
            declarationDescriptor = ((ConstructorDescriptor)selector).getContainingDeclaration().getContainingDeclaration();
        } else {
            DeclarationDescriptor declarationDescriptor2 = selector;
            declarationDescriptor = selectorContainer = declarationDescriptor2 != null ? declarationDescriptor2.getContainingDeclaration() : null;
        }
        if (packageView != null && (selectorContainer instanceof PackageFragmentDescriptor || selectorContainer instanceof PackageViewDescriptor) && Intrinsics.areEqual(DescriptorUtils.getFqName(packageView), DescriptorUtils.getFqName(selectorContainer))) {
            return packageView;
        }
        boolean isCallableWithReceiver = selector instanceof CallableDescriptor && (((CallableDescriptor)selector).getDispatchReceiverParameter() != null || ((CallableDescriptor)selector).getExtensionReceiverParameter() != null);
        DeclarationDescriptor declarationDescriptor3 = $receiver.getDescriptor();
        if (declarationDescriptor3 instanceof ClassifierDescriptor) {
            ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)declarationDescriptor3;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            symbolUsageValidator.validateTypeUsage(classifierDescriptor, bindingTrace, $receiver.getReferenceExpression());
        }
        if (isCallableWithReceiver && classifier2 instanceof ClassDescriptor && DescriptorUtilsKt.getHasClassObjectType((ClassDescriptor)classifier2) && (companionObjectDescriptor2 = ((ClassDescriptor)classifier2).getCompanionObjectDescriptor()) != null) {
            context.trace.record(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, $receiver.getReferenceExpression(), classifier2);
            ClassifierDescriptor classifierDescriptor = companionObjectDescriptor2;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            symbolUsageValidator.validateTypeUsage(classifierDescriptor, bindingTrace, $receiver.getReferenceExpression());
            return companionObjectDescriptor2;
        }
        return declarationDescriptor3;
    }
}

