/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.builtins;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalyzerFacade;
import org.jetbrains.kotlin.analyzer.ModuleContent;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.ResolverForProject;
import org.jetbrains.kotlin.builtins.BuiltInsSerializedResourcePaths;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmAnalyzerFacade;
import org.jetbrains.kotlin.resolve.jvm.JvmPlatformParameters;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializer;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializerExtension;
import org.jetbrains.kotlin.utils.FileUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"y\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\f\u0015\tA!A\u0003\u0002\u0011\u0011)\u0011\u0001B\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002E\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0010\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0005a\u0001!G\u0001\u0019\u0002u\u0005Q#)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BA\u0013\t\t\u0005AA!D\u0001\u0019\ne\u0019\u0001\"B\u0007\u00021\u0017)#\u0004B\u0001\t\r5\t\u0001TB\r\u0004\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001M\t3\u0019A\u0011\"\u0004\u0003\n\u0005%\t\u0001\u0014\u0003M\n3\u0019A!\"\u0004\u0003\n\u0005%\t\u0001\u0014\u0003M\nK\tBa!D\u0001\u0019\u000ee\u0019\u0001\u0002C\u0007\u00021#Ib\u0001C\u0005\u000e\t%\u0011\u0011\"\u0001M\t1'Ib\u0001\u0003\u0006\u000e\t%\u0011\u0011\"\u0001M\t1'IB\u0002#\u0006\u000e\u0015%\u0011\u0011\"\u0001\r\u0004\u0013\tI\u0011\u0001G\u0002\n\u0005%\t\u0001T\u0002\r\fKe!\u0011\u0001c\u0006\u000e\u0003a5\u0011d\u0001\u0005\u0006\u001b\u0005AZ!G\u0002\t\u00195\t\u0001\u0014D\r\r\u00115i!\"\u0003\u0002\n\u0003a-\u0011BA\u0005\u000217I!!C\u0001\u0019\u000eaYQ\u0005\b\u0003\u0002\u00119i\u0011\u0001'\u0004\u001a\r!uQ\u0002B\u0005\u0003\u0013\u0005Az\u0002G\b\u001a\u0007!aQ\"\u0001M\r31AQ\"\u0004\u0006\n\u0005%\t\u00014B\u0005\u0003\u0013\u0005AZ\"\u0003\u0002\n\u0003a5\u0001dC\u0013\u0011\t\u0005A\u0001#D\u0001\u0019\u000ee\u0019\u0001\u0012E\u0007\u00021EI2\u0001c\t\u000e\u0003a\u0011\u0012d\u0001\u0005\t\u001b\u0005A\n\"\n\f\u0005\u0003!\u0015R\"\u0001M\u00073\rA\u0001\"D\u0001\u0019\u0012e\u0019\u0001bE\u0007\u00021\u0013I2\u0001c\n\u000e\u0003a!\u0012$\u0002\u0003\u0002\u0011Si!\u0001$\u0001\u0019\n%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B9!\u0015Q\"\u0001\r\u0004#\u000e\tQ\u0001A\u0015\b\t\u0005c\u0002rA\u0007\u00021\r\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer;", "", "dependOnOldBuiltIns", "", "(Z)V", "totalFiles", "", "totalSize", "getFileName", "", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "serialize", "", "disposable", "Lcom/intellij/openapi/Disposable;", "destDir", "Ljava/io/File;", "srcDirs", "", "extraClassPath", "onComplete", "Lkotlin/Function2;", "serializeClass", "serializer", "Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializerExtension;", "writeClass", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "serializeClasses", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "serializePackage", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "write", "fileName", "stream", "Ljava/io/ByteArrayOutputStream;", "legacyFileName", "BuiltinsSourcesModule"}, moduleName="kotlin-compiler")
public final class BuiltInsSerializer {
    private int totalSize;
    private int totalFiles;
    private final boolean dependOnOldBuiltIns;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serialize(@NotNull File destDir, @NotNull List<? extends File> srcDirs, @NotNull List<? extends File> extraClassPath, @NotNull Function2<? super Integer, ? super Integer, ? extends Unit> onComplete) {
        Intrinsics.checkParameterIsNotNull(destDir, "destDir");
        Intrinsics.checkParameterIsNotNull(srcDirs, "srcDirs");
        Intrinsics.checkParameterIsNotNull(extraClassPath, "extraClassPath");
        Intrinsics.checkParameterIsNotNull(onComplete, "onComplete");
        Disposable rootDisposable = Disposer.newDisposable();
        try {
            Disposable disposable = rootDisposable;
            Intrinsics.checkExpressionValueIsNotNull(disposable, "rootDisposable");
            this.serialize(disposable, destDir, srcDirs, extraClassPath);
            onComplete.invoke((Integer)this.totalSize, (Integer)this.totalFiles);
        }
        finally {
            Disposer.dispose(rootDisposable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void serialize(Disposable disposable, File destDir, List<? extends File> srcDirs, List<? extends File> extraClassPath) {
        void destination;
        void $receiver;
        Iterable $receiver2;
        Iterable it2;
        Object object;
        void destination2;
        void $receiver3;
        void $receiver4;
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
        Iterable iterable = srcDirs;
        CompilerConfiguration compilerConfiguration = configuration;
        void var7_8 = $receiver4;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver4, 10));
        for (Object item : $receiver3) {
            File file = (File)item;
            object = destination2;
            String string = ((File)((Object)it2)).getPath();
            object.add(string);
        }
        object = (List)destination2;
        ContentRootsKt.addKotlinSourceRoots(compilerConfiguration, (List<? extends String>)object);
        JvmContentRootsKt.addJvmClasspathRoots(configuration, extraClassPath);
        List<String> list = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Intrinsics.checkExpressionValueIsNotNull(list, "EnvironmentConfigFiles.JVM_CONFIG_FILES");
        KotlinCoreEnvironment environment2 = KotlinCoreEnvironment.Companion.createForTests(disposable, configuration, list);
        List<KtFile> files = environment2.getSourceFiles();
        BuiltinsSourcesModule builtInModule = new BuiltinsSourcesModule();
        ResolverForProject resolver2 = AnalyzerFacade.setupResolverForProject$default(JvmAnalyzerFacade.INSTANCE, "builtIns source", ContextKt.ProjectContext(environment2.getProject()), CollectionsKt.listOf(builtInModule), new Function1<BuiltinsSourcesModule, ModuleContent>(files){
            final /* synthetic */ List $files;

            @NotNull
            public final ModuleContent invoke(@NotNull BuiltinsSourcesModule it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                Collection collection = this.$files;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                Intrinsics.checkExpressionValueIsNotNull(globalSearchScope, "GlobalSearchScope.EMPTY_SCOPE");
                return new ModuleContent(collection, globalSearchScope);
            }
            {
                this.$files = list;
                super(1);
            }
        }, new JvmPlatformParameters(serialize.resolver.2.INSTANCE), CompilerEnvironment.INSTANCE, null, new Function2<BuiltinsSourcesModule, ModuleContent, JvmPackagePartProvider>(environment2){
            final /* synthetic */ KotlinCoreEnvironment $environment;

            @NotNull
            public final JvmPackagePartProvider invoke(@NotNull BuiltinsSourcesModule module2, @NotNull ModuleContent content) {
                Intrinsics.checkParameterIsNotNull(module2, "module");
                Intrinsics.checkParameterIsNotNull(content, "content");
                return new JvmPackagePartProvider(this.$environment);
            }
            {
                this.$environment = kotlinCoreEnvironment;
                super(2);
            }
        }, 64);
        ModuleDescriptor moduleDescriptor = resolver2.descriptorForModule((ModuleInfo)builtInModule);
        FileUtilsKt.recursePostOrder(destDir, serialize.2.INSTANCE);
        if (!destDir.mkdirs()) {
            System.err.println("Could not make directories: " + destDir);
        }
        it2 = files;
        void $i$a$1 = $receiver2;
        Collection $i$f$mapTo = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it3;
            KtFile ktFile = (KtFile)item;
            compilerConfiguration = destination;
            object = it3.getPackageFqName();
            compilerConfiguration.add(object);
        }
        $receiver2 = CollectionsKt.toSet((List)destination);
        for (Object element : $receiver2) {
            FqName fqName2;
            FqName fqName3 = fqName2 = (FqName)element;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName");
            this.serializePackage(moduleDescriptor, fqName3, destDir);
        }
    }

    private final void serializePackage(ModuleDescriptor module2, FqName fqName2, File destDir) {
        PackageViewDescriptor packageView = module2.getPackage(fqName2);
        List classifierDescriptors = DescriptorSerializer.sort(ResolutionScope.DefaultImpls.getContributedDescriptors$default(packageView.getMemberScope(), DescriptorKindFilter.CLASSIFIERS, null, 2));
        BuiltInsSerializerExtension extension = new BuiltInsSerializerExtension();
        Collection collection = classifierDescriptors;
        Intrinsics.checkExpressionValueIsNotNull(collection, "classifierDescriptors");
        this.serializeClasses(collection, extension, (Function2<? super ClassDescriptor, ? super ProtoBuf.Class, ? extends Unit>)new Function2<ClassDescriptor, ProtoBuf.Class, Unit>(this, destDir){
            final /* synthetic */ BuiltInsSerializer this$0;
            final /* synthetic */ File $destDir;

            public final void invoke(@NotNull ClassDescriptor classDescriptor, @NotNull ProtoBuf.Class classProto) {
                Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
                Intrinsics.checkParameterIsNotNull(classProto, "classProto");
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                classProto.writeTo(stream);
                BuiltInsSerializer.write$default(this.this$0, this.$destDir, BuiltInsSerializer.access$getFileName(this.this$0, classDescriptor), stream, null, 8);
            }
            {
                this.this$0 = builtInsSerializer;
                this.$destDir = file;
                super(2);
            }
        });
        ByteArrayOutputStream packageStream = new ByteArrayOutputStream();
        List<PackageFragmentDescriptor> fragments2 = packageView.getFragments();
        ProtoBuf.Package packageProto = DescriptorSerializer.createTopLevel(extension).packageProto((Collection<PackageFragmentDescriptor>)fragments2).build();
        packageProto.writeTo(packageStream);
        this.write(destDir, BuiltInsSerializedResourcePaths.INSTANCE.getPackageFilePath(fqName2), packageStream, BuiltInsSerializedResourcePaths.INSTANCE.getFallbackPaths().getPackageFilePath(fqName2));
        ByteArrayOutputStream nameStream = new ByteArrayOutputStream();
        extension.getStringTable().serializeTo(nameStream);
        this.write(destDir, BuiltInsSerializedResourcePaths.INSTANCE.getStringTableFilePath(fqName2), nameStream, BuiltInsSerializedResourcePaths.INSTANCE.getFallbackPaths().getStringTableFilePath(fqName2));
    }

    /*
     * WARNING - void declaration
     */
    private final void write(File destDir, String fileName, ByteArrayOutputStream stream, String legacyFileName) {
        Unit unit;
        this.totalSize += stream.size();
        int n = this.totalFiles++;
        new File(destDir, fileName).getParentFile().mkdirs();
        File file = new File(destDir, fileName);
        byte[] byArray = stream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "stream.toByteArray()");
        FilesKt.writeBytes(file, byArray);
        String string = legacyFileName;
        if (string != null) {
            void $receiver;
            String string2 = string;
            String fileName2 = (String)$receiver;
            File file2 = new File(destDir, fileName2);
            byte[] byArray2 = stream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray2, "stream.toByteArray()");
            FilesKt.writeBytes(file2, byArray2);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    static /* bridge */ /* synthetic */ void write$default(BuiltInsSerializer builtInsSerializer, File file, String string, ByteArrayOutputStream byteArrayOutputStream, String string2, int n) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        builtInsSerializer.write(file, string, byteArrayOutputStream, string2);
    }

    private final void serializeClass(ClassDescriptor classDescriptor, BuiltInsSerializerExtension serializer, Function2<? super ClassDescriptor, ? super ProtoBuf.Class, ? extends Unit> writeClass) {
        ProtoBuf.Class classProto;
        ProtoBuf.Class clazz = classProto = DescriptorSerializer.createTopLevel(serializer).classProto(classDescriptor).build();
        Intrinsics.checkExpressionValueIsNotNull(clazz, "classProto");
        writeClass.invoke(classDescriptor, clazz);
        this.serializeClasses(ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptor.getUnsubstitutedInnerClassesScope(), null, null, 3), serializer, writeClass);
    }

    private final void serializeClasses(Collection<? extends DeclarationDescriptor> descriptors, BuiltInsSerializerExtension serializer, Function2<? super ClassDescriptor, ? super ProtoBuf.Class, ? extends Unit> writeClass) {
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            if (!(declarationDescriptor instanceof ClassDescriptor) || !(Intrinsics.areEqual((Object)((ClassDescriptor)declarationDescriptor).getKind(), (Object)ClassKind.ENUM_ENTRY) ^ true)) continue;
            this.serializeClass((ClassDescriptor)declarationDescriptor, serializer, writeClass);
        }
    }

    private final String getFileName(ClassDescriptor classDescriptor) {
        return BuiltInsSerializedResourcePaths.INSTANCE.getClassMetadataPath(DescriptorUtilsKt.getClassId(classDescriptor));
    }

    public BuiltInsSerializer(boolean dependOnOldBuiltIns) {
        this.dependOnOldBuiltIns = dependOnOldBuiltIns;
    }

    @NotNull
    public static final /* synthetic */ String access$getFileName(BuiltInsSerializer $this, @NotNull ClassDescriptor classDescriptor) {
        return $this.getFileName(classDescriptor);
    }

    public static final /* synthetic */ void access$write(BuiltInsSerializer $this, @NotNull File destDir, @NotNull String fileName, @NotNull ByteArrayOutputStream stream, @Nullable String legacyFileName) {
        $this.write(destDir, fileName, stream, legacyFileName);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t!\u0015\u0001Q!\u0001\u0007\u0002\t\u0005\u0013A\u0002A\r\u00021\u0003\t+!U\u0002\u0002\u0011\u0005)s\u0001B\u0006\t\t5!\u0011BA\u0005\u00021\u0001AJ!\n\u0003\u0005\u0017!)Q\"\u0001M\u0006S3!1\n\u0003E\u0002\u001b\u000fA\"!U\u0002\u0002\t\u000b\t6\u0001B\u0003\u0001\u001b\t!1\u0001c\u0002"}, strings={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$BuiltinsSourcesModule;", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "(Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "dependencies", "", "dependencyOnBuiltins", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo$DependencyOnBuiltins;"}, moduleName="kotlin-compiler")
    private final class BuiltinsSourcesModule
    implements ModuleInfo {
        @NotNull
        private final Name name = Name.special("<module for resolving builtin source files>");

        @Override
        @NotNull
        public Name getName() {
            return this.name;
        }

        @NotNull
        public List<BuiltinsSourcesModule> dependencies() {
            return CollectionsKt.listOf(this);
        }

        @Override
        @NotNull
        public ModuleInfo.DependencyOnBuiltins dependencyOnBuiltins() {
            return BuiltInsSerializer.this.dependOnOldBuiltIns ? ModuleInfo.DependenciesOnBuiltins.LAST : ModuleInfo.DependenciesOnBuiltins.NONE;
        }

        @Override
        public boolean isLibrary() {
            return ModuleInfo.DefaultImpls.isLibrary(this);
        }

        @Override
        @NotNull
        public Collection<ModuleInfo> friends() {
            return ModuleInfo.DefaultImpls.friends(this);
        }

        @Override
        @NotNull
        public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
            return ModuleInfo.DefaultImpls.getCapabilities(this);
        }
    }
}

