/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.HashSet;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.PerformanceCounter;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0005\u00031\u0001\u0001#B\r\u00021\u0003i\n!BQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&\"\u0011Q\u0001RA\u0007\u0002I\r\t\"\u0001\u0002\u0001\t\u0007e1\u0001rA\u0007\u0005\u0013\tI\u0011\u0001J\u0002\u0019\tE\u001b\u0011\u0001#\u0003"}, strings={"Lorg/jetbrains/kotlin/util/ReenterableCounter;", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "name", "", "(Ljava/lang/String;)V", "countTime", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion"}, moduleName="kotlin-compiler")
public final class ReenterableCounter
extends PerformanceCounter {
    private static final ThreadLocal<Set<ReenterableCounter>> enteredCounters;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.util.ReenterableCounter$Companion.INSTANCE;
        enteredCounters = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T countTime(@NotNull Function0<? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        long startTime = PerformanceCounter.Companion.currentTime();
        boolean needTime = ReenterableCounter.Companion.enterCounter(this);
        try {
            T t = block.invoke();
            return t;
        }
        finally {
            if (needTime) {
                this.incrementTime(PerformanceCounter.Companion.currentTime() - startTime);
                ReenterableCounter.Companion.leaveCounter(this);
            }
        }
    }

    public ReenterableCounter(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        super(name);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001E\u0012\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u00012B\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ\u0005\u0003\u0003\u0002\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u0004K!!\u0011\u0001\u0003\u0004\u000e\u0003a5\u0011d\u0001E\u0006\u001b\u0005A2!K\t\u0005\u0003\"A\u0019!D\u0004\n\u000b%!\u0011BA\u0005\u00021\rA*\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011\u001d\u0001\u0002\u0002"}, strings={"Lorg/jetbrains/kotlin/util/ReenterableCounter$Companion;", "", "()V", "enteredCounters", "Ljava/lang/ThreadLocal;", "", "Lorg/jetbrains/kotlin/util/ReenterableCounter;", "getEnteredCounters", "()Ljava/lang/ThreadLocal;", "enterCounter", "", "counter", "leaveCounter", ""}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final ThreadLocal<Set<ReenterableCounter>> getEnteredCounters() {
            return enteredCounters;
        }

        private final boolean enterCounter(ReenterableCounter counter) {
            PerformanceCounter.Companion companion = PerformanceCounter.Companion;
            ThreadLocal<Set<ReenterableCounter>> threadLocal = this.getEnteredCounters();
            Set<ReenterableCounter> value2 = threadLocal.get();
            if (value2 == null) {
                value2 = new HashSet<ReenterableCounter>();
                threadLocal.set(value2);
            }
            return value2.add(counter);
        }

        private final void leaveCounter(ReenterableCounter counter) {
            Set<ReenterableCounter> set = this.getEnteredCounters().get();
            Boolean bl = set != null ? Boolean.valueOf(set.remove(counter)) : null;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

