/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.artifacts.DirectoryAntCopyInstructionCreator;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Base64Converter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.packaging.AbstractJavaFxPackager;
import org.jetbrains.plugins.javaFX.packaging.JavaFxAntGenerator;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationArtifactType;
import org.jetbrains.plugins.javaFX.packaging.JavaFxArtifactProperties;
import org.jetbrains.plugins.javaFX.packaging.JavaFxArtifactPropertiesProvider;

public class JavaFxChunkBuildExtension
extends ChunkBuildExtension {
    @NonNls
    public static final String ARTIFACT_VENDOR_SIGN_PROPERTY = "artifact.sign.vendor";
    @NonNls
    public static final String ARTIFACT_ALIAS_SIGN_PROPERTY = "artifact.sign.alias";
    @NonNls
    public static final String ARTIFACT_KEYSTORE_SIGN_PROPERTY = "artifact.sign.keystore";
    @NonNls
    public static final String ARTIFACT_STOREPASS_SIGN_PROPERTY = "artifact.sign.storepass";
    @NonNls
    public static final String ARTIFACTKEYPASS_SIGN_PROPERTY = "artifact.sign.keypass";

    @NotNull
    public String[] getTargets(ModuleChunk chunk) {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/packaging/ant/JavaFxChunkBuildExtension", "getTargets"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void process(Project project, ModuleChunk chunk, GenerationOptions genOptions, CompositeGenerator generator) {
    }

    public void initArtifacts(Project project, GenerationOptions genOptions, CompositeGenerator generator) {
        Collection artifacts = ArtifactManager.getInstance((Project)project).getArtifactsByType((ArtifactType)JavaFxApplicationArtifactType.getInstance());
        if (artifacts.isEmpty()) {
            return;
        }
        Sdk[] jdks = BuildProperties.getUsedJdks((Project)project);
        Sdk javaSdk = null;
        for (Sdk jdk : jdks) {
            if (!(jdk.getSdkType() instanceof JavaSdkType)) continue;
            javaSdk = jdk;
            break;
        }
        if (javaSdk != null) {
            Tag taskdef = new Tag("taskdef", new Pair[]{Couple.of((Object)"resource", (Object)"com/sun/javafx/tools/ant/antlib.xml"), Couple.of((Object)"uri", (Object)"javafx:com.sun.javafx.tools.ant"), Couple.of((Object)"classpath", (Object)(BuildProperties.propertyRef((String)BuildProperties.getJdkHomeProperty((String)javaSdk.getName())) + "/lib/ant-javafx.jar"))});
            generator.add((Generator)taskdef);
        }
    }

    protected List<? extends Generator> computeChildrenGenerators(PackagingElementResolvingContext resolvingContext, AntCopyInstructionCreator copyInstructionCreator, ArtifactAntGenerationContext generationContext, ArtifactType artifactType, List<PackagingElement<?>> children) {
        ArrayList generators = new ArrayList();
        for (PackagingElement<?> child : children) {
            generators.addAll(child.computeAntInstructions(resolvingContext, copyInstructionCreator, generationContext, artifactType));
        }
        return generators;
    }

    public void generateTasksForArtifact(Artifact artifact, boolean preprocessing, ArtifactAntGenerationContext context, CompositeGenerator generator) {
        if (preprocessing) {
            return;
        }
        if (!(artifact.getArtifactType() instanceof JavaFxApplicationArtifactType)) {
            return;
        }
        CompositePackagingElement rootElement = artifact.getRootElement();
        ArrayList children = new ArrayList();
        String artifactFileName = rootElement.getName();
        for (PackagingElement child : rootElement.getChildren()) {
            if (child instanceof ArchivePackagingElement) {
                artifactFileName = ((ArchivePackagingElement)child).getArchiveFileName();
                children.addAll(((ArchivePackagingElement)child).getChildren());
                continue;
            }
            children.add(child);
        }
        String artifactName = FileUtil.getNameWithoutExtension((String)artifactFileName);
        String tempDirPath = BuildProperties.propertyRef((String)context.createNewTempFileProperty("artifact.temp.output." + artifactName, artifactFileName));
        PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)context.getProject()).getResolvingContext();
        for (Generator generator2 : this.computeChildrenGenerators(resolvingContext, (AntCopyInstructionCreator)new DirectoryAntCopyInstructionCreator(tempDirPath), context, artifact.getArtifactType(), children)) {
            generator.add(generator2);
        }
        JavaFxArtifactProperties properties = (JavaFxArtifactProperties)artifact.getProperties((ArtifactPropertiesProvider)JavaFxArtifactPropertiesProvider.getInstance());
        JavaFxArtifactProperties.JavaFxPackager javaFxPackager = new JavaFxArtifactProperties.JavaFxPackager(artifact, properties, context.getProject()){

            protected void registerJavaFxPackagerError(String message) {
            }
        };
        List tags = JavaFxAntGenerator.createJarAndDeployTasks((AbstractJavaFxPackager)javaFxPackager, (String)artifactFileName, (String)artifact.getName(), (String)tempDirPath);
        for (JavaFxAntGenerator.SimpleTag tag : tags) {
            JavaFxChunkBuildExtension.buildTags(generator, tag);
        }
        if (properties.isEnabledSigning()) {
            boolean selfSigning = properties.isSelfSigning();
            String vendor = properties.getVendor();
            if (vendor != null) {
                vendor = vendor.replaceAll(",", "\\\\,");
            }
            generator.add((Generator)new Property(JavaFxChunkBuildExtension.artifactBasedProperty(ARTIFACT_VENDOR_SIGN_PROPERTY, artifactName), "CN=" + vendor));
            String alias = selfSigning ? "jb" : properties.getAlias();
            generator.add((Generator)new Property(JavaFxChunkBuildExtension.artifactBasedProperty(ARTIFACT_ALIAS_SIGN_PROPERTY, artifactName), alias));
            String keystore = selfSigning ? tempDirPath + File.separator + "jb-key.jks" : properties.getKeystore();
            generator.add((Generator)new Property(JavaFxChunkBuildExtension.artifactBasedProperty(ARTIFACT_KEYSTORE_SIGN_PROPERTY, artifactName), keystore));
            String storepass = selfSigning ? "storepass" : Base64Converter.decode((String)properties.getStorepass());
            generator.add((Generator)new Property(JavaFxChunkBuildExtension.artifactBasedProperty(ARTIFACT_STOREPASS_SIGN_PROPERTY, artifactName), storepass));
            String keypass = selfSigning ? "keypass" : Base64Converter.decode((String)properties.getKeypass());
            generator.add((Generator)new Property(JavaFxChunkBuildExtension.artifactBasedProperty(ARTIFACTKEYPASS_SIGN_PROPERTY, artifactName), keypass));
            Object[] keysDescriptions = JavaFxChunkBuildExtension.createKeysDescriptions(artifactName);
            if (selfSigning) {
                generator.add((Generator)new Tag("genkey", (Pair[])ArrayUtil.prepend((Object)Couple.of((Object)"dname", (Object)BuildProperties.propertyRef((String)JavaFxChunkBuildExtension.artifactBasedProperty(ARTIFACT_VENDOR_SIGN_PROPERTY, artifactName))), (Object[])keysDescriptions)));
            }
            Tag signjar = new Tag("signjar", (Pair[])keysDescriptions);
            Tag fileset = new Tag("fileset", new Pair[]{Couple.of((Object)"dir", (Object)(tempDirPath + "/deploy"))});
            fileset.add((Generator)new Tag("include", new Pair[]{Couple.of((Object)"name", (Object)"*.jar")}));
            signjar.add((Generator)fileset);
            generator.add((Generator)signjar);
        }
        DirectoryAntCopyInstructionCreator creator = new DirectoryAntCopyInstructionCreator(BuildProperties.propertyRef((String)context.getConfiguredArtifactOutputProperty(artifact)));
        generator.add((Generator)creator.createDirectoryContentCopyInstruction(tempDirPath + "/deploy"));
        Tag deleteTag = new Tag("delete", new Pair[]{Couple.of((Object)"includeemptydirs", (Object)"true")});
        deleteTag.add((Generator)new Tag("fileset", new Pair[]{Couple.of((Object)"dir", (Object)tempDirPath)}));
        generator.add((Generator)deleteTag);
    }

    private static void buildTags(CompositeGenerator generator, final JavaFxAntGenerator.SimpleTag tag) {
        Tag newTag = new Tag(tag.getName(), tag.getPairs()){

            public void generate(PrintWriter out) throws IOException {
                String value = tag.getValue();
                if (value == null) {
                    super.generate(out);
                } else {
                    out.print("<" + tag.getName() + ">" + value + "</" + tag.getName() + ">");
                }
            }
        };
        for (JavaFxAntGenerator.SimpleTag simpleTag : tag.getSubTags()) {
            JavaFxChunkBuildExtension.buildTags((CompositeGenerator)newTag, simpleTag);
        }
        generator.add((Generator)newTag);
    }

    private static String artifactBasedProperty(String property, String artifactName) {
        return property + "." + artifactName;
    }

    private static Pair[] createKeysDescriptions(String artifactName) {
        return new Pair[]{Couple.of((Object)"alias", (Object)BuildProperties.propertyRef((String)JavaFxChunkBuildExtension.artifactBasedProperty(ARTIFACT_ALIAS_SIGN_PROPERTY, artifactName))), Couple.of((Object)"keystore", (Object)BuildProperties.propertyRef((String)JavaFxChunkBuildExtension.artifactBasedProperty(ARTIFACT_KEYSTORE_SIGN_PROPERTY, artifactName))), Couple.of((Object)"storepass", (Object)BuildProperties.propertyRef((String)JavaFxChunkBuildExtension.artifactBasedProperty(ARTIFACT_STOREPASS_SIGN_PROPERTY, artifactName))), Couple.of((Object)"keypass", (Object)BuildProperties.propertyRef((String)JavaFxChunkBuildExtension.artifactBasedProperty(ARTIFACTKEYPASS_SIGN_PROPERTY, artifactName)))};
    }

    @Nullable
    public Couple<String> getArtifactXmlNs(ArtifactType artifactType) {
        if (artifactType instanceof JavaFxApplicationArtifactType) {
            return Couple.of((Object)"xmlns:fx", (Object)"javafx:com.sun.javafx.tools.ant");
        }
        return null;
    }

    public boolean needAntArtifactInstructions(ArtifactType type) {
        return !(type instanceof JavaFxApplicationArtifactType);
    }
}

