/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Generics;
import com.esotericsoftware.kryo.KryoCopyable;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.ReferenceResolver;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.StreamFactory;
import com.esotericsoftware.kryo.factories.PseudoSerializerFactory;
import com.esotericsoftware.kryo.factories.ReflectionSerializerFactory;
import com.esotericsoftware.kryo.factories.SerializerFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.DefaultArraySerializers;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import com.esotericsoftware.kryo.util.DefaultClassResolver;
import com.esotericsoftware.kryo.util.DefaultStreamFactory;
import com.esotericsoftware.kryo.util.FastestStreamFactory;
import com.esotericsoftware.kryo.util.IdentityMap;
import com.esotericsoftware.kryo.util.IntArray;
import com.esotericsoftware.kryo.util.MapReferenceResolver;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.reflectasm.ConstructorAccess;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.strategy.InstantiatorStrategy;

public class Kryo {
    public static final byte NULL = 0;
    public static final byte NOT_NULL = 1;
    private static final int REF = -1;
    private static final int NO_REF = -2;
    private SerializerFactory defaultSerializer = new ReflectionSerializerFactory(FieldSerializer.class);
    private final ArrayList<DefaultSerializerEntry> defaultSerializers = new ArrayList(32);
    private final int lowPriorityDefaultSerializerCount;
    private final ClassResolver classResolver;
    private int nextRegisterID;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private InstantiatorStrategy strategy;
    private boolean registrationRequired;
    private int depth;
    private int maxDepth = Integer.MAX_VALUE;
    private boolean autoReset = true;
    private volatile Thread thread;
    private ObjectMap context;
    private ObjectMap graphContext;
    private ReferenceResolver referenceResolver;
    private final IntArray readReferenceIds = new IntArray(0);
    private boolean references;
    private Object readObject;
    private int copyDepth;
    private boolean copyShallow;
    private IdentityMap originalToCopy;
    private Object needsCopyReference;
    private Generics genericsScope;
    private boolean asmEnabled = false;
    private StreamFactory streamFactory;

    public Kryo() {
        this(new DefaultClassResolver(), new MapReferenceResolver(), new DefaultStreamFactory());
    }

    public Kryo(ReferenceResolver referenceResolver) {
        this(new DefaultClassResolver(), referenceResolver, new DefaultStreamFactory());
    }

    public Kryo(ClassResolver classResolver, ReferenceResolver referenceResolver) {
        this(classResolver, referenceResolver, new DefaultStreamFactory());
    }

    public Kryo(ClassResolver classResolver, ReferenceResolver referenceResolver, StreamFactory streamFactory) {
        if (classResolver == null) {
            throw new IllegalArgumentException("classResolver cannot be null.");
        }
        this.classResolver = classResolver;
        classResolver.setKryo(this);
        this.streamFactory = streamFactory;
        streamFactory.setKryo(this);
        this.referenceResolver = referenceResolver;
        if (referenceResolver != null) {
            referenceResolver.setKryo(this);
            this.references = true;
        }
        this.addDefaultSerializer(byte[].class, DefaultArraySerializers.ByteArraySerializer.class);
        this.addDefaultSerializer(char[].class, DefaultArraySerializers.CharArraySerializer.class);
        this.addDefaultSerializer(short[].class, DefaultArraySerializers.ShortArraySerializer.class);
        this.addDefaultSerializer(int[].class, DefaultArraySerializers.IntArraySerializer.class);
        this.addDefaultSerializer(long[].class, DefaultArraySerializers.LongArraySerializer.class);
        this.addDefaultSerializer(float[].class, DefaultArraySerializers.FloatArraySerializer.class);
        this.addDefaultSerializer(double[].class, DefaultArraySerializers.DoubleArraySerializer.class);
        this.addDefaultSerializer(boolean[].class, DefaultArraySerializers.BooleanArraySerializer.class);
        this.addDefaultSerializer(String[].class, DefaultArraySerializers.StringArraySerializer.class);
        this.addDefaultSerializer(Object[].class, DefaultArraySerializers.ObjectArraySerializer.class);
        this.addDefaultSerializer(BigInteger.class, DefaultSerializers.BigIntegerSerializer.class);
        this.addDefaultSerializer(BigDecimal.class, DefaultSerializers.BigDecimalSerializer.class);
        this.addDefaultSerializer(Class.class, DefaultSerializers.ClassSerializer.class);
        this.addDefaultSerializer(Date.class, DefaultSerializers.DateSerializer.class);
        this.addDefaultSerializer(Enum.class, DefaultSerializers.EnumSerializer.class);
        this.addDefaultSerializer(EnumSet.class, DefaultSerializers.EnumSetSerializer.class);
        this.addDefaultSerializer(Currency.class, DefaultSerializers.CurrencySerializer.class);
        this.addDefaultSerializer(StringBuffer.class, DefaultSerializers.StringBufferSerializer.class);
        this.addDefaultSerializer(StringBuilder.class, DefaultSerializers.StringBuilderSerializer.class);
        this.addDefaultSerializer(Collections.EMPTY_LIST.getClass(), DefaultSerializers.CollectionsEmptyListSerializer.class);
        this.addDefaultSerializer(Collections.EMPTY_MAP.getClass(), DefaultSerializers.CollectionsEmptyMapSerializer.class);
        this.addDefaultSerializer(Collections.EMPTY_SET.getClass(), DefaultSerializers.CollectionsEmptySetSerializer.class);
        this.addDefaultSerializer(Collections.singletonList(null).getClass(), DefaultSerializers.CollectionsSingletonListSerializer.class);
        this.addDefaultSerializer(Collections.singletonMap(null, null).getClass(), DefaultSerializers.CollectionsSingletonMapSerializer.class);
        this.addDefaultSerializer(Collections.singleton(null).getClass(), DefaultSerializers.CollectionsSingletonSetSerializer.class);
        this.addDefaultSerializer(Collection.class, CollectionSerializer.class);
        this.addDefaultSerializer(TreeMap.class, DefaultSerializers.TreeMapSerializer.class);
        this.addDefaultSerializer(Map.class, MapSerializer.class);
        this.addDefaultSerializer(KryoSerializable.class, DefaultSerializers.KryoSerializableSerializer.class);
        this.addDefaultSerializer(TimeZone.class, DefaultSerializers.TimeZoneSerializer.class);
        this.addDefaultSerializer(Calendar.class, DefaultSerializers.CalendarSerializer.class);
        this.lowPriorityDefaultSerializerCount = this.defaultSerializers.size();
        this.register(Integer.TYPE, new DefaultSerializers.IntSerializer());
        this.register(String.class, new DefaultSerializers.StringSerializer());
        this.register(Float.TYPE, new DefaultSerializers.FloatSerializer());
        this.register(Boolean.TYPE, new DefaultSerializers.BooleanSerializer());
        this.register(Byte.TYPE, new DefaultSerializers.ByteSerializer());
        this.register(Character.TYPE, new DefaultSerializers.CharSerializer());
        this.register(Short.TYPE, new DefaultSerializers.ShortSerializer());
        this.register(Long.TYPE, new DefaultSerializers.LongSerializer());
        this.register(Double.TYPE, new DefaultSerializers.DoubleSerializer());
        this.register(Void.TYPE, new DefaultSerializers.VoidSerializer());
    }

    public void setDefaultSerializer(SerializerFactory serializerFactory) {
        if (serializerFactory == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.defaultSerializer = serializerFactory;
    }

    public void setDefaultSerializer(Class<? extends Serializer> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.defaultSerializer = new ReflectionSerializerFactory(clazz);
    }

    public void addDefaultSerializer(Class clazz, Serializer serializer) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        DefaultSerializerEntry defaultSerializerEntry = new DefaultSerializerEntry(clazz, new PseudoSerializerFactory(serializer));
        this.defaultSerializers.add(this.defaultSerializers.size() - this.lowPriorityDefaultSerializerCount, defaultSerializerEntry);
    }

    public void addDefaultSerializer(Class clazz, SerializerFactory serializerFactory) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializerFactory == null) {
            throw new IllegalArgumentException("serializerFactory cannot be null.");
        }
        DefaultSerializerEntry defaultSerializerEntry = new DefaultSerializerEntry(clazz, serializerFactory);
        this.defaultSerializers.add(this.defaultSerializers.size() - this.lowPriorityDefaultSerializerCount, defaultSerializerEntry);
    }

    public void addDefaultSerializer(Class clazz, Class<? extends Serializer> clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("serializerClass cannot be null.");
        }
        DefaultSerializerEntry defaultSerializerEntry = new DefaultSerializerEntry(clazz, new ReflectionSerializerFactory(clazz2));
        this.defaultSerializers.add(this.defaultSerializers.size() - this.lowPriorityDefaultSerializerCount, defaultSerializerEntry);
    }

    public Serializer getDefaultSerializer(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (clazz.isAnnotationPresent(DefaultSerializer.class)) {
            DefaultSerializer defaultSerializer = clazz.getAnnotation(DefaultSerializer.class);
            return ReflectionSerializerFactory.makeSerializer(this, defaultSerializer.value(), clazz);
        }
        int n = this.defaultSerializers.size();
        for (int i = 0; i < n; ++i) {
            DefaultSerializerEntry defaultSerializerEntry = this.defaultSerializers.get(i);
            if (!defaultSerializerEntry.type.isAssignableFrom(clazz)) continue;
            return defaultSerializerEntry.serializerFactory.makeSerializer(this, clazz);
        }
        return this.newDefaultSerializer(clazz);
    }

    protected Serializer newDefaultSerializer(Class clazz) {
        return this.defaultSerializer.makeSerializer(this, clazz);
    }

    public Serializer newSerializer(Class<? extends Serializer> clazz, Class clazz2) {
        try {
            try {
                return clazz.getConstructor(Kryo.class, Class.class).newInstance(this, clazz2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return clazz.getConstructor(Kryo.class).newInstance(this);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    try {
                        return clazz.getConstructor(Class.class).newInstance(clazz2);
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        return clazz.newInstance();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to create serializer \"" + clazz.getName() + "\" for class: " + Util.className(clazz2), exception);
        }
    }

    public Registration register(Class clazz) {
        Registration registration = this.classResolver.getRegistration(clazz);
        if (registration != null) {
            return registration;
        }
        return this.register(clazz, this.getDefaultSerializer(clazz));
    }

    public Registration register(Class clazz, int n) {
        Registration registration = this.classResolver.getRegistration(clazz);
        if (registration != null) {
            return registration;
        }
        return this.register(clazz, this.getDefaultSerializer(clazz), n);
    }

    public Registration register(Class clazz, Serializer serializer) {
        Registration registration = this.classResolver.getRegistration(clazz);
        if (registration != null) {
            registration.setSerializer(serializer);
            return registration;
        }
        return this.classResolver.register(new Registration(clazz, serializer, this.getNextRegistrationId()));
    }

    public Registration register(Class clazz, Serializer serializer, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("id must be >= 0: " + n);
        }
        return this.register(new Registration(clazz, serializer, n));
    }

    public Registration register(Registration registration) {
        int n = registration.getId();
        if (n < 0) {
            throw new IllegalArgumentException("id must be > 0: " + n);
        }
        Registration registration2 = this.getRegistration(registration.getId());
        if (registration2 != null && registration2.getType() != registration.getType()) {
            throw new KryoException("An existing registration with a different type already uses ID: " + registration.getId() + "\nExisting registration: " + registration2 + "\nUnable to set registration: " + registration);
        }
        return this.classResolver.register(registration);
    }

    public int getNextRegistrationId() {
        while (this.nextRegisterID != -2) {
            if (this.classResolver.getRegistration(this.nextRegisterID) == null) {
                return this.nextRegisterID;
            }
            ++this.nextRegisterID;
        }
        throw new KryoException("No registration IDs are available.");
    }

    public Registration getRegistration(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        Registration registration = this.classResolver.getRegistration(clazz);
        if (registration == null) {
            if (Proxy.isProxyClass(clazz)) {
                registration = this.getRegistration(InvocationHandler.class);
            } else if (!clazz.isEnum() && Enum.class.isAssignableFrom(clazz)) {
                registration = this.getRegistration(clazz.getEnclosingClass());
            } else if (EnumSet.class.isAssignableFrom(clazz)) {
                registration = this.classResolver.getRegistration(EnumSet.class);
            }
            if (registration == null) {
                if (this.registrationRequired) {
                    throw new IllegalArgumentException("Class is not registered: " + Util.className(clazz) + "\nNote: To register this class use: kryo.register(" + Util.className(clazz) + ".class);");
                }
                registration = this.classResolver.registerImplicit(clazz);
            }
        }
        return registration;
    }

    public Registration getRegistration(int n) {
        return this.classResolver.getRegistration(n);
    }

    public Serializer getSerializer(Class clazz) {
        return this.getRegistration(clazz).getSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration writeClass(Output output, Class clazz) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        try {
            Registration registration = this.classResolver.writeClass(output, clazz);
            return registration;
        }
        finally {
            if (this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Output output, Object object) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.beginObject();
        try {
            if (this.references && this.writeReferenceOrNull(output, object, false)) {
                this.getRegistration(object.getClass()).getSerializer().setGenerics(this, null);
                return;
            }
            this.getRegistration(object.getClass()).getSerializer().write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Output output, Object object, Serializer serializer) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            if (this.references && this.writeReferenceOrNull(output, object, false)) {
                serializer.setGenerics(this, null);
                return;
            }
            serializer.write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObjectOrNull(Output output, Object object, Class clazz) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        this.beginObject();
        try {
            Serializer serializer = this.getRegistration(clazz).getSerializer();
            if (this.references) {
                if (this.writeReferenceOrNull(output, object, true)) {
                    serializer.setGenerics(this, null);
                    return;
                }
            } else if (!serializer.getAcceptsNull()) {
                if (object == null) {
                    output.writeByte((byte)0);
                    return;
                }
                output.writeByte((byte)1);
            }
            serializer.write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObjectOrNull(Output output, Object object, Serializer serializer) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            if (this.references) {
                if (this.writeReferenceOrNull(output, object, true)) {
                    serializer.setGenerics(this, null);
                    return;
                }
            } else if (!serializer.getAcceptsNull()) {
                if (object == null) {
                    output.writeByte((byte)0);
                    return;
                }
                output.writeByte((byte)1);
            }
            serializer.write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClassAndObject(Output output, Object object) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        this.beginObject();
        try {
            if (object == null) {
                this.writeClass(output, null);
                return;
            }
            Registration registration = this.writeClass(output, object.getClass());
            if (this.references && this.writeReferenceOrNull(output, object, false)) {
                registration.getSerializer().setGenerics(this, null);
                return;
            }
            registration.getSerializer().write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    boolean writeReferenceOrNull(Output output, Object object, boolean bl) {
        if (object == null) {
            output.writeVarInt(0, true);
            return true;
        }
        if (!this.referenceResolver.useReferences(object.getClass())) {
            if (bl) {
                output.writeVarInt(1, true);
            }
            return false;
        }
        int n = this.referenceResolver.getWrittenId(object);
        if (n != -1) {
            output.writeVarInt(n + 2, true);
            return true;
        }
        n = this.referenceResolver.addWrittenObject(object);
        output.writeVarInt(1, true);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration readClass(Input input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        try {
            Registration registration = this.classResolver.readClass(input);
            return registration;
        }
        finally {
            if (this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(Input input, Class<T> clazz) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.beginObject();
        try {
            T t;
            if (this.references) {
                int n = this.readReferenceOrNull(input, clazz, false);
                if (n == -1) {
                    Object object = this.readObject;
                    return (T)object;
                }
                t = this.getRegistration(clazz).getSerializer().read(this, input, clazz);
                if (n == this.readReferenceIds.size) {
                    this.reference(t);
                }
            } else {
                t = this.getRegistration(clazz).getSerializer().read(this, input, clazz);
            }
            T t2 = t;
            return t2;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(Input input, Class<T> clazz, Serializer serializer) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            T t;
            if (this.references) {
                int n = this.readReferenceOrNull(input, clazz, false);
                if (n == -1) {
                    Object object = this.readObject;
                    return (T)object;
                }
                t = serializer.read(this, input, clazz);
                if (n == this.readReferenceIds.size) {
                    this.reference(t);
                }
            } else {
                t = serializer.read(this, input, clazz);
            }
            T t2 = t;
            return t2;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObjectOrNull(Input input, Class<T> clazz) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.beginObject();
        try {
            T t;
            if (this.references) {
                int n = this.readReferenceOrNull(input, clazz, true);
                if (n == -1) {
                    Object object = this.readObject;
                    return (T)object;
                }
                t = this.getRegistration(clazz).getSerializer().read(this, input, clazz);
                if (n == this.readReferenceIds.size) {
                    this.reference(t);
                }
            } else {
                Serializer serializer = this.getRegistration(clazz).getSerializer();
                if (!serializer.getAcceptsNull() && input.readByte() == 0) {
                    T t2 = null;
                    return t2;
                }
                t = serializer.read(this, input, clazz);
            }
            T t3 = t;
            return t3;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObjectOrNull(Input input, Class<T> clazz, Serializer serializer) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            T t;
            if (this.references) {
                int n = this.readReferenceOrNull(input, clazz, true);
                if (n == -1) {
                    Object object = this.readObject;
                    return (T)object;
                }
                t = serializer.read(this, input, clazz);
                if (n == this.readReferenceIds.size) {
                    this.reference(t);
                }
            } else {
                if (!serializer.getAcceptsNull() && input.readByte() == 0) {
                    T t2 = null;
                    return t2;
                }
                t = serializer.read(this, input, clazz);
            }
            T t3 = t;
            return t3;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readClassAndObject(Input input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        this.beginObject();
        try {
            Object t;
            Registration registration = this.readClass(input);
            if (registration == null) {
                Object var3_3 = null;
                return var3_3;
            }
            Class clazz = registration.getType();
            if (this.references) {
                registration.getSerializer().setGenerics(this, null);
                int n = this.readReferenceOrNull(input, clazz, false);
                if (n == -1) {
                    Object object = this.readObject;
                    return object;
                }
                t = registration.getSerializer().read(this, input, clazz);
                if (n == this.readReferenceIds.size) {
                    this.reference(t);
                }
            } else {
                t = registration.getSerializer().read(this, input, clazz);
            }
            Object t2 = t;
            return t2;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    int readReferenceOrNull(Input input, Class clazz, boolean bl) {
        int n;
        if (clazz.isPrimitive()) {
            clazz = Util.getWrapperClass(clazz);
        }
        boolean bl2 = this.referenceResolver.useReferences(clazz);
        if (bl) {
            n = input.readVarInt(true);
            if (n == 0) {
                this.readObject = null;
                return -1;
            }
            if (!bl2) {
                this.readReferenceIds.add(-2);
                return this.readReferenceIds.size;
            }
        } else {
            if (!bl2) {
                this.readReferenceIds.add(-2);
                return this.readReferenceIds.size;
            }
            n = input.readVarInt(true);
        }
        if (n == 1) {
            n = this.referenceResolver.nextReadId(clazz);
            this.readReferenceIds.add(n);
            return this.readReferenceIds.size;
        }
        this.readObject = this.referenceResolver.getReadObject(clazz, n -= 2);
        return -1;
    }

    public void reference(Object object) {
        int n;
        if (this.copyDepth > 0) {
            if (this.needsCopyReference != null) {
                if (object == null) {
                    throw new IllegalArgumentException("object cannot be null.");
                }
                this.originalToCopy.put(this.needsCopyReference, object);
                this.needsCopyReference = null;
            }
        } else if (this.references && object != null && (n = this.readReferenceIds.pop()) != -2) {
            this.referenceResolver.setReadObject(n, object);
        }
    }

    public void reset() {
        this.depth = 0;
        if (this.graphContext != null) {
            this.graphContext.clear();
        }
        this.classResolver.reset();
        if (this.references) {
            this.referenceResolver.reset();
            this.readObject = null;
        }
        this.copyDepth = 0;
        if (this.originalToCopy != null) {
            this.originalToCopy.clear(2048);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copy(T t) {
        if (t == null) {
            return null;
        }
        if (this.copyShallow) {
            return t;
        }
        ++this.copyDepth;
        try {
            Object v;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((v = this.originalToCopy.get(t)) != null) {
                Object v2 = v;
                return (T)v2;
            }
            this.needsCopyReference = t;
            Object t2 = t instanceof KryoCopyable ? ((KryoCopyable)t).copy(this) : this.getSerializer(t.getClass()).copy(this, t);
            if (this.needsCopyReference != null) {
                this.reference(t2);
            }
            Object t3 = t2;
            return t3;
        }
        finally {
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copy(T t, Serializer serializer) {
        if (t == null) {
            return null;
        }
        if (this.copyShallow) {
            return t;
        }
        ++this.copyDepth;
        try {
            Object v;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((v = this.originalToCopy.get(t)) != null) {
                Object v2 = v;
                return (T)v2;
            }
            this.needsCopyReference = t;
            Object t2 = t instanceof KryoCopyable ? ((KryoCopyable)t).copy(this) : serializer.copy(this, t);
            if (this.needsCopyReference != null) {
                this.reference(t2);
            }
            Object t3 = t2;
            return t3;
        }
        finally {
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copyShallow(T t) {
        if (t == null) {
            return null;
        }
        ++this.copyDepth;
        this.copyShallow = true;
        try {
            Object v;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((v = this.originalToCopy.get(t)) != null) {
                Object v2 = v;
                return (T)v2;
            }
            this.needsCopyReference = t;
            Object t2 = t instanceof KryoCopyable ? ((KryoCopyable)t).copy(this) : this.getSerializer(t.getClass()).copy(this, t);
            if (this.needsCopyReference != null) {
                this.reference(t2);
            }
            Object t3 = t2;
            return t3;
        }
        finally {
            this.copyShallow = false;
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copyShallow(T t, Serializer serializer) {
        if (t == null) {
            return null;
        }
        ++this.copyDepth;
        this.copyShallow = true;
        try {
            Object v;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((v = this.originalToCopy.get(t)) != null) {
                Object v2 = v;
                return (T)v2;
            }
            this.needsCopyReference = t;
            Object t2 = t instanceof KryoCopyable ? ((KryoCopyable)t).copy(this) : serializer.copy(this, t);
            if (this.needsCopyReference != null) {
                this.reference(t2);
            }
            Object t3 = t2;
            return t3;
        }
        finally {
            this.copyShallow = false;
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    private void beginObject() {
        if (this.depth == this.maxDepth) {
            throw new KryoException("Max depth exceeded: " + this.depth);
        }
        ++this.depth;
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader cannot be null.");
        }
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setRegistrationRequired(boolean bl) {
        this.registrationRequired = bl;
    }

    public boolean isRegistrationRequired() {
        return this.registrationRequired;
    }

    public boolean setReferences(boolean bl) {
        if (bl == this.references) {
            return bl;
        }
        this.references = bl;
        if (bl && this.referenceResolver == null) {
            this.referenceResolver = new MapReferenceResolver();
        }
        return !bl;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            throw new IllegalArgumentException("referenceResolver cannot be null.");
        }
        this.references = true;
        this.referenceResolver = referenceResolver;
    }

    public boolean getReferences() {
        return this.references;
    }

    public void setInstantiatorStrategy(InstantiatorStrategy instantiatorStrategy) {
        this.strategy = instantiatorStrategy;
    }

    protected ObjectInstantiator newInstantiator(final Class clazz) {
        GenericDeclaration genericDeclaration;
        if (!Util.isAndroid) {
            boolean bl;
            genericDeclaration = clazz.getEnclosingClass();
            boolean bl2 = bl = genericDeclaration != null && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
            if (!bl) {
                try {
                    final ConstructorAccess constructorAccess = ConstructorAccess.get((Class)clazz);
                    return new ObjectInstantiator(){

                        public Object newInstance() {
                            try {
                                return constructorAccess.newInstance();
                            }
                            catch (Exception exception) {
                                throw new KryoException("Error constructing instance of class: " + Util.className(clazz), exception);
                            }
                        }
                    };
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            try {
                genericDeclaration = clazz.getConstructor(null);
            }
            catch (Exception exception) {
                genericDeclaration = clazz.getDeclaredConstructor(null);
                ((Constructor)genericDeclaration).setAccessible(true);
            }
            GenericDeclaration genericDeclaration2 = genericDeclaration;
            return new ObjectInstantiator((Constructor)genericDeclaration2, clazz){
                final /* synthetic */ Constructor val$constructor;
                final /* synthetic */ Class val$type;
                {
                    this.val$constructor = constructor;
                    this.val$type = clazz;
                }

                public Object newInstance() {
                    try {
                        return this.val$constructor.newInstance(new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new KryoException("Error constructing instance of class: " + Util.className(this.val$type), exception);
                    }
                }
            };
        }
        catch (Exception exception) {
            if (this.strategy == null) {
                if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
                    throw new KryoException("Class cannot be created (non-static member class): " + Util.className(clazz));
                }
                throw new KryoException("Class cannot be created (missing no-arg constructor): " + Util.className(clazz));
            }
            return this.strategy.newInstantiatorOf(clazz);
        }
    }

    public <T> T newInstance(Class<T> clazz) {
        Registration registration = this.getRegistration(clazz);
        ObjectInstantiator objectInstantiator = registration.getInstantiator();
        if (objectInstantiator == null) {
            objectInstantiator = this.newInstantiator(clazz);
            registration.setInstantiator(objectInstantiator);
        }
        return (T)objectInstantiator.newInstance();
    }

    public ObjectMap getContext() {
        if (this.context == null) {
            this.context = new ObjectMap();
        }
        return this.context;
    }

    public ObjectMap getGraphContext() {
        if (this.graphContext == null) {
            this.graphContext = new ObjectMap();
        }
        return this.graphContext;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setAutoReset(boolean bl) {
        this.autoReset = bl;
    }

    public void setMaxDepth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxDepth must be > 0.");
        }
        this.maxDepth = n;
    }

    public boolean isFinal(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (clazz.isArray()) {
            return Modifier.isFinal(Util.getElementClass(clazz).getModifiers());
        }
        return Modifier.isFinal(clazz.getModifiers());
    }

    public void pushGenericsScope(Class clazz, Generics generics) {
        Generics generics2 = this.genericsScope;
        this.genericsScope = generics;
        this.genericsScope.setParentScope(generics2);
    }

    public void popGenericsScope() {
        Generics generics = this.genericsScope;
        if (this.genericsScope != null) {
            this.genericsScope = this.genericsScope.getParentScope();
        }
        if (generics != null) {
            generics.resetParentScope();
        }
    }

    public Generics getGenericsScope() {
        return this.genericsScope;
    }

    public StreamFactory getStreamFactory() {
        return this.streamFactory;
    }

    public void setStreamFactory(FastestStreamFactory fastestStreamFactory) {
        this.streamFactory = fastestStreamFactory;
    }

    public void setAsmEnabled(boolean bl) {
        this.asmEnabled = bl;
    }

    public boolean getAsmEnabled() {
        return this.asmEnabled;
    }

    static final class DefaultSerializerEntry {
        final Class type;
        final SerializerFactory serializerFactory;

        DefaultSerializerEntry(Class clazz, SerializerFactory serializerFactory) {
            this.type = clazz;
            this.serializerFactory = serializerFactory;
        }
    }
}

