/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.fragments;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.openapi.diagnostic.Logger;

public class DiffFragmentImpl
implements DiffFragment {
    private static final Logger LOG = Logger.getInstance(DiffFragmentImpl.class);
    private final int myStartOffset1;
    private final int myEndOffset1;
    private final int myStartOffset2;
    private final int myEndOffset2;

    public DiffFragmentImpl(int startOffset1, int endOffset1, int startOffset2, int endOffset2) {
        this.myStartOffset1 = startOffset1;
        this.myEndOffset1 = endOffset1;
        this.myStartOffset2 = startOffset2;
        this.myEndOffset2 = endOffset2;
        if (this.myStartOffset1 == this.myEndOffset1 && this.myStartOffset2 == this.myEndOffset2) {
            LOG.error("DiffFragmentImpl should not be empty: " + this.toString());
        }
        if (this.myStartOffset1 > this.myEndOffset1 || this.myStartOffset2 > this.myEndOffset2) {
            LOG.error("DiffFragmentImpl is invalid: " + this.toString());
        }
    }

    @Override
    public int getStartOffset1() {
        return this.myStartOffset1;
    }

    @Override
    public int getEndOffset1() {
        return this.myEndOffset1;
    }

    @Override
    public int getStartOffset2() {
        return this.myStartOffset2;
    }

    @Override
    public int getEndOffset2() {
        return this.myEndOffset2;
    }
}

