/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class RemoteConnection {
    private boolean myUseSockets;
    private boolean myServerMode;
    private String myHostName;
    private String myAddress;
    public static final String ONTHROW = ",onthrow=<FQ exception class name>";
    public static final String ONUNCAUGHT = ",onuncaught=<y/n>";

    public RemoteConnection(boolean useSockets, String hostName, String address, boolean serverMode) {
        this.myUseSockets = useSockets;
        this.myServerMode = serverMode;
        this.myHostName = hostName;
        this.myAddress = address;
    }

    public boolean isUseSockets() {
        return this.myUseSockets;
    }

    public boolean isServerMode() {
        return this.myServerMode;
    }

    public String getHostName() {
        return this.myHostName;
    }

    public String getAddress() {
        return this.myAddress;
    }

    public void setUseSockets(boolean useSockets) {
        this.myUseSockets = useSockets;
    }

    public void setServerMode(boolean serverMode) {
        this.myServerMode = serverMode;
    }

    public void setHostName(String hostName) {
        this.myHostName = hostName;
    }

    public void setAddress(String address) {
        this.myAddress = address;
    }

    public String getLaunchCommandLine() {
        String result;
        String address = this.getAddress();
        boolean shmem = !this.isUseSockets();
        boolean serverMode = this.isServerMode();
        if (shmem) {
            result = serverMode ? "-Xdebug -Xrunjdwp:transport=dt_shmem,server=n,address=" + (address.length() > 0 ? address : "...") + ",suspend=y" + ONTHROW + ONUNCAUGHT : "-Xdebug -Xrunjdwp:transport=dt_shmem,server=y,suspend=n,address=" + (address.length() > 0 ? address : "...");
        } else {
            int p = -1;
            try {
                p = Integer.parseInt(address);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (serverMode) {
                String localHostName = "<host name>:";
                try {
                    InetAddress localAddress = InetAddress.getLocalHost();
                    String name = localAddress.getCanonicalHostName();
                    if (name != null) {
                        localHostName = name + ":";
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                result = "-Xdebug -Xrunjdwp:transport=dt_socket,server=n,address=" + localHostName + (p == -1 ? "<port>" : Integer.toString(p)) + ",suspend=y" + ONTHROW + ONUNCAUGHT;
            } else {
                result = "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + (p == -1 ? "..." : Integer.toString(p));
            }
        }
        return result;
    }
}

