/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class CompositeShortcutSet
implements ShortcutSet {
    private final ShortcutSet[] mySets;

    public CompositeShortcutSet(ShortcutSet ... sets) {
        this.mySets = sets;
    }

    @Override
    @NotNull
    public Shortcut[] getShortcuts() {
        ArrayList result = new ArrayList();
        for (ShortcutSet each : this.mySets) {
            Collections.addAll(result, each.getShortcuts());
        }
        Shortcut[] shortcutArray = result.toArray(new Shortcut[result.size()]);
        if (shortcutArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/CompositeShortcutSet", "getShortcuts"));
        }
        return shortcutArray;
    }
}

