/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataContextWrapper;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretSpecificDataContext
extends DataContextWrapper {
    private final Caret myCaret;

    public CaretSpecificDataContext(@NotNull DataContext delegate, @NotNull Caret caret) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/editor/actionSystem/CaretSpecificDataContext", "<init>"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actionSystem/CaretSpecificDataContext", "<init>"));
        }
        super(delegate);
        this.myCaret = caret;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        Project project = (Project)super.getData(CommonDataKeys.PROJECT.getName());
        if (project == null) {
            return null;
        }
        FileEditorManager fm = FileEditorManager.getInstance(project);
        Object data = fm == null ? null : fm.getData(dataId, this.myCaret.getEditor(), this.myCaret);
        return data == null ? super.getData(dataId) : data;
    }
}

