/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProjectData
implements CoverageData,
Serializable {
    public static final String PROJECT_DATA_OWNER = "com/intellij/rt/coverage/data/ProjectData";
    private static final MethodCaller TOUCH_LINE_METHOD = new MethodCaller("touchLine", new Class[]{Integer.TYPE});
    private static final MethodCaller TOUCH_LINES_METHOD = new MethodCaller("touchLines", new Class[]{int[].class});
    private static final MethodCaller TOUCH_SWITCH_METHOD = new MethodCaller("touch", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
    private static final MethodCaller TOUCH_JUMP_METHOD = new MethodCaller("touch", new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE});
    private static final MethodCaller TOUCH_METHOD = new MethodCaller("touch", new Class[]{Integer.TYPE});
    private static final MethodCaller GET_CLASS_DATA_METHOD = new MethodCaller("getClassData", new Class[]{String.class});
    private static final MethodCaller TRACE_LINE_METHOD = new MethodCaller("traceLine", new Class[]{Object.class, Integer.TYPE});
    private static boolean ourStopped = false;
    public static ProjectData ourProjectData;
    private File myDataFile;
    private String myCurrentTestName;
    private boolean myTraceLines;
    private boolean mySampling;
    private boolean myDiscovery;
    private Map myTrace;
    private File myTracesDir;
    private ClassesMap myClasses = new ClassesMap();
    private Map myLinesMap;
    private static Object ourProjectDataObject;
    public static final String TRACE_DIR = "org.jetbrains.instrumentation.trace.dir";
    private String myTraceDir = System.getProperty("org.jetbrains.instrumentation.trace.dir", "");
    private final ConcurrentMap myTrace2 = new ConcurrentHashMap();
    private final ConcurrentMap myTrace3 = new ConcurrentHashMap();

    public ClassData getClassData(String name) {
        return this.myClasses.get(name);
    }

    public ClassData getOrCreateClassData(String name) {
        ClassData classData = this.myClasses.get(name);
        if (classData == null) {
            classData = new ClassData(name);
            this.myClasses.put(name, classData);
        }
        return classData;
    }

    public static ProjectData getProjectData() {
        return ourProjectData;
    }

    public void stop() {
        ourStopped = true;
    }

    public boolean isStopped() {
        return ourStopped;
    }

    public boolean isSampling() {
        return this.mySampling;
    }

    public boolean isTestDiscovery() {
        return this.myDiscovery;
    }

    public static ProjectData createProjectData() throws IOException {
        ProjectData projectData = ProjectData.createProjectData(null, null, false, true);
        projectData.myDiscovery = true;
        return projectData;
    }

    public static ProjectData createProjectData(File dataFile, ProjectData initialData, boolean traceLines, boolean isSampling) throws IOException {
        ProjectData projectData = ourProjectData = initialData == null ? new ProjectData() : initialData;
        if (dataFile != null && !dataFile.exists()) {
            File parentDir = dataFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            dataFile.createNewFile();
        }
        ProjectData.ourProjectData.mySampling = isSampling;
        ProjectData.ourProjectData.myTraceLines = traceLines;
        ProjectData.ourProjectData.myDataFile = dataFile;
        return ourProjectData;
    }

    public void merge(CoverageData data) {
        ProjectData projectData = (ProjectData)data;
        for (String key : projectData.myClasses.names()) {
            ClassData mergedData = projectData.myClasses.get(key);
            ClassData classData = this.myClasses.get(key);
            if (classData == null) {
                classData = new ClassData(mergedData.getName());
                this.myClasses.put(key, classData);
            }
            classData.merge(mergedData);
        }
    }

    public void checkLineMappings() {
        if (this.myLinesMap != null) {
            for (String className : this.myLinesMap.keySet()) {
                ClassData classData = this.getClassData(className);
                FileMapData[] fileData = (FileMapData[])this.myLinesMap.get(className);
                FileMapData mainData = null;
                for (int i = 0; i < fileData.length; ++i) {
                    String fileName = fileData[i].getClassName();
                    if (fileName.equals(className)) {
                        mainData = fileData[i];
                        continue;
                    }
                    ClassData classInfo = this.getOrCreateClassData(fileName);
                    classInfo.checkLineMappings(fileData[i].getLines(), classData);
                }
                if (mainData != null) {
                    classData.checkLineMappings(mainData.getLines(), classData);
                    continue;
                }
                ErrorReporter.reportError("Class data was not extracted: " + className, new Throwable());
            }
        }
    }

    public void addLineMaps(String className, FileMapData[] fileDatas) {
        if (this.myLinesMap == null) {
            this.myLinesMap = new HashMap();
        }
        this.myLinesMap.put(className, fileDatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded(String name) {
        if (this.myTrace == null) {
            return;
        }
        File traceFile = new File(this.getTracesDir(), name + ".tr");
        try {
            if (!traceFile.exists()) {
                traceFile.createNewFile();
            }
            FilterOutputStream os = null;
            try {
                os = new DataOutputStream(new FileOutputStream(traceFile));
                ((DataOutputStream)os).writeInt(this.myTrace.size());
                for (Object classData : this.myTrace.keySet()) {
                    int idx;
                    ((DataOutputStream)os).writeUTF(classData.toString());
                    boolean[] lines = (boolean[])this.myTrace.get(classData);
                    int numberOfTraces = 0;
                    for (idx = 0; idx < lines.length; ++idx) {
                        if (!lines[idx]) continue;
                        ++numberOfTraces;
                    }
                    ((DataOutputStream)os).writeInt(numberOfTraces);
                    for (idx = 0; idx < lines.length; ++idx) {
                        boolean incl = lines[idx];
                        if (!incl) continue;
                        ((DataOutputStream)os).writeInt(idx);
                    }
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        catch (IOException e) {
            ErrorReporter.reportError("Error writing traces to file " + traceFile.getPath(), e);
        }
        finally {
            this.myTrace = null;
        }
    }

    public void testStarted(String name) {
        this.myCurrentTestName = name;
        if (this.myTraceLines) {
            this.myTrace = new ConcurrentHashMap();
        }
    }

    private File getTracesDir() {
        if (this.myTracesDir == null) {
            String fileName = this.myDataFile.getName();
            int i = fileName.lastIndexOf(46);
            String dirName = i != -1 ? fileName.substring(0, i) : fileName;
            this.myTracesDir = new File(this.myDataFile.getParent(), dirName);
            if (!this.myTracesDir.exists()) {
                this.myTracesDir.mkdirs();
            }
        }
        return this.myTracesDir;
    }

    public static String getCurrentTestName() {
        try {
            Object projectDataObject = ProjectData.getProjectDataObject();
            return (String)projectDataObject.getClass().getDeclaredField("myCurrentTestName").get(projectDataObject);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Current test name was not retrieved:", e);
            return null;
        }
    }

    public Map getClasses() {
        return this.myClasses.asMap();
    }

    public static void touchLine(Object classData, int line) {
        if (ourProjectData != null) {
            ((ClassData)classData).touchLine(line);
            return;
        }
        ProjectData.touch(TOUCH_LINE_METHOD, classData, new Object[]{new Integer(line)});
    }

    public static void touchSwitch(Object classData, int line, int switchNumber, int key) {
        if (ourProjectData != null) {
            ((ClassData)classData).touch(line, switchNumber, key);
            return;
        }
        ProjectData.touch(TOUCH_SWITCH_METHOD, classData, new Object[]{new Integer(line), new Integer(switchNumber), new Integer(key)});
    }

    public static void touchJump(Object classData, int line, int jump, boolean hit) {
        if (ourProjectData != null) {
            ((ClassData)classData).touch(line, jump, hit);
            return;
        }
        ProjectData.touch(TOUCH_JUMP_METHOD, classData, new Object[]{new Integer(line), new Integer(jump), new Boolean(hit)});
    }

    public static void trace(Object classData, int line) {
        if (ourProjectData != null) {
            ((ClassData)classData).touch(line);
            ourProjectData.traceLine(classData, line);
            return;
        }
        ProjectData.touch(TOUCH_METHOD, classData, new Object[]{new Integer(line)});
        try {
            Object projectData = ProjectData.getProjectDataObject();
            TRACE_LINE_METHOD.invoke(projectData, new Object[]{classData, new Integer(line)});
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error tracing class " + classData.toString(), e);
        }
    }

    private static Object touch(MethodCaller methodCaller, Object classData, Object[] paramValues) {
        try {
            return methodCaller.invoke(classData, paramValues);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in project data collection: " + methodCaller.myMethodName, e);
            return null;
        }
    }

    public static int[] touchClassLines(String className, int[] lines) {
        if (ourProjectData != null) {
            return ourProjectData.getClassData(className).touchLines(lines);
        }
        try {
            Object projectDataObject = ProjectData.getProjectDataObject();
            Object classData = GET_CLASS_DATA_METHOD.invoke(projectDataObject, new Object[]{className});
            return (int[])ProjectData.touch(TOUCH_LINES_METHOD, classData, new Object[]{lines});
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in class data loading: " + className, e);
            return lines;
        }
    }

    public static Object loadClassData(String className) {
        if (ourProjectData != null) {
            return ourProjectData.getClassData(className);
        }
        try {
            Object projectDataObject = ProjectData.getProjectDataObject();
            return GET_CLASS_DATA_METHOD.invoke(projectDataObject, new Object[]{className});
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in class data loading: " + className, e);
            return null;
        }
    }

    private static Object getProjectDataObject() throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        if (ourProjectDataObject == null) {
            Class<?> projectDataClass = Class.forName(ProjectData.class.getName(), false, null);
            ourProjectDataObject = projectDataClass.getDeclaredField("ourProjectData").get(null);
        }
        return ourProjectDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceLine(Object classData, int line) {
        if (this.myTrace != null) {
            Map map = this.myTrace;
            synchronized (map) {
                boolean[] lines = (boolean[])this.myTrace.get(classData);
                if (lines == null) {
                    lines = new boolean[line + 20];
                    this.myTrace.put(classData, lines);
                }
                if (lines.length <= line) {
                    boolean[] longLines = new boolean[line + 20];
                    System.arraycopy(lines, 0, longLines, 0, lines.length);
                    lines = longLines;
                    this.myTrace.put(classData, lines);
                }
                lines[line] = true;
            }
        }
    }

    public void setTraceDir(String traceDir) {
        this.myTraceDir = traceDir;
    }

    public static boolean[] trace(String className, boolean[] methodFlags, String[] methodNames) {
        return ourProjectData.traceLines(className, methodFlags, methodNames);
    }

    private synchronized boolean[] traceLines(String className, boolean[] methodFlags, String[] methodNames) {
        boolean[] previousMethodFlags = this.myTrace2.putIfAbsent(className, methodFlags);
        if (previousMethodFlags != null) {
            String[] previousMethodNames = (String[])this.myTrace3.get(className);
        } else {
            this.myTrace3.put(className, methodNames);
        }
        return previousMethodFlags != null ? previousMethodFlags : methodFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void testDiscoveryEnded(String name) {
        new File(this.myTraceDir).mkdirs();
        File traceFile = new File(this.myTraceDir, name + ".tr");
        try {
            if (!traceFile.exists()) {
                traceFile.createNewFile();
            }
            FilterOutputStream os = null;
            try {
                boolean[] used;
                os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(traceFile), 65536));
                HashMap classToUsedMethods = new HashMap();
                for (Map.Entry e : this.myTrace2.entrySet()) {
                    used = (boolean[])e.getValue();
                    int usedMethodsCount = 0;
                    for (int i = 0; i < used.length; ++i) {
                        boolean anUsed = used[i];
                        if (!anUsed) continue;
                        ++usedMethodsCount;
                    }
                    if (usedMethodsCount <= 0) continue;
                    classToUsedMethods.put(e.getKey(), new Integer(usedMethodsCount));
                }
                CoverageIOUtil.writeINT((DataOutput)((Object)os), classToUsedMethods.size());
                for (Map.Entry e : this.myTrace2.entrySet()) {
                    used = (boolean[])e.getValue();
                    String className = (String)e.getKey();
                    Integer integer = (Integer)classToUsedMethods.get(className);
                    if (integer == null) continue;
                    int usedMethodsCount = integer;
                    CoverageIOUtil.writeUTF((DataOutput)((Object)os), className);
                    CoverageIOUtil.writeINT((DataOutput)((Object)os), usedMethodsCount);
                    String[] methodNames = (String[])this.myTrace3.get(className);
                    int len = used.length;
                    for (int i = 0; i < len; ++i) {
                        if (!used[i] || usedMethodsCount-- <= 0) continue;
                        CoverageIOUtil.writeUTF((DataOutput)((Object)os), methodNames[i]);
                    }
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void testDiscoveryStarted(String name) {
        for (Map.Entry e : this.myTrace2.entrySet()) {
            boolean[] used = (boolean[])e.getValue();
            int len = used.length;
            for (int i = 0; i < len; ++i) {
                if (!used[i]) continue;
                used[i] = false;
            }
        }
    }

    private static class IdentityClassData {
        private String myClassName;
        private ClassData myClassData;

        private IdentityClassData(String className, ClassData classData) {
            this.myClassName = className;
            this.myClassData = classData;
        }

        public ClassData getClassData(String name) {
            if (name == this.myClassName) {
                return this.myClassData;
            }
            return null;
        }
    }

    private static class ClassesMap {
        private static final int POOL_SIZE = 1000;
        private IdentityClassData[] myIdentityArray = new IdentityClassData[1000];
        private final Map myClasses = new HashMap(1000);

        private ClassesMap() {
        }

        public ClassData get(String name) {
            ClassData data;
            int idx = Math.abs(name.hashCode() % 1000);
            IdentityClassData lastClassData = this.myIdentityArray[idx];
            if (lastClassData != null && (data = lastClassData.getClassData(name)) != null) {
                return data;
            }
            data = (ClassData)this.myClasses.get(name);
            this.myIdentityArray[idx] = new IdentityClassData(name, data);
            return data;
        }

        public void put(String name, ClassData data) {
            this.myClasses.put(name, data);
        }

        public HashMap asMap() {
            return new HashMap(this.myClasses);
        }

        public Collection names() {
            return this.myClasses.keySet();
        }
    }

    private static class MethodCaller {
        private Method myMethod;
        private String myMethodName;
        private Class[] myParamTypes;

        private MethodCaller(String methodName, Class[] paramTypes) {
            this.myMethodName = methodName;
            this.myParamTypes = paramTypes;
        }

        public Object invoke(Object thisObj, Object[] paramValues) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            if (this.myMethod == null) {
                this.myMethod = MethodCaller.findMethod(thisObj.getClass(), this.myMethodName, this.myParamTypes);
            }
            return this.myMethod.invoke(thisObj, paramValues);
        }

        private static Method findMethod(Class clazz, String name, Class[] paramTypes) throws NoSuchMethodException {
            Method m = clazz.getDeclaredMethod(name, paramTypes);
            m.setAccessible(true);
            return m;
        }
    }
}

