/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.builtins.BuiltInsProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuiltInsAnnotationAndConstantLoader
implements AnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>, AnnotationWithTarget> {
    private final AnnotationDeserializer deserializer;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(classProto, "classProto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        List<ProtoBuf.Annotation> annotations2 = CollectionsKt.orEmpty(classProto.getExtension(BuiltInsProtoBuf.classAnnotation));
        Iterable iterable = annotations2;
        void var5_5 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void proto;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item;
            void var10_10 = destination;
            AnnotationDeserializer annotationDeserializer = this.deserializer;
            void v1 = proto;
            Intrinsics.checkExpressionValueIsNotNull(v1, "proto");
            AnnotationDescriptor annotationDescriptor = annotationDeserializer.deserializeAnnotation((ProtoBuf.Annotation)v1, nameResolver);
            var10_10.add(annotationDescriptor);
        }
        return (List)destination;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationWithTarget> loadCallableAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite proto, @NotNull AnnotatedCallableKind kind) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Object object = proto;
        List<ProtoBuf.Annotation> annotations2 = CollectionsKt.orEmpty(object instanceof ProtoBuf.Constructor ? ((ProtoBuf.Constructor)proto).getExtension(BuiltInsProtoBuf.constructorAnnotation) : (object instanceof ProtoBuf.Function ? ((ProtoBuf.Function)proto).getExtension(BuiltInsProtoBuf.functionAnnotation) : (object instanceof ProtoBuf.Property ? ((ProtoBuf.Property)proto).getExtension(BuiltInsProtoBuf.propertyAnnotation) : (List<ProtoBuf.Annotation>)((Object)PreconditionsKt.error("Unknown message: " + proto)))));
        object = annotations2;
        void var6_6 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void proto2;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item;
            void var11_11 = destination;
            AnnotationDeserializer annotationDeserializer = this.deserializer;
            void v1 = proto2;
            Intrinsics.checkExpressionValueIsNotNull(v1, "proto");
            AnnotationWithTarget annotationWithTarget = new AnnotationWithTarget(annotationDeserializer.deserializeAnnotation((ProtoBuf.Annotation)v1, container.getNameResolver()), null);
            var11_11.add(annotationWithTarget);
        }
        return (List)destination;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite message, @NotNull AnnotatedCallableKind kind, int parameterIndex, @NotNull ProtoBuf.ValueParameter proto) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        List<ProtoBuf.Annotation> annotations2 = CollectionsKt.orEmpty(proto.getExtension(BuiltInsProtoBuf.parameterAnnotation));
        Iterable iterable = annotations2;
        void var8_8 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void proto2;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item;
            void var13_13 = destination;
            AnnotationDeserializer annotationDeserializer = this.deserializer;
            void v1 = proto2;
            Intrinsics.checkExpressionValueIsNotNull(v1, "proto");
            AnnotationDescriptor annotationDescriptor = annotationDeserializer.deserializeAnnotation((ProtoBuf.Annotation)v1, container.getNameResolver());
            var13_13.add(annotationDescriptor);
        }
        return (List)destination;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadExtensionReceiverParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite message, @NotNull AnnotatedCallableKind kind) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadTypeAnnotations(@NotNull ProtoBuf.Type proto, @NotNull NameResolver nameResolver) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Iterable $receiver2 = CollectionsKt.orEmpty(proto.getExtension(BuiltInsProtoBuf.typeAnnotation));
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item;
            void var9_9 = destination;
            AnnotationDeserializer annotationDeserializer = this.deserializer;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull(v1, "it");
            AnnotationDescriptor annotationDescriptor = annotationDeserializer.deserializeAnnotation((ProtoBuf.Annotation)v1, nameResolver);
            var9_9.add(annotationDescriptor);
        }
        return (List)destination;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadTypeParameterAnnotations(@NotNull ProtoBuf.TypeParameter proto, @NotNull NameResolver nameResolver) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Iterable $receiver2 = CollectionsKt.orEmpty(proto.getExtension(BuiltInsProtoBuf.typeParameterAnnotation));
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item;
            void var9_9 = destination;
            AnnotationDeserializer annotationDeserializer = this.deserializer;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull(v1, "it");
            AnnotationDescriptor annotationDescriptor = annotationDeserializer.deserializeAnnotation((ProtoBuf.Annotation)v1, nameResolver);
            var9_9.add(annotationDescriptor);
        }
        return (List)destination;
    }

    @Override
    @Nullable
    public ConstantValue<?> loadPropertyConstant(@NotNull ProtoContainer container, @NotNull ProtoBuf.Property proto, @NotNull KotlinType expectedType) {
        ProtoBuf.Annotation.Argument.Value value2;
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        if (!proto.hasExtension(BuiltInsProtoBuf.compileTimeValue)) {
            return null;
        }
        ProtoBuf.Annotation.Argument.Value value3 = value2 = proto.getExtension(BuiltInsProtoBuf.compileTimeValue);
        Intrinsics.checkExpressionValueIsNotNull(value3, "value");
        return this.deserializer.resolveValue(expectedType, value3, container.getNameResolver());
    }

    public BuiltInsAnnotationAndConstantLoader(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        this.deserializer = new AnnotationDeserializer(module);
    }
}

