/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.rmi.kotlinr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.ConsoleKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.ProcessLauncher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.rmi.BoolPropMapper;
import org.jetbrains.kotlin.rmi.CompileService;
import org.jetbrains.kotlin.rmi.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.rmi.CompilerId;
import org.jetbrains.kotlin.rmi.DaemonJVMOptions;
import org.jetbrains.kotlin.rmi.DaemonOptions;
import org.jetbrains.kotlin.rmi.DaemonParamsKt;
import org.jetbrains.kotlin.rmi.DummyProfiler;
import org.jetbrains.kotlin.rmi.LoopbackNetworkInterface;
import org.jetbrains.kotlin.rmi.NetworkUtilsKt;
import org.jetbrains.kotlin.rmi.OptionsGroup;
import org.jetbrains.kotlin.rmi.Profiler;
import org.jetbrains.kotlin.rmi.PropMapper;
import org.jetbrains.kotlin.rmi.RemoteOperationsTracer;
import org.jetbrains.kotlin.rmi.RemoteOutputStream;
import org.jetbrains.kotlin.rmi.kotlinr.CompilationServices;
import org.jetbrains.kotlin.rmi.kotlinr.CompilerCallbackServicesFacadeServer;
import org.jetbrains.kotlin.rmi.kotlinr.DaemonReportCategory;
import org.jetbrains.kotlin.rmi.kotlinr.DaemonReportMessage;
import org.jetbrains.kotlin.rmi.kotlinr.DaemonReportingTargets;
import org.jetbrains.kotlin.rmi.kotlinr.KotlinCompilerClient;
import org.jetbrains.kotlin.rmi.kotlinr.KotlinCompilerClient$ClientOptions$mappers$1;
import org.jetbrains.kotlin.rmi.kotlinr.KotlinCompilerClientKt;
import org.jetbrains.kotlin.rmi.kotlinr.RemoteOutputStreamServer;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"!\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q!\u0001\u0003\u0002\u000b\u0005Aq!B\u0001\u0005\u0004\u0015\t\u0001\u0002B\u0003\u0002\t\u0007)\u0011\u0001#\u0003\u0006\u0003\u0011\rQ!\u0001E\u0006\u000b\u0005!!!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001#\u0005\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001\u0003\t\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0005)\u0011\u0001B\u0002\u0006\u00031\tQ!\u0001\u0003\u0003\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0011\u0019\u0017\u0001\u0004\u0001\u001a\u0003a\u0005Q$!\u0013&C\u000f!\u0011!U\u0002\u0002\u0011\u0005)K\u0005c\u0005\u000e\u0003a!\u0011d\u0001\u0005\u000b\u001b\u0005A*\"G\u0002\t\u00175\t\u0001tC\r\b\u00111iQ!C\u0002\u0005\u0002%\t\u0001D\u0001M\r3\rAQ\"D\u0001\u0019\u001ce!A!\u0001\u0005\u000f\u001b\u0005AB!G\u0003\u0005\u0003!uQB\u0001G\u00011=\t6!\u0001E\u0010K\u0011!\u0011\u0001\u0003\t\u000e\u0003a\u0005R\u0005\u0003\u0003\u0002\u0011Ai\u0011\u0001'\t\u001a\u0007!\tR\"\u0001M\u0011K}!9\u0001c\t\u000e\u00051\u0005\u0001TC\r\u0004\u0011Ii\u0011\u0001'\n\u001a\u0007!\u0019R\"\u0001M\u00143\rAA#D\u0001\u0019*e\u0019\u0001\"F\u0007\u00021WIB\u0001B\u0001\t-5\t\u0001\u0004C\r\u0005\t\u0005Ai#D\u0001\u0019\u0011\u0015:\u0001bF\u0007\u0006\u0013\tI\u0011\u0001\u0007\u0002\r\u0002a=R5\r\u0005\u0019\u001b\u0005AB!G\u0002\t25\t\u0001TC\r\u0004\u0011-i\u0011\u0001g\u0006\u001a\u000f!aQ\"B\u0005\u0004\t\u0003I\u0011\u0001\u0007\u0002\u0019\u001ae\u0019\u0001\"G\u0007\u00021gI2\u0001\u0003\u000e\u000e\u0003am\u0011d\u0001E\u001b\u001b\u0005AZ\"\u0007\u0003\u0005\u0003!qQ\"\u0001\r\u00053\u0011!\u0011\u0001C\u000e\u000e\u0003a]\u0012$\u0002\u0003\u0002\u0011;i!\u0001$\u0001\u0019\u001fE\u001b\u0011\u0001\u0003\u000f&\"\u0011\u001d\u0001\u0012H\u0007\u00021uI\u0012\u0002\u0003\u0007\u000e\u000b%\u0019A\u0011A\u0005\u00021\tAJ\"E\u0001\u0019\u0005E\u001b\u0011\u0001c\u000f&\u000f!qR\"\u0001\r\u001e3\rA!#D\u0001\u0019&\u0015Z\u0001BH\u0007\u00021uI2\u0001\u0003\n\u000e\u0003a\u0015\u0012d\u0001\u0005\u0015\u001b\u0005AJ#\n\u000b\u0005\u0003!uR\"\u0001\r\u001e3\rA!#D\u0001\u0019&e\u0019\u0001bE\u0007\u00021OI2\u0001\u0003\u000b\u000e\u0003a%\u0012d\u0001\u0005\u0016\u001b\u0005AZ#J\u0007\u0005\u0003!yRB\u0001G\u00011+I2\u0001\u0003\b\u000e\u0003a!\u0011d\u0001\u0005\u0016\u001b\u0005AZ#J\t\u0005\u0003!}RB\u0001G\u00011+I2\u0001\u0003\u0011\u000e\u0003a\u0005\u0013d\u0001\u0005\u0013\u001b\u0005A*#G\u0002\t+5\t\u00014FS\f\t\u0005A\u0011%D\u0001\u0019\tU\t\u0001DAM\u0005\u0011\u0007j\u0011\u0001\u0007\u0002Q\u0007\u0003)k\u0003\u0003\u0012\u000e\u0003aiR#\u0001M\u00163\u0013A)%D\u0001\u0019GA\u001b\t!'\u0003\tH5\t\u0001D\u0001)\u0004\u0003e-A!\u0001\u0005%\u001b\u0005A\"\u0001UB\u0002S+!1\tS\u0001\t\u00045\t\u0001DA)\u0004\t\u0015\u0001QB\u0001C\u0003\u0011\rI+\u0002B\"I\u0003!\u001dQ\"\u0001\r\u0005#\u000e!Q\u0001A\u0007\u0003\t\u0013AQ!+\u0006\u0005\u0007\"\u000b\u00012B\u0007\u00021\u0019\t6\u0001B\u0003\u0001\u001b\t!i\u0001C\u0004*\u0015\u0011\u0019\u0005\u0002c\u0004\u000e\u0003aA\u0011k\u0001\u0003\u0006\u00015\u0011A\u0011\u0003\u0005\n"}, strings={"Lorg/jetbrains/kotlin/rmi/kotlinr/KotlinCompilerClient;", "", "()V", "COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "", "getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "()Ljava/lang/String;", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "getDAEMON_CONNECT_CYCLE_ATTEMPTS", "()I", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "()J", "verboseReporting", "", "getVerboseReporting", "()Z", "compile", "compilerService", "Lorg/jetbrains/kotlin/rmi/CompileService;", "targetPlatform", "Lorg/jetbrains/kotlin/rmi/CompileService$TargetPlatform;", "args", "", "out", "Ljava/io/OutputStream;", "port", "operationsTracer", "Lorg/jetbrains/kotlin/rmi/RemoteOperationsTracer;", "(Lorg/jetbrains/kotlin/rmi/CompileService;Lorg/jetbrains/kotlin/rmi/CompileService$TargetPlatform;[Ljava/lang/String;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/rmi/RemoteOperationsTracer;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/rmi/kotlinr/KotlinCompilerClient$ClientOptions;", "opts", "connectToCompileService", "compilerId", "Lorg/jetbrains/kotlin/rmi/CompilerId;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/rmi/DaemonJVMOptions;", "daemonOptions", "Lorg/jetbrains/kotlin/rmi/DaemonOptions;", "reportingTargets", "Lorg/jetbrains/kotlin/rmi/kotlinr/DaemonReportingTargets;", "autostart", "checkId", "detectCompilerClasspath", "", "incrementalCompile", "compileService", "callbackServices", "Lorg/jetbrains/kotlin/rmi/kotlinr/CompilationServices;", "compilerOut", "daemonOut", "profiler", "Lorg/jetbrains/kotlin/rmi/Profiler;", "(Lorg/jetbrains/kotlin/rmi/CompileService;Lorg/jetbrains/kotlin/rmi/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/rmi/kotlinr/CompilationServices;Ljava/io/OutputStream;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/rmi/Profiler;Lorg/jetbrains/kotlin/rmi/RemoteOperationsTracer;)I", "main", "", "([Ljava/lang/String;)V", "shutdownCompileService", "startDaemon", "tryConnectToDaemon", "tryFindDaemon", "registryDir", "Ljava/io/File;", "extractPortFromRunFilename", "digest", "report", "category", "Lorg/jetbrains/kotlin/rmi/kotlinr/DaemonReportCategory;", "message", "source", "ClientOptions", "FileBasedLock"}, moduleName="kotlin-rmi")
public final class KotlinCompilerClient {
    public static final long DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
    public static final int DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
    public static final boolean verboseReporting;
    @NotNull
    public static final String COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = "kotlin.daemon.client.options";
    public static final KotlinCompilerClient INSTANCE;
    public static final KotlinCompilerClient INSTANCE$;

    public final long getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() {
        return DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
    }

    public final int getDAEMON_CONNECT_CYCLE_ATTEMPTS() {
        return DAEMON_CONNECT_CYCLE_ATTEMPTS;
    }

    public final boolean getVerboseReporting() {
        return verboseReporting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @Nullable
    public static final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean checkId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        attempts = 0;
        fileLock = null;
        shutdonwnPerformed = false;
        try {
lbl10:
            // 3 sources

            while (attempts++ < KotlinCompilerClient.DAEMON_CONNECT_CYCLE_ATTEMPTS) {
                service = KotlinCompilerClient.INSTANCE.tryFindDaemon(new File(daemonOptions.getRunFilesPath()), compilerId, reportingTargets);
                if (service == null) ** GOTO lbl65
                if (checkId && !service.checkCompilerId(compilerId)) ** GOTO lbl-1000
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.DEBUG, "connected to the daemon", null, 4);
                var10_12 /* !! */  = service;
                v0 = fileLock;
                ** GOTO lbl32
            }
            ** GOTO lbl83
        }
        catch (Exception e) {
            try {
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.EXCEPTION, e.toString(), null, 4);
                v1 = fileLock;
            }
            catch (Throwable var9_11) {
                v2 = fileLock;
                if (v2 != null) {
                    v2.release();
                    v3 = Unit.INSTANCE;
                    throw var9_11;
                }
                v3 = null;
                throw var9_11;
            }
lbl32:
            // 1 sources

            if (v0 == null) return var10_12 /* !! */ ;
            v0.release();
            v4 = Unit.INSTANCE;
            return var10_12 /* !! */ ;
lbl-1000:
            // 1 sources

            {
                var10_12 /* !! */  = compilerId.getMappers();
                var23_22 = new StringBuilder().append("compiler identity don't match: ");
                var22_21 = DaemonReportCategory.DEBUG;
                var21_20 = reportingTargets;
                var20_19 = KotlinCompilerClient.INSTANCE;
                var11_13 = $receiver;
                var12_14 = new ArrayList<E>();
                for (T element : $receiver) {
                    it = (PropMapper)element;
                    list = it.toArgs("");
                    CollectionsKt.addAll((Collection)destination, (Iterable)list);
                }
                var24_23 = (List)destination;
                KotlinCompilerClient.report$default(var20_19, var21_20, var22_21, var23_22.append(CollectionsKt.joinToString$default((Iterable)var24_23, (CharSequence)" ", null, null, (int)0, null, null, (int)62)).toString(), null, 4);
                if (autostart) ** GOTO lbl-1000
                var10_12 /* !! */  = null;
                v5 = fileLock;
            }
            if (v5 == null) return var10_12 /* !! */ ;
            v5.release();
            v6 = Unit.INSTANCE;
            return var10_12 /* !! */ ;
lbl-1000:
            // 1 sources

            {
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.DEBUG, "shutdown the daemon", null, 4);
                service.shutdown();
                Thread.sleep(1000L);
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.DEBUG, "daemon shut down correctly", null, 4);
                shutdonwnPerformed = true;
                ** GOTO lbl73
lbl65:
                // 1 sources

                if (autostart) ** GOTO lbl-1000
                var10_12 /* !! */  = null;
                v7 = fileLock;
            }
            if (v7 == null) return var10_12 /* !! */ ;
            v7.release();
            v8 = Unit.INSTANCE;
            return var10_12 /* !! */ ;
lbl-1000:
            // 1 sources

            {
                block12: {
                    KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.DEBUG, shutdonwnPerformed != false ? "starting a new daemon" : "no suitable daemon found, starting a new one", null, 4);
lbl73:
                    // 2 sources

                    if (fileLock != null && fileLock.isLocked()) break block12;
                    new File(daemonOptions.getRunFilesPath()).mkdirs();
                    fileLock = new FileBasedLock(compilerId, daemonOptions);
                    --attempts;
                    ** GOTO lbl10
                }
                KotlinCompilerClient.INSTANCE.startDaemon(compilerId, daemonJVMOptions, daemonOptions, reportingTargets);
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.DEBUG, "daemon started, trying to find it", null, 4);
                ** GOTO lbl10
            }
lbl83:
            // 1 sources

            v9 = fileLock;
            if (v9 != null) {
                v9.release();
                v10 = Unit.INSTANCE;
                return null;
            }
            v10 = null;
            return null;
            if (v1 != null) {
                v1.release();
                v11 = Unit.INSTANCE;
                return null;
            }
            v11 = null;
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return KotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2);
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        CompileService compileService = KotlinCompilerClient.connectToCompileService(compilerId, new DaemonJVMOptions(null, null, null, null, 15, null), daemonOptions, new DaemonReportingTargets(System.out, null, 2, null), false, false);
        if (compileService != null) {
            compileService.shutdown();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        this.shutdownCompileService(compilerId, new DaemonOptions(null, 0L, 0, 0L, null, false, false, 127, null));
    }

    public final int compile(@NotNull CompileService compilerService, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull OutputStream out, int port, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(out, port);
        return compilerService.remoteCompile(targetPlatform, args, (CompilerCallbackServicesFacade)new CompilerCallbackServicesFacadeServer(null, null, port, 3, null), (RemoteOutputStream)outStrm, CompileService.OutputFormat.PLAIN, (RemoteOutputStream)outStrm, operationsTracer);
    }

    public static /* bridge */ /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, CompileService.TargetPlatform targetPlatform, String[] stringArray, OutputStream outputStream, int n, RemoteOperationsTracer remoteOperationsTracer, int n2) {
        if ((n2 & 0x10) != 0) {
            n = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n2 & 0x20) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.compile(compileService, targetPlatform, stringArray, outputStream, n, remoteOperationsTracer);
    }

    public final int incrementalCompile(@NotNull CompileService compileService, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilationServices callbackServices, @NotNull OutputStream compilerOut, @NotNull OutputStream daemonOut, int port, @NotNull Profiler profiler, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compileService, (String)"compileService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)callbackServices, (String)"callbackServices");
        Intrinsics.checkParameterIsNotNull((Object)compilerOut, (String)"compilerOut");
        Intrinsics.checkParameterIsNotNull((Object)daemonOut, (String)"daemonOut");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        return ((Number)profiler.withMeasure((Object)this, (Function0)new Function0<Integer>(compileService, targetPlatform, args, callbackServices, port, compilerOut, daemonOut, operationsTracer){
            final /* synthetic */ CompileService $compileService;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilationServices $callbackServices;
            final /* synthetic */ int $port;
            final /* synthetic */ OutputStream $compilerOut;
            final /* synthetic */ OutputStream $daemonOut;
            final /* synthetic */ RemoteOperationsTracer $operationsTracer;

            public final int invoke() {
                return this.$compileService.remoteIncrementalCompile(this.$targetPlatform, this.$args, (CompilerCallbackServicesFacade)new CompilerCallbackServicesFacadeServer(this.$callbackServices.getIncrementalCompilationComponents(), this.$callbackServices.getCompilationCanceledStatus(), this.$port), (RemoteOutputStream)new RemoteOutputStreamServer(this.$compilerOut, this.$port), CompileService.OutputFormat.XML, (RemoteOutputStream)new RemoteOutputStreamServer(this.$daemonOut, this.$port), this.$operationsTracer);
            }
            {
                this.$compileService = compileService;
                this.$targetPlatform = targetPlatform;
                this.$args = stringArray;
                this.$callbackServices = compilationServices;
                this.$port = n;
                this.$compilerOut = outputStream;
                this.$daemonOut = outputStream2;
                this.$operationsTracer = remoteOperationsTracer;
                super(0);
            }
        })).intValue();
    }

    public static /* bridge */ /* synthetic */ int incrementalCompile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, CompileService.TargetPlatform targetPlatform, String[] stringArray, CompilationServices compilationServices, OutputStream outputStream, OutputStream outputStream2, int n, Profiler profiler, RemoteOperationsTracer remoteOperationsTracer, int n2) {
        if ((n2 & 0x40) != 0) {
            n = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n2 & 0x80) != 0) {
            profiler = (Profiler)new DummyProfiler();
        }
        if ((n2 & 0x100) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.incrementalCompile(compileService, targetPlatform, stringArray, compilationServices, outputStream, outputStream2, n, profiler, remoteOperationsTracer);
    }

    @NotNull
    public final String getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY() {
        return COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    private final ClientOptions configureClientOptions(ClientOptions opts) {
        Unit unit;
        String string = System.getProperty(COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY);
        if (string != null) {
            String $receiver = string;
            String it = $receiver;
            Iterable unrecognized = DaemonParamsKt.filterExtractProps$default((Iterable)StringsKt.split$default((CharSequence)DaemonParamsKt.trimQuotes((String)it), (String[])new String[]{","}, (boolean)false, (int)0, (int)6), opts.getMappers(), (String)"", null, (int)4);
            if (CollectionsKt.any((Iterable)unrecognized)) {
                throw (Throwable)new IllegalArgumentException("Unrecognized client options passed via property " + DaemonParamsKt.getCOMPILE_DAEMON_OPTIONS_PROPERTY() + ": " + CollectionsKt.joinToString$default((Iterable)unrecognized, (CharSequence)" ", null, null, (int)0, null, null, (int)62) + "\nSupported options: " + CollectionsKt.joinToString$default((Iterable)opts.getMappers(), (CharSequence)", ", null, null, (int)0, null, (Function1)configureClientOptions.1.1.INSTANCE, (int)30));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return opts;
    }

    private final ClientOptions configureClientOptions() {
        return this.configureClientOptions(new ClientOptions(false, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void main(String ... args) {
        CompileService compileService;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
        String[] stringArray = new String[]{};
        boolean bl = true;
        boolean bl2 = true;
        DaemonJVMOptions daemonLaunchingOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])stringArray, (boolean)bl2, (boolean)bl);
        ClientOptions clientOptions = INSTANCE.configureClientOptions();
        OptionsGroup[] optionsGroupArray = new OptionsGroup[]{(OptionsGroup)compilerId, (OptionsGroup)daemonOptions, (OptionsGroup)daemonLaunchingOptions, clientOptions};
        String string = DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX();
        Iterable filteredArgs = DaemonParamsKt.filterExtractProps((Iterable)ArraysKt.asIterable((Object[])args), (OptionsGroup[])optionsGroupArray, (String)string);
        if (!clientOptions.getStop()) {
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                Unit unit;
                System.err.println("compiler wasn't explicitly specified, attempt to find appropriate jar");
                List<String> list = INSTANCE.detectCompilerClasspath();
                if (list != null) {
                    List<String> list2 = list;
                    List<String> it = list2;
                    compilerId.setCompilerClasspath(it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                throw (Throwable)new IllegalArgumentException("Cannot find compiler jar");
            }
            StringBuilder stringBuilder = new StringBuilder().append("desired compiler classpath: ");
            Iterable iterable = compilerId.getCompilerClasspath();
            CharSequence charSequence = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"File.pathSeparator");
            ConsoleKt.println((Object)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence, null, null, (int)0, null, null, (int)62)).toString());
        }
        if ((compileService = KotlinCompilerClient.connectToCompileService(compilerId, daemonLaunchingOptions, daemonOptions, new DaemonReportingTargets(System.out, null, 2, null), !clientOptions.getStop(), !clientOptions.getStop())) == null) {
            if (!clientOptions.getStop()) throw (Throwable)new Exception("Unable to connect to daemon");
            System.err.println("No daemon found to shut down");
            return;
        }
        if (clientOptions.getStop()) {
            ConsoleKt.println((Object)"Shutdown the daemon");
            compileService.shutdown();
            ConsoleKt.println((Object)"Daemon shut down successfully");
            return;
        }
        if (CollectionsKt.none((Iterable)filteredArgs)) {
            ConsoleKt.println((Object)("Warning: empty arguments list, only daemon check is performed: checkCompilerId() returns " + compileService.checkCompilerId(compilerId)));
            return;
        }
        ConsoleKt.println((Object)("Executing daemon compilation with args: " + CollectionsKt.joinToString$default((Iterable)filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62)));
        OutputStream outputStream = System.out;
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"System.out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(outputStream, 0, 2, null);
        CompilerCallbackServicesFacadeServer servicesFacade = new CompilerCallbackServicesFacadeServer(null, null, 0, 7, null);
        try {
            void $receiver;
            long memBefore = compileService.getUsedMemory() / (long)1024;
            long startTime = System.nanoTime();
            Collection collection = CollectionsKt.toArrayList((Iterable)filteredArgs);
            CompileService.TargetPlatform targetPlatform = CompileService.TargetPlatform.JVM;
            CompileService compileService2 = compileService;
            void v6 = $receiver;
            if (v6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection = (Collection)v6;
            String[] stringArray2 = thisCollection.toArray(new String[thisCollection.size()]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = stringArray2;
            int res = compileService2.remoteCompile(targetPlatform, (String[])objectArray, (CompilerCallbackServicesFacade)servicesFacade, (RemoteOutputStream)outStrm, CompileService.OutputFormat.PLAIN, (RemoteOutputStream)outStrm, (RemoteOperationsTracer)null);
            long endTime = System.nanoTime();
            ConsoleKt.println((Object)("Compilation result code: " + res));
            long memAfter = compileService.getUsedMemory() / (long)1024;
            ConsoleKt.println((Object)("Compilation time: " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + " ms"));
            ConsoleKt.println((Object)("Used memory " + memAfter + " (" + StringsKt.format((String)"%+d", (Object[])new Object[]{memAfter - memBefore}) + " kb)"));
            return;
        }
        finally {
            UnicastRemoteObject.unexportObject(servicesFacade, true);
            UnicastRemoteObject.unexportObject(outStrm, true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<String> detectCompilerClasspath() {
        File file;
        File it;
        Collection collection;
        Iterable $receiver;
        String string = System.getProperty("java.class.path");
        Object object = string;
        if (string == null) return null;
        CharSequence charSequence = (CharSequence)object;
        String[] stringArray = new String[1];
        String string2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
        stringArray[0] = string2;
        List list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6);
        object = list;
        if (list == null) return null;
        Object $receiver2 = (Iterable)object;
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            String string3 = (String)item;
            collection = destination;
            file = new File((String)((Object)it)).getParentFile();
            collection.add(file);
        }
        List list2 = CollectionsKt.distinct((Iterable)((List)destination));
        object = list2;
        if (list2 == null) return null;
        $receiver2 = (Iterable)object;
        $receiver = $receiver2;
        destination = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            File file2;
            it = (File)item;
            collection = destination;
            File file3 = it;
            if (file3 != null && (file3 = FilesKt.walk$default((File)file3, null, (int)1)) != null) {
                Object v8;
                block5: {
                    void $receiver3;
                    Sequence $i$a$1 = (Sequence)file3;
                    for (Object element : $receiver3) {
                        File it2 = (File)element;
                        if (!StringsKt.equals((String)it2.getName(), (String)DaemonParamsKt.getCOMPILER_JAR_NAME(), (boolean)true)) continue;
                        v8 = element;
                        break block5;
                    }
                    v8 = null;
                }
                file2 = v8;
            } else {
                file2 = null;
            }
            file = file2;
            collection.add(file);
        }
        List list3 = CollectionsKt.filterNotNull((Iterable)((List)destination));
        object = list3;
        if (list3 == null) return null;
        File file4 = (File)CollectionsKt.firstOrNull((List)object);
        object = file4;
        if (file4 == null) return null;
        $receiver2 = object;
        File it3 = (File)$receiver2;
        List list4 = CollectionsKt.listOf((Object)it3.getAbsolutePath());
        return list4;
    }

    /*
     * WARNING - void declaration
     */
    public final void report(DaemonReportingTargets $receiver, @NotNull DaemonReportCategory category, @NotNull String message, @NotNull String source) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (Intrinsics.areEqual((Object)((Object)category), (Object)((Object)DaemonReportCategory.DEBUG)) && !verboseReporting) {
            return;
        }
        PrintStream printStream = $receiver.getOut();
        if (printStream != null) {
            void $receiver2;
            Enum enum_ = category;
            StringBuilder stringBuilder = new StringBuilder().append("[").append(source).append("] ");
            PrintStream printStream2 = printStream;
            String string = $receiver2.name();
            printStream2.println(stringBuilder.append(string).append(": ").append(message).toString());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        Collection<DaemonReportMessage> collection = $receiver.getMessages();
        Boolean bl = collection != null ? Boolean.valueOf(collection.add(new DaemonReportMessage(category, "[" + source + "] " + message))) : null;
    }

    public static /* bridge */ /* synthetic */ void report$default(KotlinCompilerClient kotlinCompilerClient, DaemonReportingTargets daemonReportingTargets, DaemonReportCategory daemonReportCategory, String string, String string2, int n) {
        if ((n & 4) != 0) {
            string2 = "daemon client";
        }
        kotlinCompilerClient.report(daemonReportingTargets, daemonReportCategory, string, string2);
    }

    private final int extractPortFromRunFilename(String $receiver, String digest) {
        Object object = Regex.find$default((Regex)StringsKt.toRegex((String)DaemonParamsKt.makeRunFilenameString((String)"[0-9TZ:\\.\\+-]+", (String)digest, (String)"(\\d+)", (String)"\\")), (CharSequence)$receiver, (int)0, (int)2);
        return object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null ? StringsKt.toInt((String)object) : 0;
    }

    /*
     * WARNING - void declaration
     */
    private final CompileService tryFindDaemon(File registryDir, CompilerId compilerId, DaemonReportingTargets reportingTargets) {
        CompileService compileService;
        void destination;
        void $receiver;
        void $receiver2;
        Iterable iterable = compilerId.getCompilerClasspath();
        void var6_5 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            String string = (String)item;
            void var14_10 = destination;
            String string2 = new File((String)it).getAbsolutePath();
            var14_10.add(string2);
        }
        String classPathDigest = DaemonParamsKt.toHexString((byte[])DaemonParamsKt.distinctStringsDigest((Iterable)((List)destination)));
        List daemons2 = SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)((Sequence)FilesKt.walk$default((File)registryDir, null, (int)1)), (Function1)((Function1)new Function1<File, Pair<? extends File, ? extends Integer>>(classPathDigest){
            final /* synthetic */ String $classPathDigest;

            @NotNull
            public final Pair<File, Integer> invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new Pair((Object)it, (Object)KotlinCompilerClient.access$extractPortFromRunFilename(KotlinCompilerClient.INSTANCE, it.getName(), this.$classPathDigest));
            }
            {
                this.$classPathDigest = string;
                super(1);
            }
        })), (Function1)tryFindDaemon.daemons.2.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends File, ? extends Integer>, CompileService>(reportingTargets){
            final /* synthetic */ DaemonReportingTargets $reportingTargets;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CompileService invoke(@NotNull Pair<? extends File, ? extends Integer> it) {
                void var2_2;
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                PreconditionsKt.assert((((Number)it.getSecond()).intValue() > 0 && ((Number)it.getSecond()).intValue() < 65535 ? 1 : 0) != 0);
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, this.$reportingTargets, DaemonReportCategory.DEBUG, "found suitable daemon on port " + ((Number)it.getSecond()).intValue() + ", trying to connect", null, 4);
                CompileService daemon = KotlinCompilerClient.access$tryConnectToDaemon(KotlinCompilerClient.INSTANCE, ((Number)it.getSecond()).intValue(), this.$reportingTargets);
                if (daemon == null && !((File)it.getFirst()).delete()) {
                    KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, this.$reportingTargets, DaemonReportCategory.INFO, "WARNING: unable to delete seemingly orphaned file '" + ((File)it.getFirst()).getAbsolutePath() + "', cleanup recommended", null, 4);
                }
                return var2_2;
            }
            {
                this.$reportingTargets = daemonReportingTargets;
                super(1);
            }
        }))));
        switch (daemons2.size()) {
            case 0: {
                compileService = null;
                break;
            }
            case 1: {
                compileService = (CompileService)CollectionsKt.first((List)daemons2);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Multiple daemons serving the same compiler, reset with the cleanup required");
            }
        }
        return compileService;
    }

    private final CompileService tryConnectToDaemon(int port, DaemonReportingTargets reportingTargets) {
        try {
            Remote daemon;
            Registry registry = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), port);
            Remote remote = daemon = registry != null ? registry.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
            if (daemon != null) {
                Remote remote2 = daemon;
                if (!(remote2 instanceof CompileService)) {
                    remote2 = null;
                }
                CompileService compileService = (CompileService)remote2;
                if (compileService == null) {
                    throw (Throwable)new ClassCastException("Unable to cast compiler service, actual class received: " + daemon.getClass());
                }
                return compileService;
            }
            KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.EXCEPTION, "daemon not found", null, 4);
        }
        catch (ConnectException e) {
            Object object;
            Object object2;
            StringBuilder stringBuilder;
            DaemonReportCategory daemonReportCategory;
            DaemonReportingTargets daemonReportingTargets;
            KotlinCompilerClient kotlinCompilerClient;
            block10: {
                Object object3;
                Throwable $receiver;
                KotlinCompilerClient kotlinCompilerClient2;
                DaemonReportingTargets daemonReportingTargets2;
                DaemonReportCategory daemonReportCategory2;
                StringBuilder stringBuilder2;
                block9: {
                    Throwable throwable = e;
                    stringBuilder2 = new StringBuilder().append("cannot connect to registry: ");
                    daemonReportCategory2 = DaemonReportCategory.EXCEPTION;
                    daemonReportingTargets2 = reportingTargets;
                    kotlinCompilerClient2 = this;
                    object3 = $receiver.getCause();
                    kotlinCompilerClient = kotlinCompilerClient2;
                    daemonReportingTargets = daemonReportingTargets2;
                    daemonReportCategory = daemonReportCategory2;
                    stringBuilder = stringBuilder2;
                    object2 = object3;
                    if (object2 == null) break block9;
                    $receiver = object2;
                    stringBuilder2 = stringBuilder;
                    daemonReportCategory2 = daemonReportCategory;
                    daemonReportingTargets2 = daemonReportingTargets;
                    kotlinCompilerClient2 = kotlinCompilerClient;
                    object3 = $receiver.getMessage();
                    kotlinCompilerClient = kotlinCompilerClient2;
                    daemonReportingTargets = daemonReportingTargets2;
                    daemonReportCategory = daemonReportCategory2;
                    stringBuilder = stringBuilder2;
                    object2 = object3;
                    if (object2 != null) break block10;
                }
                $receiver = e;
                stringBuilder2 = stringBuilder;
                daemonReportCategory2 = daemonReportCategory;
                daemonReportingTargets2 = daemonReportingTargets;
                kotlinCompilerClient2 = kotlinCompilerClient;
                object3 = $receiver.getMessage();
                kotlinCompilerClient = kotlinCompilerClient2;
                daemonReportingTargets = daemonReportingTargets2;
                daemonReportCategory = daemonReportCategory2;
                stringBuilder = stringBuilder2;
                object2 = object = object3;
            }
            if (object2 == null) {
                object = "unknown exception";
            }
            KotlinCompilerClient.report$default(kotlinCompilerClient, daemonReportingTargets, daemonReportCategory, stringBuilder.append(object).toString(), null, 4);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void startDaemon(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets reportingTargets) {
        javaExecutable = new File(new File(System.getProperty("java.home"), "bin"), "java");
        platformSpecificOptions = CollectionsKt.listOf((Object)"-Djava.awt.headless=true");
        v0 = new String[3];
        v0[0] = javaExecutable.getAbsolutePath();
        v0[1] = "-cp";
        v1 = compilerId.getCompilerClasspath();
        v2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"File.pathSeparator");
        v0[2] = CollectionsKt.joinToString$default((Iterable)v1, (CharSequence)v2, null, null, (int)0, null, null, (int)62);
        var8_7 = daemonJVMOptions.getMappers();
        var21_8 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])v0), (Iterable)platformSpecificOptions);
        var9_9 = $receiver;
        var10_10 = new ArrayList<E>();
        for (T element : $receiver) {
            it = (PropMapper)element;
            list = it.toArgs("-");
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        var22_18 = (List)destination;
        $receiver = daemonOptions.getMappers();
        var21_8 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)var21_8, (Iterable)var22_18), (Object)DaemonParamsKt.getCOMPILER_DAEMON_CLASS_FQN());
        $receiver = $receiver;
        destination = new ArrayList<E>();
        for (T element : $receiver) {
            it = (PropMapper)element;
            list = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        var22_18 = (List)destination;
        $receiver = compilerId.getMappers();
        var21_8 = CollectionsKt.plus((Collection)var21_8, (Iterable)var22_18);
        $receiver = $receiver;
        destination = new ArrayList<E>();
        for (T element : $receiver) {
            it = (PropMapper)element;
            list = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        var22_18 = (List)destination;
        args = CollectionsKt.plus((Collection)var21_8, (Iterable)var22_18);
        KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "starting the daemon as: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62), null, 4);
        processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        daemonLauncher = Native.get(ProcessLauncher.class);
        daemon = daemonLauncher.start(processBuilder);
        var11_11 = new Ref.ObjectRef();
        var11_11.element = new Semaphore(1);
        ((Semaphore)isEchoRead.element).acquire();
        stdoutThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(daemon, daemonOptions, (Ref.ObjectRef)isEchoRead, reportingTargets){
            final /* synthetic */ Process $daemon;
            final /* synthetic */ DaemonOptions $daemonOptions;
            final /* synthetic */ Ref.ObjectRef $isEchoRead;
            final /* synthetic */ DaemonReportingTargets $reportingTargets;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    TextStreamsKt.forEachLine((Reader)ByteStreamsKt.reader$default((InputStream)this.$daemon.getInputStream(), null, (int)1), (Function1)((Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ startDaemon.stdoutThread.1 this$0;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            if (StringsKt.isNotEmpty((CharSequence)this.this$0.$daemonOptions.getRunFilesPath()) && StringsKt.contains$default((CharSequence)it, (CharSequence)this.this$0.$daemonOptions.getRunFilesPath(), (boolean)false, (int)2)) {
                                ((Semaphore)this.this$0.$isEchoRead.element).release();
                                return;
                            }
                            KotlinCompilerClient.INSTANCE.report(this.this$0.$reportingTargets, DaemonReportCategory.DEBUG, it, "daemon");
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                finally {
                    this.$daemon.getInputStream().close();
                    this.$daemon.getOutputStream().close();
                    this.$daemon.getErrorStream().close();
                }
            }
            {
                this.$daemon = process;
                this.$daemonOptions = daemonOptions;
                this.$isEchoRead = objectRef;
                this.$reportingTargets = daemonReportingTargets;
                super(0);
            }
        }), (int)31);
        try {
            v3 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY());
            if (v3 == null) ** GOTO lbl-1000
            list = v3;
            it = (String)$receiver;
            try {
                var17_21 = StringsKt.toLong((String)it);
            }
            catch (Exception e) {
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.INFO, "unable to interpret " + DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY() + " property ('" + it + "'); using default timeout " + KotlinCompilerClient.INSTANCE.getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() + " ms", null, 4);
                var17_21 = null;
            }
            if ((v3 = var17_21) != null) {
                v4 = ((Number)v3).longValue();
            } else lbl-1000:
            // 2 sources

            {
                v4 = daemonStartupTimeout = KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
            }
            if (StringsKt.isNotEmpty((CharSequence)daemonOptions.getRunFilesPath())) {
                succeeded = ((Semaphore)isEchoRead.element).tryAcquire(daemonStartupTimeout, TimeUnit.MILLISECONDS);
                v5 = daemon;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"daemon");
                if (!KotlinCompilerClientKt.isProcessAlive(v5)) {
                    throw (Throwable)new Exception("Daemon terminated unexpectedly");
                }
                if (!succeeded) {
                    throw (Throwable)new Exception("Unable to get response from daemon in " + daemonStartupTimeout + " ms");
                }
            } else {
                Thread.sleep(daemonStartupTimeout);
            }
        }
        finally {
            if (stdoutThread.isAlive()) {
                stdoutThread.stop();
            }
        }
        isEchoRead = null;
    }

    static {
        new KotlinCompilerClient();
    }

    private KotlinCompilerClient() {
        INSTANCE = this;
        INSTANCE$ = this;
        DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
        DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
        verboseReporting = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_VERBOSE_REPORT_PROPERTY()) != null;
        COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    public static final /* synthetic */ int access$extractPortFromRunFilename(KotlinCompilerClient $this, String $receiver, @NotNull String digest) {
        return $this.extractPortFromRunFilename($receiver, digest);
    }

    @Nullable
    public static final /* synthetic */ CompileService access$tryConnectToDaemon(KotlinCompilerClient $this, int port, @NotNull DaemonReportingTargets reportingTargets) {
        return $this.tryConnectToDaemon(port, reportingTargets);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0003\u0011\u001dAa\u0011\u0003\r\u0001e\t\u0001\u0014AQ\b\u0013\u0011!\u0011\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015&AaQ\u0004\t\u000e5\t\u00014AS\n\t\r\u001b\u0001bB\u0007\u00021\u0001IB\u0001B\u0001\t\u00035\t\u00014A\u0015\u0014\t-C\u0001RA\u0007\u000b\u0013!Iq!C\u0001\u0005\u0004%\tA1A\u0005\u0002\t\u0007A:\u0001G\u0002\u001dWE\u001b1!\u0004\u0002\u0005\t!%\u0011&\u0004\u0003D9!\tQ\"\u0001M\u0002#\u000e9Q\u0001A\u0007\u0003\t\u0015AY!\u0005\u0002\u0005\r!\u0011\u0001"}, strings={"Lorg/jetbrains/kotlin/rmi/kotlinr/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/rmi/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/rmi/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy"}, moduleName="kotlin-rmi")
    public static final class ClientOptions
    implements OptionsGroup {
        private boolean stop;

        @NotNull
        public List<PropMapper<?, ?, ?>> getMappers() {
            return CollectionsKt.listOf((Object)new BoolPropMapper((Object)this, KotlinCompilerClient$ClientOptions$mappers$1.INSTANCE, null, 4, null));
        }

        public final boolean getStop() {
            return this.stop;
        }

        public final void setStop(boolean bl) {
            this.stop = bl;
        }

        public ClientOptions(boolean stop) {
            this.stop = stop;
        }

        public /* synthetic */ ClientOptions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public ClientOptions() {
            this(false, 1, null);
        }

        public final boolean component1() {
            return this.stop;
        }

        @NotNull
        public final ClientOptions copy(boolean stop) {
            return new ClientOptions(stop);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n) {
            if ((n & 1) != 0) {
                bl = clientOptions.stop;
            }
            return clientOptions.copy(bl);
        }

        public String toString() {
            return "ClientOptions(stop=" + this.stop + ")";
        }

        public int hashCode() {
            int n = this.stop ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClientOptions)) break block3;
                    ClientOptions clientOptions = (ClientOptions)object;
                    if (!(this.stop == clientOptions.stop)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0002\t\u0007)\u0011\u0001C\u0001\r\u0001e\t\u0001\u0014AQ\u000b\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000b\t6!\u0001\u0005\u0004K!!\u0019\u0001c\u0004\u000e\u0003a9\u0011d\u0001E\u0006\u001b\u0005Ab!J\u0002\t\u00115\t\u0001dB\u0013\u0005\t\u000fA\t\"D\u0001\u0019\u0013%BA!\u0011\u0005\t\b5\u0011A\u0012\u0001\r\u0005#\u000e\tQ\u0001A\u0015\t\t\u0005C\u0001\u0012B\u0007\u0003\u0019\u0003AR!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0017i\u0011\u0001\u0007\u0004R\u0007\u0005)\u0001!K\u0005\u0005\u0004rAi!D\u0001\u0019\u000fq\t\u0001%A)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/rmi/kotlinr/KotlinCompilerClient$FileBasedLock;", "", "compilerId", "Lorg/jetbrains/kotlin/rmi/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/rmi/DaemonOptions;", "(Lorg/jetbrains/kotlin/rmi/CompilerId;Lorg/jetbrains/kotlin/rmi/DaemonOptions;)V", "channel", "Ljava/nio/channels/FileChannel;", "lock", "Ljava/nio/channels/FileLock;", "lockFile", "Ljava/io/File;", "locked", "", "acquireLockFile", "isLocked", "release", ""}, moduleName="kotlin-rmi")
    public static final class FileBasedLock {
        private final File lockFile;
        private volatile boolean locked;
        private final FileChannel channel;
        private final FileLock lock;

        public final boolean isLocked() {
            return this.locked;
        }

        public final synchronized void release() {
            if (this.locked) {
                Unit unit;
                Unit unit2;
                FileLock fileLock = this.lock;
                if (fileLock != null) {
                    fileLock.release();
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                FileChannel fileChannel = this.channel;
                if (fileChannel != null) {
                    fileChannel.close();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.lockFile.delete();
                this.locked = false;
            }
        }

        private final synchronized boolean acquireLockFile(File lockFile) {
            long maxAttempts = DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_LOCK_TIMEOUT_MS() / DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_LOCK_TIMEOUT_CHECK_MS() + (long)1;
            long attempt = 0L;
            while (!(lockFile.createNewFile() || lockFile.delete() && lockFile.createNewFile())) {
                if (lockFile.exists() && ++attempt >= maxAttempts) {
                    throw (Throwable)new IOException("Timeout waiting the release of the lock file '" + lockFile.getAbsolutePath());
                }
                Thread.sleep(DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_LOCK_TIMEOUT_CHECK_MS());
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public FileBasedLock(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            File file;
            Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
            Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
            Iterable iterable = compilerId.getCompilerClasspath();
            String string = "lock";
            String string2 = daemonOptions.getRunFilesPath();
            File file2 = file;
            File file3 = file;
            FileBasedLock fileBasedLock = this;
            void var4_9 = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                String string3 = (String)item;
                list = destination;
                String string4 = new File((String)it).getAbsolutePath();
                list.add(string4);
            }
            list = (List)destination;
            file2(string2, DaemonParamsKt.makeRunFilenameString$default((String)string, (String)DaemonParamsKt.toHexString((byte[])DaemonParamsKt.distinctStringsDigest((Iterable)list)), (String)"0", null, (int)8));
            fileBasedLock.lockFile = file3;
            this.locked = this.acquireLockFile(this.lockFile);
            FileChannel fileChannel = this.channel = this.locked ? new RandomAccessFile(this.lockFile, "rw").getChannel() : (FileChannel)null;
            this.lock = fileChannel != null ? fileChannel.lock() : null;
        }
    }
}

