/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenBuild;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.server.MavenModelConverter;

public class Maven32AetherModelConverter
extends MavenModelConverter {
    public static MavenModel convertModelWithAetherDependencyTree(Model model, List<String> sources, List<String> testSources, Collection<org.apache.maven.artifact.Artifact> dependencies, Collection<DependencyNode> dependencyTree, Collection<org.apache.maven.artifact.Artifact> extensions, File localRepository) throws RemoteException {
        MavenModel result = new MavenModel();
        result.setMavenId(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()));
        Parent parent = model.getParent();
        if (parent != null) {
            result.setParent(new MavenParent(new MavenId(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()), parent.getRelativePath()));
        }
        result.setPackaging(model.getPackaging());
        result.setName(model.getName());
        result.setProperties(model.getProperties() == null ? new Properties() : model.getProperties());
        result.setPlugins(Maven32AetherModelConverter.convertPlugins((Model)model));
        THashMap convertedArtifacts = new THashMap();
        result.setExtensions(Maven32AetherModelConverter.convertArtifacts(extensions, (Map)convertedArtifacts, (File)localRepository));
        result.setDependencies(Maven32AetherModelConverter.convertArtifacts(dependencies, (Map)convertedArtifacts, (File)localRepository));
        result.setDependencyTree(Maven32AetherModelConverter.convertAetherDependencyNodes(null, dependencyTree, (Map<org.apache.maven.artifact.Artifact, MavenArtifact>)convertedArtifacts, localRepository));
        result.setRemoteRepositories(Maven32AetherModelConverter.convertRepositories((List)model.getRepositories()));
        result.setProfiles(Maven32AetherModelConverter.convertProfiles((Collection)model.getProfiles()));
        result.setModules(model.getModules());
        Maven32AetherModelConverter.convertBuild((MavenBuild)result.getBuild(), (Build)model.getBuild(), sources, testSources);
        return result;
    }

    public static List<MavenArtifactNode> convertAetherDependencyNodes(MavenArtifactNode parent, Collection<DependencyNode> nodes, Map<org.apache.maven.artifact.Artifact, MavenArtifact> nativeToConvertedMap, File localRepository) {
        ArrayList<MavenArtifactNode> result = new ArrayList<MavenArtifactNode>(nodes.size());
        for (DependencyNode each : nodes) {
            org.apache.maven.artifact.Artifact a = RepositoryUtils.toArtifact((Artifact)each.getDependency().getArtifact());
            MavenArtifact ma = Maven32AetherModelConverter.convertArtifact((org.apache.maven.artifact.Artifact)a, nativeToConvertedMap, (File)localRepository);
            Map data = each.getData();
            String premanagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)each);
            String premanagedScope = DependencyManagerUtils.getPremanagedScope((DependencyNode)each);
            MavenArtifactState state = MavenArtifactState.ADDED;
            MavenArtifact relatedArtifact = null;
            Object winner = data.get("conflict.winner");
            if (winner instanceof DependencyNode) {
                DependencyNode winnerNode = (DependencyNode)winner;
                if (!StringUtil.equals((CharSequence)each.getVersion().toString(), (CharSequence)winnerNode.getVersion().toString())) {
                    state = MavenArtifactState.CONFLICT;
                    org.apache.maven.artifact.Artifact winnerArtifact = RepositoryUtils.toArtifact((Artifact)winnerNode.getDependency().getArtifact());
                    relatedArtifact = Maven32AetherModelConverter.convertArtifact((org.apache.maven.artifact.Artifact)winnerArtifact, nativeToConvertedMap, (File)localRepository);
                }
            }
            MavenArtifactNode newNode = new MavenArtifactNode(parent, ma, state, relatedArtifact, each.getDependency().getScope(), premanagedVersion, premanagedScope);
            newNode.setDependencies(Maven32AetherModelConverter.convertAetherDependencyNodes(newNode, each.getChildren(), nativeToConvertedMap, localRepository));
            result.add(newNode);
        }
        return result;
    }
}

