/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.remote;

import java.rmi.RemoteException;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteVariableImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.ValueImpl;

class RemoteFrameImpl
extends PortableRemoteObject
implements RemoteDebugger.Frame {
    private final Debugger.Frame myFrame;

    private RemoteFrameImpl(Debugger.Frame frame) throws RemoteException {
        this.myFrame = frame;
    }

    @Override
    public int getLineNumber() {
        return this.myFrame.getLineNumber();
    }

    @Override
    public String getURI() {
        return this.myFrame.getURI();
    }

    @Override
    public RemoteDebugger.Frame getNext() throws RemoteException {
        return RemoteFrameImpl.create(this.myFrame.getNext());
    }

    @Override
    public RemoteDebugger.Frame getPrevious() throws RemoteException {
        return RemoteFrameImpl.create(this.myFrame.getPrevious());
    }

    @Override
    public String getXPath() throws RemoteException {
        return ((Debugger.SourceFrame)this.myFrame).getXPath();
    }

    @Override
    public ValueImpl eval(String expr) throws Debugger.EvaluationException {
        Value value = ((Debugger.StyleFrame)this.myFrame).eval(expr);
        return new ValueImpl(value.getValue(), value.getType());
    }

    @Override
    public List<RemoteDebugger.Variable> getVariables() throws RemoteException {
        return RemoteVariableImpl.convert(((Debugger.StyleFrame)this.myFrame).getVariables());
    }

    @Override
    public String getInstruction() throws RemoteException {
        return ((Debugger.StyleFrame)this.myFrame).getInstruction();
    }

    public static RemoteFrameImpl create(Debugger.Frame frame) throws RemoteException {
        return frame != null ? new RemoteFrameImpl(frame) : null;
    }
}

