/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.ant.model.impl;

import com.intellij.util.containers.hash.HashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ant.model.JpsAntBuildFileOptions;
import org.jetbrains.jps.ant.model.JpsAntConfiguration;
import org.jetbrains.jps.ant.model.impl.JpsAntBuildFileOptionsImpl;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;

public class JpsAntConfigurationImpl
extends JpsElementBase<JpsAntConfigurationImpl>
implements JpsAntConfiguration {
    public static final JpsElementChildRole<JpsAntConfiguration> ROLE = JpsElementChildRoleBase.create((String)"ant configuration");
    private String myProjectDefaultAntName;
    private final Map<String, JpsAntBuildFileOptions> myOptionsMap = new HashMap();

    public JpsAntConfigurationImpl(Map<String, JpsAntBuildFileOptions> options, String projectDefaultAntName) {
        this.myProjectDefaultAntName = projectDefaultAntName;
        this.myOptionsMap.putAll(options);
    }

    @NotNull
    public JpsAntConfigurationImpl createCopy() {
        JpsAntConfigurationImpl jpsAntConfigurationImpl = new JpsAntConfigurationImpl(this.myOptionsMap, this.myProjectDefaultAntName);
        if (jpsAntConfigurationImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/model/impl/JpsAntConfigurationImpl", "createCopy"));
        }
        return jpsAntConfigurationImpl;
    }

    @Override
    public void setProjectDefaultAntName(@Nullable String projectDefaultAntName) {
        this.myProjectDefaultAntName = projectDefaultAntName;
    }

    @Override
    @Nullable
    public String getProjectDefaultAntName() {
        return this.myProjectDefaultAntName;
    }

    public void applyChanges(@NotNull JpsAntConfigurationImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/ant/model/impl/JpsAntConfigurationImpl", "applyChanges"));
        }
    }

    @Override
    @NotNull
    public Collection<JpsAntBuildFileOptions> getOptionsForAllBuildFiles() {
        Collection<JpsAntBuildFileOptions> collection = this.myOptionsMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/model/impl/JpsAntConfigurationImpl", "getOptionsForAllBuildFiles"));
        }
        return collection;
    }

    @Override
    @NotNull
    public JpsAntBuildFileOptions getOptions(@NotNull String buildFileUrl) {
        if (buildFileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFileUrl", "org/jetbrains/jps/ant/model/impl/JpsAntConfigurationImpl", "getOptions"));
        }
        JpsAntBuildFileOptions options = this.myOptionsMap.get(buildFileUrl);
        if (options != null) {
            JpsAntBuildFileOptions jpsAntBuildFileOptions = options;
            if (jpsAntBuildFileOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/model/impl/JpsAntConfigurationImpl", "getOptions"));
            }
            return jpsAntBuildFileOptions;
        }
        JpsAntBuildFileOptionsImpl jpsAntBuildFileOptionsImpl = new JpsAntBuildFileOptionsImpl();
        if (jpsAntBuildFileOptionsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/model/impl/JpsAntConfigurationImpl", "getOptions"));
        }
        return jpsAntBuildFileOptionsImpl;
    }
}

