/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Normalizer;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public class FileUtil {
    public static String readSymlink(File path) throws IOException {
        String targetString = FileSystemUtil.resolveSymLink((File)path);
        if (targetString == null) {
            targetString = path.getAbsolutePath();
        }
        if (SystemReader.getInstance().isWindows()) {
            targetString = targetString.replace('\\', '/');
        } else if (SystemReader.getInstance().isMacOS()) {
            targetString = Normalizer.normalize(targetString, Normalizer.Form.NFC);
        }
        return targetString;
    }

    public static void createSymLink(File path, String target) throws IOException {
        Path nioPath = path.toPath();
        if (Files.exists(nioPath, LinkOption.NOFOLLOW_LINKS)) {
            Files.delete(nioPath);
        }
        if (SystemReader.getInstance().isWindows()) {
            target = target.replace('/', '\\');
        }
        Path nioTarget = new File(target).toPath();
        Files.createSymbolicLink(nioPath, nioTarget, new FileAttribute[0]);
    }

    public static boolean isSymlink(File path) {
        return FileSystemUtil.isSymLink((File)path);
    }

    public static long lastModified(File path) throws IOException {
        return FileSystemUtil.lastModified((File)path);
    }

    public static void setLastModified(File path, long time) throws IOException {
    }

    public static boolean exists(File path) {
        return path.exists();
    }

    public static boolean isHidden(File path) throws IOException {
        FileAttributes attributes = FileSystemUtil.getAttributes((File)path);
        return attributes != null && attributes.isHidden();
    }

    public static void setHidden(File path, boolean hidden) throws IOException {
        ProcessBuilder command = new ProcessBuilder("attrib", hidden ? "+H" : "-H", path.getAbsolutePath());
        try {
            FileUtil.runCommand(command);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private static int runCommand(ProcessBuilder command) throws IOException, InterruptedException {
        final Process process = command.start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    try {
                        while (reader.readLine() != null) {
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "io test").start();
        return process.waitFor();
    }

    public static long getLength(File path) throws IOException {
        FileAttributes attributes = FileSystemUtil.getAttributes((File)path);
        return attributes == null ? -1L : attributes.length;
    }

    public static boolean isDirectory(File path) {
        FileAttributes attributes = FileSystemUtil.getAttributes((File)path);
        return attributes != null && attributes.isDirectory();
    }

    public static boolean isFile(File path) {
        FileAttributes attributes = FileSystemUtil.getAttributes((File)path);
        return attributes != null && attributes.isFile();
    }

    public static boolean canExecute(File path) {
        if (!FileUtil.isFile(path)) {
            return false;
        }
        return path.canExecute();
    }

    public static void delete(File path) throws IOException {
        com.intellij.openapi.util.io.FileUtil.delete((File)path);
    }

    static FS.Attributes getFileAttributesBasic(FS fs, File path) {
        FileAttributes attributes = FileSystemUtil.getAttributes((File)path);
        if (attributes == null) {
            return new Java7BasicAttributes(fs, path, false, false, false, false, false, 0L, 0L, 0L);
        }
        return new Java7BasicAttributes(fs, path, true, attributes.isDirectory(), path.canExecute(), attributes.isSymLink(), attributes.isFile(), 0L, attributes.lastModified, attributes.length);
    }

    public static FS.Attributes getFileAttributesPosix(FS fs, File path) {
        return FileUtil.getFileAttributesBasic(fs, path);
    }

    public static File normalize(File file) {
        if (SystemReader.getInstance().isMacOS()) {
            String normalized = Normalizer.normalize(file.getPath(), Normalizer.Form.NFC);
            return new File(normalized);
        }
        return file;
    }

    public static String normalize(String name) {
        if (SystemReader.getInstance().isMacOS()) {
            if (name == null) {
                return null;
            }
            return Normalizer.normalize(name, Normalizer.Form.NFC);
        }
        return name;
    }

    static class Java7BasicAttributes
    extends FS.Attributes {
        Java7BasicAttributes(FS fs, File fPath, boolean exists, boolean isDirectory, boolean isExecutable, boolean isSymbolicLink, boolean isRegularFile, long creationTime, long lastModifiedTime, long length) {
            super(fs, fPath, exists, isDirectory, isExecutable, isSymbolicLink, isRegularFile, creationTime, lastModifiedTime, length);
        }
    }
}

