/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubAuthDataHolder {
    @NotNull
    private GithubAuthData myAuthData;

    public GithubAuthDataHolder(@NotNull GithubAuthData auth) {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/util/GithubAuthDataHolder", "<init>"));
        }
        this.myAuthData = auth;
    }

    @NotNull
    public synchronized GithubAuthData getAuthData() {
        GithubAuthData githubAuthData = this.myAuthData;
        if (githubAuthData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubAuthDataHolder", "getAuthData"));
        }
        return githubAuthData;
    }

    public synchronized <T extends Throwable> void runTransaction(@NotNull GithubAuthData expected, @NotNull ThrowableComputable<GithubAuthData, T> task) throws T {
        if (expected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expected", "org/jetbrains/plugins/github/util/GithubAuthDataHolder", "runTransaction"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/github/util/GithubAuthDataHolder", "runTransaction"));
        }
        if (expected != this.myAuthData) {
            return;
        }
        this.myAuthData = (GithubAuthData)task.compute();
    }

    public static GithubAuthDataHolder createFromSettings() {
        return new GithubAuthDataHolder(GithubSettings.getInstance().getAuthData());
    }
}

