/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DumpSysAction;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import org.jetbrains.annotations.NotNull;

public class DumpSysActions {
    public static DefaultActionGroup create(@NotNull Project p, final @NotNull DeviceContext context) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/ddms/actions/DumpSysActions", "create"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/ddms/actions/DumpSysActions", "create"));
        }
        DefaultActionGroup group = new DefaultActionGroup("System Information", true){

            public void update(AnActionEvent e) {
                e.getPresentation().setText("System Information");
                e.getPresentation().setIcon(AndroidIcons.Ddms.SysInfo);
                e.getPresentation().setEnabled(context.getSelectedDevice() != null);
            }

            public boolean isDumbAware() {
                return true;
            }
        };
        group.add((AnAction)new MyDumpSysAction(p, context, "activity", "Activity Manager State"));
        group.add((AnAction)new MyDumpSysAction(p, context, "package", "Package Information"));
        group.add((AnAction)new MyDumpSysAction(p, context, "meminfo", "Memory Usage"));
        group.add((AnAction)new MyDumpProcStatsAction(p, context, "procstats", "Memory use over time"));
        group.add((AnAction)new MyDumpSysAction(p, context, "gfxinfo", "Graphics State"));
        return group;
    }

    private static class MyDumpProcStatsAction
    extends MyDumpSysAction {
        public MyDumpProcStatsAction(@NotNull Project p, @NotNull DeviceContext context, @NotNull String service, @NotNull String description) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpProcStatsAction", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpProcStatsAction", "<init>"));
            }
            if (service == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpProcStatsAction", "<init>"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpProcStatsAction", "<init>"));
            }
            super(p, context, service, description);
        }

        @Override
        protected boolean isEnabled() {
            return super.isEnabled() && this.myDeviceContext.getSelectedDevice() != null && this.myDeviceContext.getSelectedDevice().supportsFeature(IDevice.Feature.PROCSTATS);
        }
    }

    private static class MyDumpSysAction
    extends AbstractDeviceAction {
        private final String myService;
        private final Project myProject;

        public MyDumpSysAction(@NotNull Project p, @NotNull DeviceContext context, @NotNull String service, @NotNull String description) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpSysAction", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpSysAction", "<init>"));
            }
            if (service == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpSysAction", "<init>"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpSysAction", "<init>"));
            }
            super(context, description, null, null);
            this.myProject = p;
            this.myService = service;
        }

        @Override
        protected void performAction(@NotNull IDevice device) {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/ddms/actions/DumpSysActions$MyDumpSysAction", "performAction"));
            }
            new DumpSysAction(this.myProject, this.myDeviceContext.getSelectedDevice(), this.myService, this.myDeviceContext.getSelectedClient()).performAction();
        }
    }
}

