/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.StyleResolver;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ProjectThemeResolver {
    private static final Logger LOG = Logger.getInstance(ProjectThemeResolver.class);

    public static ImmutableList<ThemeWithSource> getEditableProjectThemes(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ProjectThemeResolver", "getEditableProjectThemes"));
        }
        VirtualFile projectFile = project.getProjectFile();
        assert (projectFile != null) : String.format("Project %s doesn't have project file", project.getName());
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            Configuration configuration = facet.getConfigurationManager().getConfiguration(projectFile);
            StyleResolver resolver = new StyleResolver(configuration);
            LocalResourceRepository resources = facet.getModuleResources(true);
            Map styles = resources.getConfiguredResources(ResourceType.STYLE, configuration.getFullConfig());
            for (StyleResourceValue value : ProjectThemeResolver.getThemesFromResources(styles, configuration)) {
                ThemeEditorStyle themeEditorStyle = resolver.getStyle(value.getName());
                builder.add((Object)new ThemeWithSource(themeEditorStyle, module));
            }
        }
        return builder.build();
    }

    @NotNull
    private static List<StyleResourceValue> getThemesFromResources(@NotNull Map<String, ResourceValue> styles, @NotNull Configuration configuration) {
        if (styles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styles", "com/android/tools/idea/editors/theme/ProjectThemeResolver", "getThemesFromResources"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ProjectThemeResolver", "getThemesFromResources"));
        }
        Collection<ResourceValue> values = styles.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values.size());
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        HashMap cache = Maps.newHashMapWithExpectedSize((int)values.size());
        for (ResourceValue value : values) {
            StyleResourceValue styleValue;
            if (!(value instanceof StyleResourceValue) || !resolver.isTheme((ResourceValue)(styleValue = (StyleResourceValue)value), (Map)cache)) continue;
            themes.add(styleValue);
        }
        ArrayList<StyleResourceValue> arrayList = themes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ProjectThemeResolver", "getThemesFromResources"));
        }
        return arrayList;
    }

    public static class ThemeWithSource {
        @NotNull
        final ThemeEditorStyle myTheme;
        @NotNull
        final Module mySourceModule;

        public ThemeWithSource(@NotNull ThemeEditorStyle theme, @NotNull Module sourceModule) {
            if (theme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/android/tools/idea/editors/theme/ProjectThemeResolver$ThemeWithSource", "<init>"));
            }
            if (sourceModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceModule", "com/android/tools/idea/editors/theme/ProjectThemeResolver$ThemeWithSource", "<init>"));
            }
            this.myTheme = theme;
            this.mySourceModule = sourceModule;
        }

        @NotNull
        public ThemeEditorStyle getTheme() {
            ThemeEditorStyle themeEditorStyle = this.myTheme;
            if (themeEditorStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ProjectThemeResolver$ThemeWithSource", "getTheme"));
            }
            return themeEditorStyle;
        }

        @NotNull
        public Module getSourceModule() {
            Module module = this.mySourceModule;
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ProjectThemeResolver$ThemeWithSource", "getSourceModule"));
            }
            return module;
        }
    }
}

