/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.attributes.editors.ColorComponent;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ColorRenderer
implements TableCellRenderer {
    private static final Logger LOG = Logger.getInstance(ColorRenderer.class);
    private final ColorComponent myComponent;
    private final ThemeEditorContext myContext;

    public ColorRenderer(@NotNull ThemeEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/ColorRenderer", "<init>"));
        }
        this.myContext = context;
        this.myComponent = new ColorComponent();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        if (obj instanceof EditedStyleItem) {
            EditedStyleItem item = (EditedStyleItem)obj;
            List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)this.myContext.getResourceResolver(), (ResourceValue)item.getItemResourceValue());
            this.myComponent.configure(item, colors);
        } else {
            LOG.error(String.format("Object passed to ColorRendererEditor has class %1$s instead of ItemResourceValueWrapper", obj.getClass().getName()));
        }
        return this.myComponent;
    }
}

