/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DelegatingCellRenderer
implements TableCellRenderer {
    private final TableCellRenderer myDelegate;

    public DelegatingCellRenderer(TableCellRenderer delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        EditedStyleItem item = value instanceof EditedStyleItem ? (EditedStyleItem)value : null;
        Component returnedComponent = this.myDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ThemeEditorStyle selectedStyle = ((AttributesTableModel)table.getModel()).getSelectedStyle();
        returnedComponent.setFont(selectedStyle.hasItem(item) ? table.getFont().deriveFont(1) : table.getFont());
        returnedComponent.setForeground((Color)(item != null && !item.isPublicAttribute() ? JBColor.LIGHT_GRAY : table.getForeground()));
        if (!(returnedComponent instanceof JComponent)) {
            return returnedComponent;
        }
        JComponent jComponent = (JComponent)returnedComponent;
        Point mousePos = table.getMousePosition();
        if (mousePos != null && item != null) {
            if (table.getCellRect(row, column, true).contains(mousePos)) {
                ItemResourceValue resValue = ((EditedStyleItem)value).getItemResourceValue();
                Configuration configuration = item.getSourceStyle().getConfiguration();
                String toolTipText = ThemeEditorUtils.generateToolTipText(resValue, configuration.getModule(), configuration);
                jComponent.setToolTipText(toolTipText);
            }
        } else {
            jComponent.setToolTipText(null);
        }
        return returnedComponent;
    }
}

