/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class ProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    public static final String GRADLE_DSL_METHOD_NOT_FOUND_ERROR_PREFIX = "Gradle DSL method not found";
    public static final String CONNECTION_PERMISSION_DENIED_PREFIX = "Connection to the Internet denied.";
    public static final String INSTALL_ANDROID_SUPPORT_REPO = "Please install the Android Support Repository from the Android SDK Manager.";
    private static final Pattern SDK_NOT_FOUND_PATTERN = Pattern.compile("The SDK directory '(.*?)' does not exist.");
    private static final Pattern CLASS_NOT_FOUND_PATTERN = Pattern.compile("(.+) not found.");
    private static final String EMPTY_LINE = "\n\n";
    private static final String UNSUPPORTED_GRADLE_VERSION_ERROR = "Gradle version 2.2.1 is required";
    private static final String SDK_DIR_PROPERTY_MISSING = "No sdk.dir property defined in local.properties file.";
    private static final Pattern ERROR_LOCATION_PATTERN = Pattern.compile(".* file '(.*)'( line: ([\\d]+))?");

    @Nullable
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        String msg;
        String message;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "getUserFriendlyError"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "getUserFriendlyError"));
        }
        if (error instanceof ExternalSystemException) {
            return (ExternalSystemException)error;
        }
        Pair rootCauseAndLocation = this.getRootCauseAndLocation(error);
        Throwable rootCause = (Throwable)rootCauseAndLocation.getFirst();
        if (ProjectImportErrorHandler.isOldGradleVersion(rootCause)) {
            String msg2 = "The project is using an unsupported version of Gradle.\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
            return this.createUserFriendlyError(msg2, null, new String[0]);
        }
        String rootCauseText = rootCause.toString();
        if (StringUtil.startsWith((CharSequence)rootCauseText, (CharSequence)"org.gradle.api.internal.MissingMethodException")) {
            String method = this.parseMissingMethod(rootCauseText);
            return this.createUserFriendlyError("Gradle DSL method not found: '" + method + "'", (String)rootCauseAndLocation.getSecond(), new String[0]);
        }
        if (rootCause instanceof SocketException && (message = rootCause.getMessage()) != null && message.contains("Permission denied: connect")) {
            return this.createUserFriendlyError(CONNECTION_PERMISSION_DENIED_PREFIX, null, new String[0]);
        }
        if (rootCause instanceof UnknownHostException) {
            msg = String.format("Unknown host '%1$s'. You may need to adjust the proxy settings in Gradle.", rootCause.getMessage());
            return this.createUserFriendlyError(msg, null, new String[0]);
        }
        if ((rootCause instanceof IllegalStateException || rootCause instanceof ExternalSystemException) && (msg = rootCause.getMessage()) != null) {
            if (msg.startsWith("failed to find target android-")) {
                return this.createUserFriendlyError(msg, null, new String[0]);
            }
            if (msg.startsWith("failed to find Build Tools")) {
                return this.createUserFriendlyError(msg, null, new String[0]);
            }
        }
        if (rootCause instanceof RuntimeException) {
            msg = rootCause.getMessage();
            if (msg != null && msg.contains("Could not find") && msg.contains("com.android.support:")) {
                String newMsg = msg + EMPTY_LINE + INSTALL_ANDROID_SUPPORT_REPO;
                return this.createUserFriendlyError(newMsg, null, new String[0]);
            }
            if (msg != null && msg.contains("failed to parse SDK")) {
                String newMsg = msg + EMPTY_LINE + "The Android SDK may be missing the directory 'add-ons'.";
                return this.createUserFriendlyError(newMsg, null, new String[0]);
            }
            if (msg != null && (msg.equals(SDK_DIR_PROPERTY_MISSING) || SDK_NOT_FOUND_PATTERN.matcher(msg).matches())) {
                String newMsg = msg;
                File buildProperties = new File(projectPath, "local.properties");
                if (buildProperties.isFile()) {
                    newMsg = newMsg + "\n\nPlease fix the 'sdk.dir' property in the local.properties file.";
                }
                return this.createUserFriendlyError(newMsg, null, new String[0]);
            }
        }
        if (rootCause instanceof OutOfMemoryError) {
            String originalMessage = rootCause.getMessage();
            String msg3 = "Out of memory";
            if (originalMessage != null && !originalMessage.isEmpty()) {
                msg3 = msg3 + ": " + originalMessage;
            }
            return this.createUserFriendlyError(msg3, null, new String[0]);
        }
        if (rootCause instanceof NoSuchMethodError) {
            msg = String.format("Unable to find method '%1$s'.", rootCause.getMessage());
            return this.createUserFriendlyError(msg, null, new String[0]);
        }
        if (rootCause instanceof ClassNotFoundException) {
            String className = rootCause.getMessage();
            Matcher matcher = CLASS_NOT_FOUND_PATTERN.matcher(className);
            if (matcher.matches()) {
                className = matcher.group(1);
            }
            String msg4 = String.format("Unable to load class '%1$s'.", className);
            return this.createUserFriendlyError(msg4, null, new String[0]);
        }
        return null;
    }

    private static boolean isOldGradleVersion(@NotNull Throwable error) {
        String msg;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "isOldGradleVersion"));
        }
        if (error instanceof UnsupportedVersionException) {
            return true;
        }
        if (error instanceof UnsupportedMethodException && (msg = error.getMessage()) != null && msg.contains("GradleProject.getBuildScript")) {
            return true;
        }
        if (error instanceof ClassNotFoundException && (msg = error.getMessage()) != null && msg.contains(ToolingModelBuilderRegistry.class.getName())) {
            return true;
        }
        return error instanceof RuntimeException && (msg = error.getMessage()) != null && msg.startsWith(UNSUPPORTED_GRADLE_VERSION_ERROR);
    }

    @Nullable
    public String getLocationFrom(@NotNull Throwable error) {
        String location;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "getLocationFrom"));
        }
        String errorToString = error.toString();
        if (errorToString.contains("LocationAwareException") && (location = error.getMessage()) != null && (location.startsWith("Build file '") || location.startsWith("Settings file '"))) {
            String[] lines = StringUtil.splitByLines((String)location);
            return lines.length > 0 ? lines[0] : null;
        }
        return null;
    }

    @NotNull
    public ExternalSystemException createUserFriendlyError(@NotNull String msg, @Nullable String location, String ... quickFixes) {
        Pair<String, Integer> pair;
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "createUserFriendlyError"));
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "createUserFriendlyError"));
        }
        if (!StringUtil.isEmpty((String)location) && (pair = ProjectImportErrorHandler.getErrorLocation(location)) != null) {
            LocationAwareExternalSystemException locationAwareExternalSystemException = new LocationAwareExternalSystemException(msg, (String)pair.first, (Integer)pair.getSecond(), quickFixes);
            if (locationAwareExternalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "createUserFriendlyError"));
            }
            return locationAwareExternalSystemException;
        }
        ExternalSystemException externalSystemException = new ExternalSystemException(msg, null, quickFixes);
        if (externalSystemException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "createUserFriendlyError"));
        }
        return externalSystemException;
    }

    @VisibleForTesting
    @Nullable
    static Pair<String, Integer> getErrorLocation(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "getErrorLocation"));
        }
        Matcher matcher = ERROR_LOCATION_PATTERN.matcher(location);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            String lineAsText = matcher.group(3);
            if (lineAsText != null) {
                try {
                    line = Integer.parseInt(lineAsText);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        return null;
    }
}

