/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.ImageUtils;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.Gray;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconCache {
    private static final Logger LOG = Logger.getInstance(GutterIconCache.class);
    private static final int MAX_WIDTH = 16;
    private static final int MAX_HEIGHT = 16;
    private static final Icon NONE = AndroidIcons.Android;
    private static final GutterIconCache ourInstance = new GutterIconCache();
    private Map<String, Icon> myThumbnailCache = Maps.newHashMap();
    private boolean myRetina;
    private static boolean ourRetinaEnabled = true;

    @NotNull
    public static GutterIconCache getInstance() {
        GutterIconCache gutterIconCache = ourInstance;
        if (gutterIconCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/GutterIconCache", "getInstance"));
        }
        return gutterIconCache;
    }

    @Nullable
    public Icon getIcon(@NotNull String path) {
        Icon myIcon;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/rendering/GutterIconCache", "getIcon"));
        }
        boolean isRetina = UIUtil.isRetina();
        if (this.myRetina != isRetina) {
            this.myRetina = isRetina;
            this.myThumbnailCache.clear();
        }
        if ((myIcon = this.myThumbnailCache.get(path)) == null) {
            myIcon = GutterIconCache.createIcon(path);
            if (myIcon == null) {
                myIcon = NONE;
            }
            this.myThumbnailCache.put(path, myIcon);
        }
        return myIcon != NONE ? myIcon : null;
    }

    @Nullable
    private static Icon createIcon(String path) {
        try {
            BufferedImage image = ImageIO.read(new File(path));
            if (image != null) {
                int imageWidth = image.getWidth();
                int imageHeight = image.getHeight();
                if (ourRetinaEnabled && UIUtil.isRetina()) {
                    BufferedImage scaled = image;
                    if (imageWidth > 32 || imageHeight > 32) {
                        double scale = 2.0 * Math.min(16.0 / (double)imageWidth, 16.0 / (double)imageHeight);
                        scaled = ImageUtils.scale(image, scale, scale);
                    }
                    int scale = 2;
                    if (scaled.getWidth() >= 2 && scaled.getHeight() >= 2) {
                        try {
                            Image hdpiImage = RetinaImage.createFrom((Image)scaled, (int)2, null);
                            return new RetinaImageIcon(hdpiImage);
                        }
                        catch (Throwable t) {
                            ourRetinaEnabled = false;
                        }
                    }
                }
                if (imageWidth > 16 || imageHeight > 16) {
                    double scale = Math.min(16.0 / (double)imageWidth, 16.0 / (double)imageHeight);
                    if (image.getType() == 13) {
                        BufferedImage bg = UIUtil.createImage((int)imageWidth, (int)imageHeight, (int)2);
                        Graphics g = bg.getGraphics();
                        g.setColor(Gray.TRANSPARENT);
                        g.fillRect(0, 0, bg.getWidth(), bg.getHeight());
                        UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
                        g.dispose();
                        image = bg;
                    }
                    image = ImageUtils.scale(image, scale, scale);
                }
                return new ImageIcon(image);
            }
        }
        catch (IOException e) {
            LOG.error(String.format("Could not read icon image %1$s", path), (Throwable)e);
        }
        return null;
    }

    private static class RetinaImageIcon
    extends ImageIcon {
        private RetinaImageIcon(Image image) {
            super(image, "");
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            UIUtil.drawImage((Graphics)g, (Image)this.getImage(), (int)x, (int)y, null);
        }
    }
}

