/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDescAddon;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalAddonPkgInfo;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.IAndroidVersionProvider;
import com.android.tools.idea.sdk.remote.internal.packages.LayoutlibVersionMixin;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePackageParserUtils;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class RemoteAddonPkgInfo
extends RemotePkgInfo
implements IAndroidVersionProvider {
    private final LayoutlibVersionMixin mLayoutlibVersion;
    private final Lib[] mLibs;

    public RemoteAddonPkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        String nameId = RemotePackageParserUtils.getXmlString(packageNode, "name-id").trim();
        String nameDisp = RemotePackageParserUtils.getXmlString(packageNode, "name-display").trim();
        String name = RemotePackageParserUtils.getXmlString(packageNode, "name").trim();
        if (nameDisp.length() == 0) {
            nameDisp = name;
        }
        if (nameId.length() == 0) {
            nameId = LocalAddonPkgInfo.sanitizeDisplayToNameId((String)(name.length() > 0 ? name : nameDisp));
        }
        assert (nameId.length() > 0);
        assert (nameDisp.length() > 0);
        String vendorId = RemotePackageParserUtils.getXmlString(packageNode, "vendor-id").trim();
        String vendorDisp = RemotePackageParserUtils.getXmlString(packageNode, "vendor-display").trim();
        String vendor = RemotePackageParserUtils.getXmlString(packageNode, "vendor").trim();
        if (vendorDisp.length() == 0) {
            vendorDisp = vendor;
        }
        if (vendorId.length() == 0) {
            boolean hasVendor = vendor.length() > 0;
            vendorId = LocalAddonPkgInfo.sanitizeDisplayToNameId((String)(hasVendor ? vendor : vendorDisp));
        }
        assert (vendorId.length() > 0);
        assert (vendorDisp.length() > 0);
        int apiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        AndroidVersion androidVersion = new AndroidVersion(apiLevel, null);
        this.mLibs = this.parseLibs(RemotePackageParserUtils.findChildElement(packageNode, "libs"));
        this.mLayoutlibVersion = new LayoutlibVersionMixin(packageNode);
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newAddon((AndroidVersion)androidVersion, (MajorRevision)new MajorRevision(this.getRevision()), (IdDisplay)new IdDisplay(vendorId, vendorDisp), (IdDisplay)new IdDisplay(nameId, nameDisp));
        pkgDescBuilder.setDescriptionShort(RemoteAddonPkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), nameDisp, androidVersion, this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemoteAddonPkgInfo.createListDescription(this.mListDisplay, nameDisp, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.getAndroidVersion().saveProperties(props);
        this.mLayoutlibVersion.saveProperties(props);
        props.setProperty("Addon.NameId", ((IPkgDescAddon)this.getPkgDesc()).getName().getId());
        props.setProperty("Addon.NameDisplay", ((IPkgDescAddon)this.getPkgDesc()).getName().getDisplay());
        props.setProperty("Addon.VendorId", this.getPkgDesc().getVendor().getId());
        props.setProperty("Addon.VendorDisplay", this.getPkgDesc().getVendor().getDisplay());
    }

    private Lib[] parseLibs(Node libsNode) {
        ArrayList<Lib> libs = new ArrayList<Lib>();
        if (libsNode != null) {
            String nsUri = libsNode.getNamespaceURI();
            for (Node child = libsNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"lib".equals(child.getLocalName())) continue;
                libs.add(this.parseLib(child));
            }
        }
        return libs.toArray(new Lib[libs.size()]);
    }

    private Lib parseLib(Node libNode) {
        return new Lib(RemotePackageParserUtils.getXmlString(libNode, "name"), RemotePackageParserUtils.getXmlString(libNode, "description"));
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.getPkgDesc().getAndroidVersion();
    }

    @NonNull
    public Lib[] getLibs() {
        return this.mLibs;
    }

    @Override
    @NonNull
    public String installId() {
        return RemoteAddonPkgInfo.encodeAddonName(((IPkgDescAddon)this.getPkgDesc()).getName().getId(), this.getPkgDesc().getVendor().getId(), this.getAndroidVersion());
    }

    private static String createListDescription(String listDisplay, String displayName, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        return String.format("%1$s%2$s", displayName, obsolete ? " (Obsolete)" : "");
    }

    private static String createShortDescription(String listDisplay, FullRevision revision, String displayName, AndroidVersion version, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        return String.format("%1$s, Android API %2$s, revision %3$s%4$s", displayName, version.getApiString(), revision.toShortString(), obsolete ? " (Obsolete)" : "");
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File addons = new File(osSdkRoot, "add-ons");
        IdDisplay name = ((IPkgDescAddon)this.getPkgDesc()).getName();
        IdDisplay vendor = this.getPkgDesc().getVendor();
        for (IAndroidTarget target : sdkManager.getTargets()) {
            if (target.isPlatform() || !target.getVersion().equals((Object)this.getAndroidVersion()) || (!target.getName().equals(name.getId()) || !target.getVendor().equals(vendor.getId())) && (!target.getName().equals(name.getDisplay()) || !target.getVendor().equals(vendor.getDisplay()))) continue;
            return new File(target.getLocation());
        }
        String dir = RemoteAddonPkgInfo.encodeAddonName(name.getId(), vendor.getId(), this.getAndroidVersion());
        for (int i = 0; i < 100; ++i) {
            String dir2 = i == 0 ? dir : String.format("%s-%d", dir, i);
            File folder = new File(addons, dir2);
            if (folder.exists()) continue;
            return folder;
        }
        return null;
    }

    private static String encodeAddonName(String nameId, String vendorId, AndroidVersion version) {
        String name = String.format("addon-%s-%s-%s", nameId, vendorId, version.getApiString());
        name = name.toLowerCase(Locale.US);
        name = name.replaceAll("[^a-z0-9_-]+", "_");
        name = name.replaceAll("_+", "_");
        return name;
    }

    @Override
    public boolean sameItemAs(LocalPkgInfo pkg, FullRevision.PreviewComparison previewComparison) {
        if (pkg instanceof LocalAddonPkgInfo) {
            LocalAddonPkgInfo localPkg = (LocalAddonPkgInfo)pkg;
            String nameId = ((IPkgDescAddon)this.getPkgDesc()).getName().getId();
            if (Objects.equal((Object)nameId, (Object)((IPkgDescAddon)localPkg.getDesc()).getName()) && this.getAndroidVersion().equals((Object)localPkg.getDesc().getAndroidVersion()) && this.getPkgDesc().getVendor().equals((Object)localPkg.getDesc().getVendor())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mLayoutlibVersion == null ? 0 : this.mLayoutlibVersion.hashCode());
        result = 31 * result + Arrays.hashCode(this.mLibs);
        String name = ((IPkgDescAddon)this.getPkgDesc()).getName().getDisplay();
        result = 31 * result + (name == null ? 0 : name.hashCode());
        result = 31 * result + (this.getPkgDesc().hasVendor() ? 0 : this.getPkgDesc().getVendor().hashCode());
        result = 31 * result + this.getAndroidVersion().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RemoteAddonPkgInfo)) {
            return false;
        }
        RemoteAddonPkgInfo other = (RemoteAddonPkgInfo)obj;
        if (this.mLayoutlibVersion == null ? other.mLayoutlibVersion != null : !this.mLayoutlibVersion.equals(other.mLayoutlibVersion)) {
            return false;
        }
        return Arrays.equals(this.mLibs, other.mLibs);
    }

    public static class Lib {
        private final String mName;
        private final String mDescription;

        public Lib(String name, String description) {
            this.mName = name;
            this.mDescription = description;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mDescription == null ? 0 : this.mDescription.hashCode());
            result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Lib)) {
                return false;
            }
            Lib other = (Lib)obj;
            if (this.mDescription == null ? other.mDescription != null : !this.mDescription.equals(other.mDescription)) {
                return false;
            }
            return !(this.mName == null ? other.mName != null : !this.mName.equals(other.mName));
        }
    }
}

