/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.gradle;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.structure.gradle.BuildFilePanel;
import com.android.tools.idea.structure.gradle.KeyValuePane;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class SingleObjectPanel
extends BuildFilePanel
implements KeyValuePane.ModificationListener {
    protected final GrClosableBlock myRoot;
    protected final Map<BuildFileKey, Object> myValues;
    protected final List<BuildFileKey> myProperties;
    protected final KeyValuePane myDetailPane;
    private Set<BuildFileKey> myModifiedKeys;

    public SingleObjectPanel(@NotNull Project project, @NotNull String moduleName, @Nullable GrClosableBlock root, @NotNull List<BuildFileKey> properties) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/structure/gradle/SingleObjectPanel", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/structure/gradle/SingleObjectPanel", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/structure/gradle/SingleObjectPanel", "<init>"));
        }
        super(project, moduleName);
        this.myValues = Maps.newHashMap();
        this.myModifiedKeys = Sets.newHashSet();
        this.myRoot = root;
        this.myProperties = properties;
        this.myDetailPane = new KeyValuePane(project, this);
        if (this.myGradleBuildFile != null) {
            for (BuildFileKey key : properties) {
                Object value = this.myGradleBuildFile.getValue((GrStatementOwner)this.myRoot, key);
                if (value == null) continue;
                this.myValues.put(key, value);
            }
        }
    }

    @Override
    protected void addItems(@NotNull JPanel parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/structure/gradle/SingleObjectPanel", "addItems"));
        }
        if (this.myGradleBuildFile == null) {
            return;
        }
        this.myDetailPane.init(this.myGradleBuildFile, this.myProperties);
        this.myDetailPane.setCurrentBuildFileObject(this.myValues);
        this.myDetailPane.updateUiFromCurrentObject();
        this.myDetailPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.myDetailPane, "North");
    }

    @Override
    public void apply() {
        if (this.myGradleBuildFile == null) {
            return;
        }
        for (BuildFileKey key : this.myProperties) {
            if (!this.myModifiedKeys.contains((Object)key)) continue;
            Object value = this.myValues.get((Object)key);
            if (value != null) {
                this.myGradleBuildFile.setValue((GrStatementOwner)this.myRoot, key, value);
                continue;
            }
            this.myGradleBuildFile.removeValue((GrStatementOwner)this.myRoot, key);
        }
        this.myModifiedKeys.clear();
    }

    @Override
    public boolean isModified() {
        return !this.myModifiedKeys.isEmpty();
    }

    @Override
    public void modified(@NotNull BuildFileKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/structure/gradle/SingleObjectPanel", "modified"));
        }
        this.myModifiedKeys.add(key);
    }
}

