/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.avdmanager.AvdEditWizard;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.sdk.LogWrapper;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.InstallComponentsPath;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidVirtualDevice
extends InstallableComponent {
    public static final Logger LOG = Logger.getInstance(AndroidVirtualDevice.class);
    private static final String ID_DEVICE_NEXUS_5 = "Nexus 5";
    private static final IdDisplay ID_ADDON_GOOGLE_API_IMG = new IdDisplay("google_apis", "Google APIs");
    private static final IdDisplay ID_VENDOR_GOOGLE = new IdDisplay("google", "Google Inc.");
    private static final Storage DEFAULT_RAM_SIZE = new Storage(1536L, Storage.Unit.MiB);
    private static final Storage DEFAULT_HEAP_SIZE = new Storage(64L, Storage.Unit.MiB);
    private static final Set<String> ENABLED_HARDWARE = ImmutableSet.of((Object)"hw.accelerometer", (Object)"hw.audioInput", (Object)"hw.battery", (Object)"hw.gps", (Object)"hw.keyboard", (Object)"hw.sensors.orientation", (Object[])new String[]{"hw.sensors.proximity", "hw.sdCard", "hw.gpu.enabled"});
    private static final Set<String> DISABLED_HARDWARE = ImmutableSet.of((Object)"hw.dPad", (Object)"hw.mainKeys", (Object)"hw.trackBall", (Object)"snapshot.present", (Object)"skin.dynamic");
    private ProgressStep myProgressStep;
    @Nullable
    private final AndroidVersion myLatestVersion;

    public AndroidVirtualDevice(@NotNull ScopedStateStore store, Multimap<PkgType, RemotePkgInfo> remotePackages) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "<init>"));
        }
        super(store, "Android Virtual Device", Storage.Unit.GiB.getNumberOfBytes(), "A preconfigured and optimized Android Virtual Device for app testing on the emulator. (Recommended)");
        RemotePkgInfo latestInfo = InstallComponentsPath.findLatestPlatform(remotePackages, false);
        this.myLatestVersion = latestInfo != null ? latestInfo.getPkgDesc().getAndroidVersion() : null;
    }

    @NotNull
    private static Device getDevice(@NotNull LocalSdk sdk) throws WizardException {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "getDevice"));
        }
        List<Device> devices = DeviceManagerConnection.getDeviceManagerConnection(sdk).getDevices();
        for (Device device : devices) {
            if (!Objects.equal((Object)device.getId(), (Object)ID_DEVICE_NEXUS_5)) continue;
            Device device2 = device;
            if (device2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "getDevice"));
            }
            return device2;
        }
        throw new WizardException(String.format("No device definition with \"%s\" ID found", ID_DEVICE_NEXUS_5));
    }

    private SystemImageDescription getSystemImageDescription(String sdkPath) throws WizardException {
        String platformHash;
        SdkManager manager = SdkManager.createManager((String)sdkPath, (ILogger)new LogWrapper(LOG));
        if (manager == null) {
            throw new IllegalStateException();
        }
        LocalSdk sdk = manager.getLocalSdk();
        IAndroidTarget target = sdk.getTargetFromHashString(platformHash = AndroidTargetHash.getAddonHashString((String)ID_VENDOR_GOOGLE.getDisplay(), (String)ID_ADDON_GOOGLE_API_IMG.getDisplay(), (AndroidVersion)this.myLatestVersion));
        if (target == null) {
            throw new WizardException("Missing platform target SDK component required for an AVD setup");
        }
        ISystemImage systemImage = target.getSystemImage(ID_ADDON_GOOGLE_API_IMG, "x86");
        if (systemImage == null) {
            throw new WizardException("Missing system image required for an AVD setup");
        }
        return new SystemImageDescription(target, systemImage);
    }

    @Nullable
    @VisibleForTesting
    AvdInfo createAvd(@NotNull AvdManagerConnection connection, @NotNull LocalSdk sdk) throws WizardException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "createAvd"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "createAvd"));
        }
        Device d = AndroidVirtualDevice.getDevice(sdk);
        File location = sdk.getLocation();
        assert (location != null);
        SystemImageDescription systemImageDescription = this.getSystemImageDescription(location.getAbsolutePath());
        String cardSize = AvdEditWizard.toIniString(AvdWizardConstants.DEFAULT_INTERNAL_STORAGE, false);
        File hardwareSkinPath = AvdEditWizard.resolveSkinPath(d.getDefaultHardware().getSkinFile(), systemImageDescription);
        String displayName = String.format("%1$s %2$s %3$s", d.getDisplayName(), systemImageDescription.getVersion(), systemImageDescription.getAbiType());
        String internalName = AvdEditWizard.cleanAvdName(connection, displayName, true);
        Map<String, String> settings = AndroidVirtualDevice.getAvdSettings(internalName, d);
        settings.put("avd.ini.displayname", displayName);
        return connection.createOrUpdateAvd(null, internalName, d, systemImageDescription, ScreenOrientation.PORTRAIT, false, cardSize, hardwareSkinPath, settings, false);
    }

    private static Map<String, String> getAvdSettings(@NotNull String internalName, @NotNull Device device) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "getAvdSettings"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "getAvdSettings"));
        }
        HashMap result = Maps.newHashMap();
        for (String key : ENABLED_HARDWARE) {
            result.put(key, "yes");
        }
        for (String key : DISABLED_HARDWARE) {
            result.put(key, "no");
        }
        for (String key : ImmutableSet.of((Object)"hw.camera.back", (Object)"hw.camera.front")) {
            result.put(key, "emulated");
        }
        result.put("hw.device.name", device.getDisplayName());
        result.put("hw.device.manufacturer", device.getManufacturer());
        result.put("runtime.network.latency", "none");
        result.put("runtime.network.speed", "full");
        result.put("runtime.scalefactor", AvdWizardConstants.DEFAULT_SCALE.getValue());
        result.put("AvdId", internalName);
        result.put("hw.lcd.density", String.valueOf(Density.XXHIGH.getDpiValue()));
        AndroidVirtualDevice.setStorageSizeKey(result, "hw.ramSize", DEFAULT_RAM_SIZE, true);
        AndroidVirtualDevice.setStorageSizeKey(result, "vm.heapSize", DEFAULT_HEAP_SIZE, true);
        AndroidVirtualDevice.setStorageSizeKey(result, "disk.dataPartition.size", AvdWizardConstants.DEFAULT_INTERNAL_STORAGE, false);
        return result;
    }

    private static void setStorageSizeKey(Map<String, String> result, String key, Storage size, boolean convertToMb) {
        result.put(key, AvdEditWizard.toIniString(size, convertToMb));
    }

    @Override
    @NotNull
    public Collection<IPkgDesc> getRequiredSdkPackages(Multimap<PkgType, RemotePkgInfo> remotePackages) {
        MajorRevision unspecifiedRevision = new MajorRevision(FullRevision.NOT_SPECIFIED);
        ArrayList result = Lists.newArrayList();
        if (this.myLatestVersion != null) {
            result.add(PkgDesc.Builder.newAddon((AndroidVersion)this.myLatestVersion, (MajorRevision)unspecifiedRevision, (IdDisplay)ID_VENDOR_GOOGLE, (IdDisplay)ID_ADDON_GOOGLE_API_IMG).create());
            result.add(PkgDesc.Builder.newAddonSysImg((AndroidVersion)this.myLatestVersion, (IdDisplay)ID_VENDOR_GOOGLE, (IdDisplay)ID_ADDON_GOOGLE_API_IMG, (String)"x86", (MajorRevision)unspecifiedRevision).create());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "getRequiredSdkPackages"));
        }
        return arrayList;
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "init"));
        }
        this.myProgressStep = progressStep;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull File sdkLocation) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "configure"));
        }
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "com/android/tools/idea/welcome/install/AndroidVirtualDevice", "configure"));
        }
        this.myProgressStep.getProgressIndicator().setIndeterminate(true);
        this.myProgressStep.getProgressIndicator().setText("Creating Android virtual device");
        installContext.print("Creating Android virtual device\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        String sdkPath = sdkLocation.getAbsolutePath();
        SdkManager manager = SdkManager.createManager((String)sdkPath, (ILogger)new LogWrapper(LOG));
        try {
            if (manager == null) {
                throw new WizardException("Android SDK was not properly setup");
            }
            LocalSdk sdk = manager.getLocalSdk();
            AvdInfo avd = this.createAvd(AvdManagerConnection.getAvdManagerConnection(sdk), sdk);
            if (avd == null) {
                throw new WizardException("Unable to create Android virtual device");
            }
            String successMessage = String.format("Android virtual device %s was successfully created\n", avd.getName());
            installContext.print(successMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        catch (WizardException e) {
            LOG.error((Throwable)e);
            String failureMessage = String.format("Unable to create a virtual device: %s\n", e.getMessage());
            installContext.print(failureMessage, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }
}

