/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.builder.model.SourceProvider;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.ActivityGalleryStep;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.IconStep;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.TemplateEntry;
import com.android.tools.idea.wizard.TemplateParameterStep2;
import com.android.tools.idea.wizard.TemplateWizard;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RecentsManager;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class AddAndroidActivityPath
extends DynamicWizardPath {
    public static final ScopedStateStore.Key<Boolean> KEY_IS_LAUNCHER = ScopedStateStore.createKey("is.launcher.activity", ScopedStateStore.Scope.PATH, Boolean.class);
    public static final ScopedStateStore.Key<TemplateEntry> KEY_SELECTED_TEMPLATE = ScopedStateStore.createKey("selected.template", ScopedStateStore.Scope.PATH, TemplateEntry.class);
    public static final ScopedStateStore.Key<AndroidVersion> KEY_MIN_SDK = ScopedStateStore.createKey("minApi", ScopedStateStore.Scope.PATH, AndroidVersion.class);
    public static final ScopedStateStore.Key<AndroidVersion> KEY_TARGET_API = ScopedStateStore.createKey("targetApi", ScopedStateStore.Scope.PATH, AndroidVersion.class);
    public static final ScopedStateStore.Key<Integer> KEY_BUILD_SDK = ScopedStateStore.createKey("buildApi", ScopedStateStore.Scope.PATH, Integer.class);
    public static final ScopedStateStore.Key<String> KEY_PACKAGE_NAME = ScopedStateStore.createKey("packageName", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<SourceProvider> KEY_SOURCE_PROVIDER = ScopedStateStore.createKey("source.provider", ScopedStateStore.Scope.PATH, SourceProvider.class);
    public static final ScopedStateStore.Key<String> KEY_SOURCE_PROVIDER_NAME = ScopedStateStore.createKey("sourceProviderName", ScopedStateStore.Scope.PATH, String.class);
    public static final Set<String> PACKAGE_NAME_PARAMETERS = ImmutableSet.of((Object)"packageName");
    public static final Set<String> CLASS_NAME_PARAMETERS = ImmutableSet.of((Object)"parentActivityClass");
    public static final ScopedStateStore.Key<Boolean> KEY_OPEN_EDITORS = ScopedStateStore.createKey("open.editors", ScopedStateStore.Scope.WIZARD, Boolean.class);
    public static final Set<ScopedStateStore.Key<String>> IMPLICIT_PARAMETERS = ImmutableSet.of(KEY_PACKAGE_NAME, KEY_SOURCE_PROVIDER_NAME);
    private static final Logger LOG = Logger.getInstance(AddAndroidActivityPath.class);
    @Nullable
    private final ActivityGalleryStep myGalleryStep;
    private TemplateParameterStep2 myParameterStep;
    private final boolean myIsNewModule;
    private IconStep myAssetStudioStep;
    private VirtualFile myTargetFolder;
    @Nullable
    private File myTemplate;
    private final Map<String, Object> myPredefinedParameterValues;
    private final Disposable myParentDisposable;

    public AddAndroidActivityPath(@Nullable VirtualFile targetFolder, @Nullable File template, Map<String, Object> predefinedParameterValues, Disposable parentDisposable) {
        this.myTemplate = template;
        this.myPredefinedParameterValues = predefinedParameterValues;
        this.myParentDisposable = parentDisposable;
        this.myIsNewModule = false;
        this.myTargetFolder = targetFolder != null && !targetFolder.isDirectory() ? targetFolder.getParent() : targetFolder;
        FormFactorUtils.FormFactor formFactor = AddAndroidActivityPath.getFormFactor(targetFolder);
        this.myGalleryStep = template == null ? new ActivityGalleryStep(formFactor, false, KEY_SELECTED_TEMPLATE, parentDisposable) : null;
    }

    private static FormFactorUtils.FormFactor getFormFactor(@Nullable VirtualFile targetFolder) {
        return FormFactorUtils.FormFactor.MOBILE;
    }

    @Nullable
    public static File findSrcDirectory(@NotNull SourceProvider sourceProvider) {
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/wizard/AddAndroidActivityPath", "findSrcDirectory"));
        }
        return (File)Iterables.getFirst((Iterable)sourceProvider.getJavaDirectories(), null);
    }

    @Nullable
    private static File findTestDirectory(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/wizard/AddAndroidActivityPath", "findTestDirectory"));
        }
        List testsRoot = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.TESTS);
        return testsRoot.size() == 0 ? null : VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(0)));
    }

    @Nullable
    public static File findResDirectory(@NotNull SourceProvider sourceProvider) {
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/wizard/AddAndroidActivityPath", "findResDirectory"));
        }
        Collection resDirectories = sourceProvider.getResDirectories();
        File resDir = null;
        if (!resDirectories.isEmpty()) {
            resDir = (File)resDirectories.iterator().next();
        }
        return resDir;
    }

    @Nullable
    public static File findAidlDir(@NotNull SourceProvider sourceProvider) {
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/wizard/AddAndroidActivityPath", "findAidlDir"));
        }
        Collection aidlDirectories = sourceProvider.getAidlDirectories();
        File resDir = null;
        if (!aidlDirectories.isEmpty()) {
            resDir = (File)aidlDirectories.iterator().next();
        }
        return resDir;
    }

    @Nullable
    public static File findManifestDirectory(@NotNull SourceProvider sourceProvider) {
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/wizard/AddAndroidActivityPath", "findManifestDirectory"));
        }
        File manifestFile = sourceProvider.getManifestFile();
        File manifestDir = manifestFile.getParentFile();
        if (manifestDir != null) {
            return manifestDir;
        }
        return null;
    }

    @Nullable
    public static String getPackageFromDirectory(@NotNull VirtualFile directory, @NotNull SourceProvider sourceProvider, @NotNull Module module, @NotNull String srcDir) {
        String packageName;
        File javaSourcePackageRoot;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/wizard/AddAndroidActivityPath", "getPackageFromDirectory"));
        }
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/wizard/AddAndroidActivityPath", "getPackageFromDirectory"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/wizard/AddAndroidActivityPath", "getPackageFromDirectory"));
        }
        if (srcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcDir", "com/android/tools/idea/wizard/AddAndroidActivityPath", "getPackageFromDirectory"));
        }
        File javaDir = AddAndroidActivityPath.findSrcDirectory(sourceProvider);
        File javaSourceRoot = javaDir == null ? new File(AndroidRootUtil.getModuleDirPath(module), srcDir) : new File(javaDir.getPath());
        if (!FileUtil.isAncestor((File)javaSourceRoot, (File)(javaSourcePackageRoot = VfsUtilCore.virtualToIoFile((VirtualFile)directory)), (boolean)true)) {
            return null;
        }
        String relativePath = FileUtil.getRelativePath((File)javaSourceRoot, (File)javaSourcePackageRoot);
        String string = packageName = relativePath != null ? FileUtil.toSystemIndependentName((String)relativePath).replace('/', '.') : null;
        if (packageName == null || !AndroidUtils.isValidJavaPackageName(packageName)) {
            return null;
        }
        return packageName;
    }

    @Nullable
    private static File getModuleRoot(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length > 0) {
            return VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
        }
        return null;
    }

    private static Map<String, Object> selectSourceProvider(@NotNull SourceProvider sourceProvider, @NotNull IdeaAndroidProject gradleProject, @NotNull Module module, @NotNull String packageName) {
        File aidlDir;
        File manifestDir;
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/wizard/AddAndroidActivityPath", "selectSourceProvider"));
        }
        if (gradleProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProject", "com/android/tools/idea/wizard/AddAndroidActivityPath", "selectSourceProvider"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/wizard/AddAndroidActivityPath", "selectSourceProvider"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/wizard/AddAndroidActivityPath", "selectSourceProvider"));
        }
        HashMap paths = Maps.newHashMap();
        File moduleDirPath = gradleProject.getRootDirPath();
        File javaDir = AddAndroidActivityPath.findSrcDirectory(sourceProvider);
        File testDir = AddAndroidActivityPath.findTestDirectory(module);
        String javaPath = AddAndroidActivityPath.getJavaPath(moduleDirPath, javaDir);
        paths.put("srcDir", javaPath);
        File resDir = AddAndroidActivityPath.findResDirectory(sourceProvider);
        if (resDir != null) {
            String resPath = FileUtil.getRelativePath((File)moduleDirPath, (File)resDir);
            if (resPath != null) {
                resPath = FileUtil.toSystemIndependentName((String)resPath);
            }
            paths.put("resDir", resPath);
            paths.put("resOut", FileUtil.toSystemIndependentName((String)resDir.getPath()));
        }
        if ((manifestDir = AddAndroidActivityPath.findManifestDirectory(sourceProvider)) != null) {
            String manifestPath = FileUtil.getRelativePath((File)moduleDirPath, (File)manifestDir);
            paths.put("manifestDir", manifestPath);
            paths.put("manifestOut", FileUtil.toSystemIndependentName((String)manifestDir.getPath()));
        }
        if ((aidlDir = AddAndroidActivityPath.findAidlDir(sourceProvider)) != null) {
            String aidlPath = FileUtil.getRelativePath((File)moduleDirPath, (File)aidlDir);
            paths.put("aidlDir", aidlPath);
            paths.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlDir.getPath()));
        }
        if (testDir == null) {
            String absolutePath = Joiner.on((char)'/').join((Object)gradleProject.getRootDir().getPath(), (Object)TemplateWizard.TEST_SOURCE_PATH, new Object[]{"java"});
            testDir = new File(FileUtil.toSystemDependentName((String)absolutePath));
        }
        assert (javaPath != null);
        paths.put("packageName", packageName);
        String relativePackageDir = packageName.replace('.', File.separatorChar);
        File srcOut = new File(javaDir, relativePackageDir);
        File testOut = new File(testDir, relativePackageDir);
        paths.put("testDir", FileUtil.toSystemIndependentName((String)testDir.getAbsolutePath()));
        paths.put("testOut", FileUtil.toSystemIndependentName((String)testOut.getAbsolutePath()));
        paths.put("applicationPackage", ManifestInfo.get(module, false).getPackage());
        paths.put("srcOut", FileUtil.toSystemIndependentName((String)srcOut.getAbsolutePath()));
        return paths;
    }

    @Nullable
    private static String getJavaPath(File ioModuleDir, @Nullable File javaDir) {
        String javaPath = null;
        if (javaDir != null && (javaPath = FileUtil.getRelativePath((File)ioModuleDir, (File)javaDir)) != null) {
            javaPath = FileUtil.toSystemIndependentName((String)javaPath);
        }
        return javaPath;
    }

    public static List<String> getParameterValueHistory(@NotNull Parameter parameter, Project project) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/wizard/AddAndroidActivityPath", "getParameterValueHistory"));
        }
        List entries = RecentsManager.getInstance((Project)project).getRecentEntries(AddAndroidActivityPath.getRecentHistoryKey(parameter.id));
        return entries == null ? ImmutableList.of() : entries;
    }

    public static String getRecentHistoryKey(@Nullable String parameter) {
        return "android.template." + parameter;
    }

    public static void saveRecentValues(@NotNull Project project, @NotNull Map<String, Object> state) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/wizard/AddAndroidActivityPath", "saveRecentValues"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/wizard/AddAndroidActivityPath", "saveRecentValues"));
        }
        for (String id : Iterables.concat(PACKAGE_NAME_PARAMETERS, CLASS_NAME_PARAMETERS)) {
            String value = (String)state.get(id);
            if (StringUtil.isEmpty((String)value)) continue;
            RecentsManager.getInstance((Project)project).registerRecentEntry(AddAndroidActivityPath.getRecentHistoryKey(id), value);
        }
    }

    @Override
    protected void init() {
        Module module = this.getModule();
        assert (module != null);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            this.myState.put(KEY_BUILD_SDK, platform.getTarget().getVersion().getFeatureLevel());
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        AndroidVersion minSdkVersion = moduleInfo.getMinSdkVersion();
        this.myState.put(KEY_MIN_SDK, minSdkVersion);
        this.myState.put(KEY_TARGET_API, moduleInfo.getTargetSdkVersion());
        this.myState.put(KEY_PACKAGE_NAME, this.getInitialPackageName(module, facet));
        this.myState.put(KEY_OPEN_EDITORS, true);
        if (this.myGalleryStep != null) {
            this.addStep(this.myGalleryStep);
        } else {
            assert (this.myTemplate != null);
            TemplateMetadata templateMetadata = TemplateManager.getInstance().getTemplate(this.myTemplate);
            assert (templateMetadata != null);
            this.myState.put(KEY_SELECTED_TEMPLATE, new TemplateEntry(this.myTemplate, templateMetadata));
        }
        SourceProvider[] sourceProviders = AddAndroidActivityPath.getSourceProviders(module, this.myTargetFolder);
        this.myParameterStep = new TemplateParameterStep2(AddAndroidActivityPath.getFormFactor(this.myTargetFolder), this.myPredefinedParameterValues, this.myParentDisposable, KEY_PACKAGE_NAME, sourceProviders);
        this.myAssetStudioStep = new IconStep(KEY_SELECTED_TEMPLATE, KEY_SOURCE_PROVIDER, null, this.myParentDisposable);
        this.addStep(this.myParameterStep);
        this.addStep(this.myAssetStudioStep);
    }

    @NotNull
    public static SourceProvider[] getSourceProviders(@Nullable Module module, @Nullable VirtualFile targetDirectory) {
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
            List<SourceProvider> providers = targetDirectory != null ? IdeaSourceProvider.getSourceProvidersForFile(facet, targetDirectory, facet.getMainSourceProvider()) : IdeaSourceProvider.getAllSourceProviders(facet);
            SourceProvider[] sourceProviderArray = (SourceProvider[])ArrayUtil.toObjectArray(providers, SourceProvider.class);
            if (sourceProviderArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AddAndroidActivityPath", "getSourceProviders"));
            }
            return sourceProviderArray;
        }
        SourceProvider[] sourceProviderArray = new SourceProvider[]{};
        if (sourceProviderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AddAndroidActivityPath", "getSourceProviders"));
        }
        return sourceProviderArray;
    }

    private String getInitialPackageName(Module module, AndroidFacet facet) {
        if (this.myTargetFolder != null) {
            String packageName;
            File srcDirectory;
            List<SourceProvider> sourceProviders = IdeaSourceProvider.getSourceProvidersForFile(facet, this.myTargetFolder, facet.getMainSourceProvider());
            File targetDirectoryFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myTargetFolder);
            if (sourceProviders.size() > 0 && IdeaSourceProvider.containsFile(sourceProviders.get(0), targetDirectoryFile) && (srcDirectory = AddAndroidActivityPath.findSrcDirectory(sourceProviders.get(0))) != null && (packageName = AddAndroidActivityPath.getPackageFromDirectory(this.myTargetFolder, sourceProviders.get(0), module, srcDirectory.toString())) != null) {
                return packageName;
            }
        }
        return this.getApplicationPackageName();
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("Add Android activity" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AddAndroidActivityPath", "getPathName"));
        }
        return "Add Android activity";
    }

    @Override
    public boolean performFinishingActions() {
        TemplateEntry templateEntry = this.myState.get(KEY_SELECTED_TEMPLATE);
        final Project project = this.getProject();
        Module module = this.getModule();
        assert (templateEntry != null);
        assert (project != null && module != null);
        final Template template = templateEntry.getTemplate();
        File moduleRoot = AddAndroidActivityPath.getModuleRoot(module);
        if (moduleRoot == null) {
            return false;
        }
        Map<String, Object> parameterMap = this.getTemplateParameterMap(templateEntry.getMetadata());
        AddAndroidActivityPath.saveRecentValues(project, parameterMap);
        template.render(VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir()), moduleRoot, parameterMap, project);
        this.myAssetStudioStep.createAssets();
        if (Boolean.TRUE.equals(this.myState.get(KEY_OPEN_EDITORS))) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    TemplateUtils.openEditors(project, template.getFilesToOpen(), true);
                }
            });
        }
        return true;
    }

    @NotNull
    private Map<String, Object> getTemplateParameterMap(@NotNull TemplateMetadata template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/android/tools/idea/wizard/AddAndroidActivityPath", "getTemplateParameterMap"));
        }
        HashMap parameterValueMap = Maps.newHashMap();
        parameterValueMap.put("isNewProject", this.myIsNewModule);
        parameterValueMap.putAll(this.getDirectories());
        for (ScopedStateStore.Key<String> key : IMPLICIT_PARAMETERS) {
            parameterValueMap.put(key.name, this.myState.get(key));
        }
        for (Parameter parameter : template.getParameters()) {
            parameterValueMap.put(parameter.id, this.myState.get(this.myParameterStep.getParameterKey(parameter)));
        }
        try {
            parameterValueMap.put("debugKeystoreSha1", KeystoreUtils.sha1(KeystoreUtils.getOrCreateDefaultDebugKeystore()));
        }
        catch (Exception e) {
            LOG.info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
        }
        File moduleRoot = AddAndroidActivityPath.getModuleRoot(this.getModule());
        if (moduleRoot != null) {
            parameterValueMap.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getAbsolutePath()));
        }
        if (Objects.equal((Object)this.getApplicationPackageName(), parameterValueMap.get("packageName"))) {
            parameterValueMap.remove("applicationPackage");
        }
        HashMap hashMap = parameterValueMap;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AddAndroidActivityPath", "getTemplateParameterMap"));
        }
        return hashMap;
    }

    private String getApplicationPackageName() {
        IdeaAndroidProject gradleProject = AndroidFacet.getInstance(this.getModule()).getIdeaAndroidProject();
        assert (gradleProject != null);
        return gradleProject.computePackageName();
    }

    private Map<String, Object> getDirectories() {
        HashMap templateParameters = Maps.newHashMap();
        Module module = this.getModule();
        assert (module != null);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            templateParameters.put("buildApi", platform.getTarget().getVersion().getFeatureLevel());
            templateParameters.put("buildApiString", TemplateMetadata.getBuildApiString(platform.getTarget().getVersion()));
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        IdeaAndroidProject gradleProject = facet.getIdeaAndroidProject();
        SourceProvider sourceProvider1 = this.myState.get(KEY_SOURCE_PROVIDER);
        if (sourceProvider1 != null && gradleProject != null) {
            String packageName = this.myState.get(KEY_PACKAGE_NAME);
            assert (packageName != null);
            templateParameters.putAll(AddAndroidActivityPath.selectSourceProvider(sourceProvider1, gradleProject, module, packageName));
        }
        AndroidVersion minSdkVersion = moduleInfo.getMinSdkVersion();
        String minSdkName = minSdkVersion.getApiString();
        templateParameters.put("minApi", minSdkName);
        templateParameters.put("targetApi", moduleInfo.getTargetSdkVersion().getApiLevel());
        templateParameters.put("minApiLevel", minSdkVersion.getFeatureLevel());
        templateParameters.put("isLibraryProject", facet.isLibraryProject());
        try {
            templateParameters.put("debugKeystoreSha1", KeystoreUtils.sha1(KeystoreUtils.getDebugKeystore(facet)));
        }
        catch (Exception e) {
            LOG.info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
            templateParameters.put("debugKeystoreSha1", "");
        }
        Project project = this.getProject();
        assert (project != null);
        templateParameters.put("projectLocation", project.getBasePath());
        String moduleName = new File(module.getModuleFilePath()).getParentFile().getName();
        templateParameters.put("projectName", moduleName);
        return templateParameters;
    }

    public String getActionDescription() {
        TemplateEntry template = this.myState.get(KEY_SELECTED_TEMPLATE);
        return String.format("Add %1$s", template == null ? "Template" : template.getTitle());
    }
}

