/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.fileTypes.AndroidRenderscriptFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.fileTypes.AndroidIdlFileType;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceFilesListener
extends BulkFileListener.Adapter
implements Disposable {
    private static final Key<String> CACHED_PACKAGE_KEY = Key.create((String)"ANDROID_RESOURCE_LISTENER_CACHED_PACKAGE");
    private final MergingUpdateQueue myQueue;
    private final Project myProject;

    public AndroidResourceFilesListener(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/facet/AndroidResourceFilesListener", "<init>"));
        }
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("AndroidResourcesCompilationQueue", 300, true, null, (Disposable)this, null, false);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/android/facet/AndroidResourceFilesListener", "after"));
        }
        Set<VirtualFile> filesToProcess = AndroidResourceFilesListener.getFilesToProcess(events);
        if (filesToProcess.size() > 0) {
            this.myQueue.queue((Update)new MyUpdate(filesToProcess));
        }
    }

    @NotNull
    private static Set<VirtualFile> getFilesToProcess(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/android/facet/AndroidResourceFilesListener", "getFilesToProcess"));
        }
        HashSet result = new HashSet();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null || !AndroidResourceFilesListener.shouldScheduleUpdate(file)) continue;
            result.add(file);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidResourceFilesListener", "getFilesToProcess"));
        }
        return hashSet;
    }

    private static boolean shouldScheduleUpdate(@NotNull VirtualFile file) {
        VirtualFile parent;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/facet/AndroidResourceFilesListener", "shouldScheduleUpdate"));
        }
        FileType fileType = file.getFileType();
        if (fileType == AndroidIdlFileType.ourFileType || fileType == AndroidRenderscriptFileType.INSTANCE || "AndroidManifest.xml".equals(file.getName())) {
            return true;
        }
        if (fileType == StdFileTypes.XML && (parent = file.getParent()) != null && parent.isDirectory()) {
            String resType = AndroidCommonUtils.getResourceTypeByDirName((String)parent.getName());
            return ResourceFolderType.VALUES.getName().equals(resType);
        }
        return false;
    }

    public void dispose() {
    }

    public static void notifyFacetInitialized(final @NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidResourceFilesListener", "notifyFacetInitialized"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Manifest manifest = facet.getManifest();
                if (manifest != null) {
                    facet.putUserData(CACHED_PACKAGE_KEY, manifest.getPackage().getValue());
                }
            }
        });
    }

    private class MyUpdate
    extends Update {
        private final Set<VirtualFile> myFiles;

        public MyUpdate(Set<VirtualFile> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/android/facet/AndroidResourceFilesListener$MyUpdate", "<init>"));
            }
            super(files);
            this.myFiles = files;
        }

        public void run() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            MultiMap map = (MultiMap)ApplicationManager.getApplication().runReadAction((Computable)new Computable<MultiMap<Module, AndroidAutogeneratorMode>>(){

                @Nullable
                public MultiMap<Module, AndroidAutogeneratorMode> compute() {
                    return MyUpdate.this.computeCompilersToRunAndInvalidateLocalAttributesMap();
                }
            });
            if (map.isEmpty()) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                Module module = (Module)entry.getKey();
                for (AndroidAutogeneratorMode mode : (Collection)entry.getValue()) {
                    AndroidCompileUtil.generate(module, mode);
                }
            }
        }

        @NotNull
        private MultiMap<Module, AndroidAutogeneratorMode> computeCompilersToRunAndInvalidateLocalAttributesMap() {
            if (AndroidResourceFilesListener.this.myProject.isDisposed()) {
                MultiMap multiMap = MultiMap.emptyInstance();
                if (multiMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidResourceFilesListener$MyUpdate", "computeCompilersToRunAndInvalidateLocalAttributesMap"));
                }
                return multiMap;
            }
            MultiMap result = MultiMap.create();
            HashSet modulesToInvalidateAttributeDefs = new HashSet();
            for (VirtualFile file : this.myFiles) {
                List<AndroidAutogeneratorMode> modes;
                AndroidFacet facet;
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)AndroidResourceFilesListener.this.myProject);
                if (module == null || module.isDisposed() || (facet = AndroidFacet.getInstance(module)) == null) continue;
                VirtualFile parent = file.getParent();
                VirtualFile gp = parent != null ? parent.getParent() : null;
                VirtualFile resourceDir = AndroidRootUtil.getResourceDir(facet);
                if (gp != null && Comparing.equal((Object)gp, (Object)resourceDir) && ResourceFolderType.VALUES.getName().equals(AndroidCommonUtils.getResourceTypeByDirName((String)parent.getName()))) {
                    modulesToInvalidateAttributeDefs.add(module);
                }
                if ((modes = this.computeCompilersToRunAndInvalidateLocalAttributesMap(facet, file)).size() <= 0) continue;
                result.putValues((Object)module, modes);
            }
            this.invalidateAttributeDefinitions((Collection<Module>)modulesToInvalidateAttributeDefs);
            MultiMap multiMap = result;
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidResourceFilesListener$MyUpdate", "computeCompilersToRunAndInvalidateLocalAttributesMap"));
            }
            return multiMap;
        }

        @NotNull
        private List<AndroidAutogeneratorMode> computeCompilersToRunAndInvalidateLocalAttributesMap(AndroidFacet facet, VirtualFile file) {
            VirtualFile sourceRoot;
            VirtualFile parent = file.getParent();
            if (parent == null) {
                List<AndroidAutogeneratorMode> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidResourceFilesListener$MyUpdate", "computeCompilersToRunAndInvalidateLocalAttributesMap"));
                }
                return list;
            }
            Module module = facet.getModule();
            VirtualFile manifestFile = AndroidRootUtil.getManifestFile(facet);
            ArrayList<AndroidAutogeneratorMode> modes = new ArrayList<AndroidAutogeneratorMode>();
            if (Comparing.equal((Object)manifestFile, (Object)file)) {
                Manifest manifest = facet.getManifest();
                String aPackage = manifest != null ? (String)manifest.getPackage().getValue() : null;
                String cachedPackage = (String)facet.getUserData(CACHED_PACKAGE_KEY);
                if (cachedPackage != null && !cachedPackage.equals(aPackage)) {
                    String aptGenDirPath = AndroidRootUtil.getAptGenSourceRootPath(facet);
                    AndroidCompileUtil.removeDuplicatingClasses(module, cachedPackage, "R", null, aptGenDirPath);
                }
                facet.putUserData(CACHED_PACKAGE_KEY, aPackage);
                modes.add(AndroidAutogeneratorMode.AAPT);
                modes.add(AndroidAutogeneratorMode.BUILDCONFIG);
            } else if (file.getFileType() == AndroidIdlFileType.ourFileType) {
                VirtualFile sourceRoot2 = AndroidUtils.findSourceRoot(module, file);
                if (sourceRoot2 != null && !Comparing.equal((Object)AndroidRootUtil.getAidlGenDir(facet), (Object)sourceRoot2)) {
                    modes.add(AndroidAutogeneratorMode.AIDL);
                }
            } else if (file.getFileType() == AndroidRenderscriptFileType.INSTANCE && (sourceRoot = AndroidUtils.findSourceRoot(module, file)) != null && !Comparing.equal((Object)AndroidRootUtil.getRenderscriptGenDir(facet), (Object)sourceRoot)) {
                modes.add(AndroidAutogeneratorMode.RENDERSCRIPT);
            }
            ArrayList<AndroidAutogeneratorMode> arrayList = modes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidResourceFilesListener$MyUpdate", "computeCompilersToRunAndInvalidateLocalAttributesMap"));
            }
            return arrayList;
        }

        private void invalidateAttributeDefinitions(@NotNull Collection<Module> modules) {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/android/facet/AndroidResourceFilesListener$MyUpdate", "invalidateAttributeDefinitions"));
            }
            for (Module module : AndroidUtils.getSetWithBackwardDependencies(modules)) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null) continue;
                facet.getLocalResourceManager().invalidateAttributeDefinitions();
            }
        }

        public boolean canEat(Update update) {
            return update instanceof MyUpdate && this.myFiles.containsAll(((MyUpdate)update).myFiles);
        }
    }
}

