/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.StatisticsUtilKt;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005A\u0011#B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0006E\u001b\u0011\u0001C\u0001&\t\u0011Y\u0001bA\u0007\u00021\t)3\u0002B\u0006\t\b5!\u0011BA\u0005\u00021\u0013AB!G\u0002\t\u000b5\t\u00014B\u0015\f\t\u0005C\u00012A\u0007\u0006!\u000b)\"\u0001$\u0001\u0019\u0005a\u0011\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lgit4idea/GitStatisticsCollector;", "Lcom/intellij/internal/statistic/AbstractApplicationUsagesCollector;", "()V", "ID", "Lcom/intellij/internal/statistic/beans/GroupDescriptor;", "kotlin.jvm.PlatformType", "getGroupId", "getProjectUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "project", "Lcom/intellij/openapi/project/Project;"}, moduleName="git4idea")
public final class GitStatisticsCollector
extends AbstractApplicationUsagesCollector {
    private final GroupDescriptor ID = GroupDescriptor.create((String)"Git");

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        List<GitRepository> repositories = repositoryManager.getRepositories();
        HashSet usages = SetsKt.hashSetOf((Object[])new UsageDescriptor[0]);
        usages.add(new UsageDescriptor("config.repo.sync." + settings.getSyncSetting().name(), 1));
        usages.add(new UsageDescriptor("config.update.type." + settings.getUpdateType().name(), 1));
        usages.add(new UsageDescriptor("config.save.policy." + settings.updateChangesPolicy().name(), 1));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.ssh", (boolean)settings.isIdeaSsh()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.push.autoupdate", (boolean)settings.autoUpdateIfPushRejected()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.push.update.all.roots", (boolean)settings.shouldUpdateAllRootsIfPushRejected()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.cherry-pick.autocommit", (boolean)settings.isAutoCommitOnCherryPick()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.warn.about.crlf", (boolean)settings.warnAboutCrlf()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.warn.about.detached", (boolean)settings.warnAboutDetachedHead()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.force.push", (boolean)settings.warnAboutDetachedHead()));
        for (GitRepository repository : repositories) {
            GitBranchesCollection branches = repository.getBranches();
            usages.add(StatisticsUtilKt.getCountingUsage((String)"data.local.branches.count", (int)branches.getLocalBranches().size(), (List)CollectionsKt.listOf((Object[])new Integer[]{0, 1, 2, 5, 8, 15, 30, 50})));
            usages.add(StatisticsUtilKt.getCountingUsage((String)"data.remote.branches.count", (int)branches.getRemoteBranches().size(), (List)CollectionsKt.listOf((Object[])new Integer[]{0, 1, 2, 5, 8, 15, 30, 100})));
            usages.add(StatisticsUtilKt.getCountingUsage((String)"data.remotes.in.project", (int)repository.getRemotes().size(), (List)CollectionsKt.listOf((Object[])new Integer[]{0, 1, 2, 5})));
        }
        return usages;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = this.ID;
        Intrinsics.checkExpressionValueIsNotNull((Object)groupDescriptor, (String)"ID");
        return groupDescriptor;
    }
}

