/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitConflictResolver;
import git4idea.rebase.GitAbortRebaseProcess;
import git4idea.rebase.GitRebaseLineListener;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import git4idea.stash.GitStashChangesSaver;
import git4idea.util.GitFreezingProcess;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitRebaseProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitPlatformFacade myFacade;
    @NotNull
    private final List<GitRepository> myAllRepositories;
    @NotNull
    private final GitRebaseParams myParams;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final Map<GitRepository, SuccessType> mySuccessfulRepositories;
    @NotNull
    private final Map<GitRepository, String> myInitialHeadPositions;
    @NotNull
    private final MultiMap<GitRepository, GitRebaseUtils.CommitInfo> mySkippedCommits;

    protected GitRebaseProcess(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull GitRebaseParams params, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        this(project, repositories, params, GitRebaseProcess.newSaver(project, indicator), (MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)MultiMap.create(), Collections.emptyMap());
    }

    private GitRebaseProcess(@NotNull Project project, @NotNull List<GitRepository> allRepositories, @NotNull GitRebaseParams params, @NotNull GitChangesSaver saver, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits, @NotNull Map<GitRepository, SuccessType> successfulRepositories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        if (allRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allRepositories", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        if (saver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saver", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        if (skippedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCommits", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        if (successfulRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulRepositories", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        this.myProject = project;
        this.myAllRepositories = allRepositories;
        this.myParams = params;
        this.mySaver = saver;
        this.mySuccessfulRepositories = successfulRepositories;
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myFacade = (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class);
        this.myInitialHeadPositions = GitRebaseProcess.readInitialHeadPositions(this.myAllRepositories);
        this.mySkippedCommits = skippedCommits;
    }

    void rebase() {
        new GitFreezingProcess(this.myProject, this.myFacade, "rebase", new Runnable(){

            @Override
            public void run() {
                GitRebaseProcess.this.doRebase();
            }
        }).execute();
    }

    void abort(@Nullable GitRepository repositoryToAbort, final @NotNull Collection<GitRepository> successfulRepositories, @NotNull ProgressIndicator indicator) {
        if (successfulRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulRepositories", "git4idea/rebase/GitRebaseProcess", "abort"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess", "abort"));
        }
        new GitAbortRebaseProcess(this.myProject, repositoryToAbort, ContainerUtil.filter(this.myInitialHeadPositions, (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return successfulRepositories.contains(repository);
            }
        }), indicator, this.mySaver).abortWithConfirmation();
    }

    void retry(final boolean continueRebase) {
        new GitFreezingProcess(this.myProject, this.myFacade, "rebase", new Runnable(){

            @Override
            public void run() {
                GitRebaseParams params = continueRebase ? GitRebaseProcess.this.myParams.withMode(GitRebaseParams.Mode.CONTINUE) : GitRebaseProcess.this.myParams;
                new GitRebaseProcess(GitRebaseProcess.this.myProject, GitRebaseProcess.this.myAllRepositories, params, GitRebaseProcess.this.mySaver, GitRebaseProcess.this.mySkippedCommits, GitRebaseProcess.this.mySuccessfulRepositories).doRebase();
            }
        }).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRebase() {
        LOG.debug("Started rebase.");
        LinkedHashMap successfulWithTypes = ContainerUtil.newLinkedHashMap(this.mySuccessfulRepositories);
        ArrayList repositories = ContainerUtil.newArrayList(this.myAllRepositories);
        repositories.removeAll(successfulWithTypes.keySet());
        ListIterator iterator = repositories.listIterator();
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            if (!this.saveDirtyRootsInitially(repositories)) {
                return;
            }
            GitRepository facedDirtyError = null;
            LinkedHashMap customModes = ContainerUtil.newLinkedHashMap();
            while (iterator.hasNext()) {
                boolean somethingRebased;
                GitRepository repository = (GitRepository)iterator.next();
                VirtualFile root = repository.getRoot();
                String repoName = DvcsUtil.getShortRepositoryName((Repository)repository);
                LOG.debug("Rebase iteration. Root: " + repoName);
                Set<GitRepository> successful = successfulWithTypes.keySet();
                GitRebaseProblemDetector rebaseDetector = new GitRebaseProblemDetector();
                GitUntrackedFilesOverwrittenByOperationDetector untrackedDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitRebaseLineListener progressListener = new GitRebaseLineListener();
                GitRebaseParams.Mode customMode = (GitRebaseParams.Mode)((Object)customModes.get(repository));
                GitRebaseParams rebaseParams = customMode != null ? this.myParams.withMode(customMode) : this.myParams;
                GitCommandResult result = this.myGit.rebase(repository, rebaseParams, rebaseDetector, untrackedDetector, progressListener);
                boolean nonStandardMode = rebaseParams.getMode() != GitRebaseParams.Mode.STANDARD;
                boolean bl = somethingRebased = nonStandardMode || progressListener.getResult().current > 1;
                if (result.success()) {
                    LOG.debug("Successfully rebased " + repoName);
                    successfulWithTypes.put(repository, SuccessType.fromOutput(result.getOutput()));
                    continue;
                }
                if (rebaseDetector.isDirtyTree() && !nonStandardMode && repository != facedDirtyError) {
                    LOG.debug("Dirty tree detected in " + repoName);
                    String saveError = this.saveLocalChanges(Collections.singleton(repository.getRoot()));
                    if (saveError != null) {
                        LOG.warn("Couldn't " + this.mySaver.getOperationName() + " root " + repository.getRoot() + ": " + saveError);
                        this.showFatalError(saveError, repository, somethingRebased, successful);
                        return;
                    }
                    iterator.previous();
                    facedDirtyError = repository;
                    continue;
                }
                if (rebaseDetector.isMergeConflict()) {
                    LOG.debug("Merge conflict in " + repoName);
                    boolean allResolved = this.showConflictResolver(repository, false);
                    if (!allResolved) {
                        this.notifyNotAllConflictsResolved(repository, successful);
                        return;
                    }
                    iterator.previous();
                    customModes.put(repository, GitRebaseParams.Mode.CONTINUE);
                    continue;
                }
                if (rebaseDetector.isNoChangeError()) {
                    LOG.info("'No changes' situation detected in " + repoName);
                    this.mySkippedCommits.putValue((Object)repository, (Object)GitRebaseUtils.getCurrentRebaseCommit(root));
                    iterator.previous();
                    customModes.put(repository, GitRebaseParams.Mode.SKIP);
                    continue;
                }
                if (untrackedDetector.wasMessageDetected()) {
                    LOG.debug("Untracked files detected in " + repoName);
                    this.showUntrackedFilesError(untrackedDetector.getRelativeFilePaths(), repository, somethingRebased, successful);
                    return;
                }
                LOG.info("Error rebasing root " + repoName + ": " + result.getErrorOutputAsJoinedString());
                this.showFatalError(result.getErrorOutputAsHtmlString(), repository, somethingRebased, successful);
                return;
            }
            LOG.debug("Rebase completed successfully.");
            this.mySaver.load();
        }
        finally {
            GitRebaseProcess.refresh(GitRebaseProcess.getRepositoriesToRefresh(successfulWithTypes, (GitRepository)iterator.previous()));
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
        this.notifySuccess(successfulWithTypes);
    }

    @VisibleForTesting
    @NotNull
    protected Collection<GitRepository> getDirtyRoots(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "getDirtyRoots"));
        }
        Collection<GitRepository> collection = this.findRootsWithLocalChanges(repositories);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "getDirtyRoots"));
        }
        return collection;
    }

    @NotNull
    private static Map<GitRepository, String> readInitialHeadPositions(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "readInitialHeadPositions"));
        }
        GitRebaseProcess.updateRepositoriesInfo(repositories);
        Map map = ContainerUtil.map2Map(repositories, (Function)new Function<GitRepository, Pair<GitRepository, String>>(){

            public Pair<GitRepository, String> fun(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseProcess$4", "fun"));
                }
                String currentRevision = repository.getCurrentRevision();
                LOG.debug("Current revision in [" + repository.getRoot().getName() + "] is [" + currentRevision + "]");
                return Pair.create((Object)repository, (Object)currentRevision);
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "readInitialHeadPositions"));
        }
        return map;
    }

    @NotNull
    private static Collection<GitRepository> getRepositoriesToRefresh(final @NotNull Map<GitRepository, SuccessType> successfulWithTypes, @NotNull GitRepository latestProcessed) {
        if (successfulWithTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulWithTypes", "git4idea/rebase/GitRebaseProcess", "getRepositoriesToRefresh"));
        }
        if (latestProcessed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "latestProcessed", "git4idea/rebase/GitRebaseProcess", "getRepositoriesToRefresh"));
        }
        HashSet toRefresh = ContainerUtil.newHashSet((Iterable)ContainerUtil.filter(successfulWithTypes.keySet(), (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return successfulWithTypes.get(repository) != SuccessType.UP_TO_DATE;
            }
        }));
        toRefresh.add(latestProcessed);
        HashSet hashSet = toRefresh;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "getRepositoriesToRefresh"));
        }
        return hashSet;
    }

    private static void refresh(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "refresh"));
        }
        GitRebaseProcess.updateRepositoriesInfo(repositories);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(GitUtil.getRootsFromRepositories(repositories)));
    }

    private static void updateRepositoriesInfo(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "updateRepositoriesInfo"));
        }
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }

    @NotNull
    private static GitStashChangesSaver newSaver(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseProcess", "newSaver"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess", "newSaver"));
        }
        Git git = (Git)ServiceManager.getService(Git.class);
        GitPlatformFacade facade = (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class);
        GitStashChangesSaver gitStashChangesSaver = new GitStashChangesSaver(project, facade, git, indicator, "Uncommitted changes before rebase");
        if (gitStashChangesSaver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "newSaver"));
        }
        return gitStashChangesSaver;
    }

    private boolean saveDirtyRootsInitially(@NotNull List<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "saveDirtyRootsInitially"));
        }
        if (this.myParams.getMode() != GitRebaseParams.Mode.STANDARD) {
            LOG.debug("No need to pre-save dirty roots in the " + (Object)((Object)this.myParams.getMode()) + " mode");
            return true;
        }
        Collection<VirtualFile> rootsToSave = GitUtil.getRootsFromRepositories(this.getDirtyRoots(repositories));
        String error = this.saveLocalChanges(rootsToSave);
        if (error != null) {
            this.myNotifier.notifyError("Rebase not Started", error);
            return false;
        }
        return true;
    }

    @Nullable
    private String saveLocalChanges(@NotNull Collection<VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToSave", "git4idea/rebase/GitRebaseProcess", "saveLocalChanges"));
        }
        try {
            this.mySaver.saveLocalChanges(rootsToSave);
            return null;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return "Couldn't " + this.mySaver.getSaverName() + " local uncommitted changes:<br/>" + e.getMessage();
        }
    }

    private Collection<GitRepository> findRootsWithLocalChanges(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "findRootsWithLocalChanges"));
        }
        return ContainerUtil.filter(repositories, (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return GitRebaseProcess.this.myChangeListManager.haveChangesUnder(repository.getRoot()) != ThreeState.NO;
            }
        });
    }

    private void notifySuccess(@NotNull Map<GitRepository, SuccessType> successful) {
        if (successful == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successful", "git4idea/rebase/GitRebaseProcess", "notifySuccess"));
        }
        String rebasedBranch = GitRebaseProcess.getCommonCurrentBranchNameIfAllTheSame(this.myAllRepositories);
        SuccessType commonType = GitRebaseProcess.getItemIfAllTheSame(successful.values(), SuccessType.REBASED);
        String message = commonType.formatMessage(rebasedBranch, this.myParams.getBase());
        message = message + this.mentionSkippedCommits();
        this.myNotifier.notifyMinorInfo("Rebase Successful", message, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/rebase/GitRebaseProcess$7", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/rebase/GitRebaseProcess$7", "hyperlinkActivated"));
                }
                GitRebaseProcess.this.handlePossibleCommitLinks(e.getDescription());
            }
        });
    }

    @Nullable
    private static String getCommonCurrentBranchNameIfAllTheSame(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "getCommonCurrentBranchNameIfAllTheSame"));
        }
        return GitRebaseProcess.getItemIfAllTheSame(ContainerUtil.map(repositories, (Function)new Function<GitRepository, String>(){

            public String fun(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseProcess$8", "fun"));
                }
                return repository.getCurrentBranchName();
            }
        }), null);
    }

    @Contract(value="_, !null -> !null")
    private static <T> T getItemIfAllTheSame(@NotNull Collection<T> collection, @Nullable T defaultItem) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "git4idea/rebase/GitRebaseProcess", "getItemIfAllTheSame"));
        }
        return (T)(ContainerUtil.newHashSet(collection).size() == 1 ? ContainerUtil.getFirstItem(collection) : defaultItem);
    }

    private void notifyNotAllConflictsResolved(@NotNull GitRepository conflictingRepository, @NotNull Collection<GitRepository> successful) {
        if (conflictingRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictingRepository", "git4idea/rebase/GitRebaseProcess", "notifyNotAllConflictsResolved"));
        }
        if (successful == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successful", "git4idea/rebase/GitRebaseProcess", "notifyNotAllConflictsResolved"));
        }
        String description = "You have to <a href='resolve'>resolve</a> the conflicts and <a href='continue'>continue</a> rebase.<br/>If you want to start from the beginning, you can <a href='abort'>abort</a> rebase.";
        description = description + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        this.myNotifier.notifyImportantWarning("Rebase Suspended", description, (NotificationListener)new RebaseNotificationListener(conflictingRepository, true, successful));
    }

    private boolean showConflictResolver(@NotNull GitRepository conflicting, boolean calledFromNotification) {
        if (conflicting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicting", "git4idea/rebase/GitRebaseProcess", "showConflictResolver"));
        }
        GitConflictResolver.Params params = new GitConflictResolver.Params().setReverse(true);
        RebaseConflictResolver conflictResolver = new RebaseConflictResolver(this.myProject, this.myGit, this.myFacade, conflicting, params, calledFromNotification);
        return conflictResolver.merge();
    }

    private void showFatalError(@NotNull String error, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "git4idea/rebase/GitRebaseProcess", "showFatalError"));
        }
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/rebase/GitRebaseProcess", "showFatalError"));
        }
        if (successful == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successful", "git4idea/rebase/GitRebaseProcess", "showFatalError"));
        }
        String description = "Rebase failed with error" + GitUtil.mention(currentRepository) + ": " + error + "<br/>" + GitRebaseProcess.mentionRetryAndAbort(somethingWasRebased, successful) + this.mentionSkippedCommits() + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        this.myNotifier.notifyError("Rebase Failed", description, (NotificationListener)new RebaseNotificationListener(currentRepository, somethingWasRebased, successful));
    }

    private void showUntrackedFilesError(@NotNull Set<String> untrackedPaths, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (untrackedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "untrackedPaths", "git4idea/rebase/GitRebaseProcess", "showUntrackedFilesError"));
        }
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/rebase/GitRebaseProcess", "showUntrackedFilesError"));
        }
        if (successful == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successful", "git4idea/rebase/GitRebaseProcess", "showUntrackedFilesError"));
        }
        String message = GitUntrackedFilesHelper.createUntrackedFilesOverwrittenDescription("rebase", true) + GitRebaseProcess.mentionRetryAndAbort(somethingWasRebased, successful) + this.mentionSkippedCommits() + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, currentRepository.getRoot(), untrackedPaths, "rebase", message);
    }

    @NotNull
    private static String mentionRetryAndAbort(boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (successful == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successful", "git4idea/rebase/GitRebaseProcess", "mentionRetryAndAbort"));
        }
        String string = somethingWasRebased || !successful.isEmpty() ? "You can <a href='retry'>retry</a> or <a href='abort'>abort</a> rebase." : "<a href='retry'>Retry.</a>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "mentionRetryAndAbort"));
        }
        return string;
    }

    @NotNull
    private String mentionSkippedCommits() {
        if (this.mySkippedCommits.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "mentionSkippedCommits"));
            }
            return "";
        }
        String message = "<br/>";
        message = this.mySkippedCommits.values().size() == 1 ? message + "The following commit was skipped during rebase:<br/>" : message + "The following commits were skipped during rebase:<br/>";
        String string = message = message + StringUtil.join((Collection)this.mySkippedCommits.values(), (Function)new Function<GitRebaseUtils.CommitInfo, String>(){

            public String fun(@NotNull GitRebaseUtils.CommitInfo commitInfo) {
                if (commitInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitInfo", "git4idea/rebase/GitRebaseProcess$9", "fun"));
                }
                String commitMessage = StringUtil.shortenPathWithEllipsis((String)commitInfo.subject, (int)72, (boolean)true);
                String hash = commitInfo.revision.asString();
                String shortHash = DvcsUtil.getShortHash((String)commitInfo.revision.asString());
                return String.format("<a href='%s'>%s</a> %s", hash, shortHash, commitMessage);
            }
        }, (String)"<br/>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "mentionSkippedCommits"));
        }
        return string;
    }

    private void handlePossibleCommitLinks(@NotNull String href) {
        if (href == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "href", "git4idea/rebase/GitRebaseProcess", "handlePossibleCommitLinks"));
        }
        GitRepository repository = this.findRootBySkippedCommit(href);
        if (repository != null) {
            GitUtil.showSubmittedFiles(this.myProject, href, repository.getRoot(), true, false);
        }
    }

    @Nullable
    private GitRepository findRootBySkippedCommit(final @NotNull String hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/rebase/GitRebaseProcess", "findRootBySkippedCommit"));
        }
        return (GitRepository)ContainerUtil.find((Iterable)this.mySkippedCommits.keySet(), (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return ContainerUtil.exists((Iterable)GitRebaseProcess.this.mySkippedCommits.get((Object)repository), (Condition)new Condition<GitRebaseUtils.CommitInfo>(){

                    public boolean value(GitRebaseUtils.CommitInfo info) {
                        return info.revision.asString().equals(hash);
                    }
                });
            }
        });
    }

    private class RebaseNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final GitRepository myCurrentRepository;
        private final boolean mySomethingWasRebased;
        @NotNull
        private final Collection<GitRepository> mySuccessful;

        RebaseNotificationListener(GitRepository currentRepository, @NotNull boolean somethingWasRebased, Collection<GitRepository> successful) {
            if (currentRepository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener", "<init>"));
            }
            if (successful == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successful", "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener", "<init>"));
            }
            this.myCurrentRepository = currentRepository;
            this.mySomethingWasRebased = somethingWasRebased;
            this.mySuccessful = successful;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener", "hyperlinkActivated"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener", "hyperlinkActivated"));
            }
            String href = e.getDescription();
            if ("abort".equals(href)) {
                new Task.Backgroundable(GitRebaseProcess.this.myProject, "Aborting Rebase..."){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener$1", "run"));
                        }
                        GitRebaseProcess.this.abort(RebaseNotificationListener.this.mySomethingWasRebased ? RebaseNotificationListener.this.myCurrentRepository : null, RebaseNotificationListener.this.mySuccessful, indicator);
                    }
                }.queue();
            } else if ("retry".equals(href) || "continue".equals(href)) {
                new Task.Backgroundable(GitRebaseProcess.this.myProject, "Rebasing..."){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener$2", "run"));
                        }
                        GitRebaseProcess.this.retry(RebaseNotificationListener.this.mySomethingWasRebased);
                    }
                }.queue();
            } else if ("resolve".equals(href)) {
                GitRebaseProcess.this.showConflictResolver(this.myCurrentRepository, true);
            } else if ("stash".equals(href)) {
                GitRebaseProcess.this.mySaver.showSavedChanges();
            } else {
                GitRebaseProcess.this.handlePossibleCommitLinks(href);
            }
        }
    }

    private class RebaseConflictResolver
    extends GitConflictResolver {
        private final boolean myCalledFromNotification;

        RebaseConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull GitPlatformFacade platformFacade, @NotNull GitRepository repository, GitConflictResolver.Params params, boolean calledFromNotification) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver", "<init>"));
            }
            if (git == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver", "<init>"));
            }
            if (platformFacade == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver", "<init>"));
            }
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver", "<init>"));
            }
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver", "<init>"));
            }
            super(project, git, platformFacade, Collections.singleton(repository.getRoot()), params);
            this.myCalledFromNotification = calledFromNotification;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }

        @Override
        protected boolean proceedAfterAllMerged() throws VcsException {
            if (this.myCalledFromNotification) {
                GitRebaseProcess.this.retry(true);
            }
            return true;
        }
    }

    private static enum SuccessType {
        REBASED{

            @Override
            @NotNull
            public String formatMessage(@Nullable String currentBranch, @NotNull String baseBranch) {
                if (baseBranch == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranch", "git4idea/rebase/GitRebaseProcess$SuccessType$1", "formatMessage"));
                }
                String string = "Rebased" + SuccessType.notNullize(currentBranch) + " on " + baseBranch;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess$SuccessType$1", "formatMessage"));
                }
                return string;
            }
        }
        ,
        UP_TO_DATE{

            @Override
            @NotNull
            public String formatMessage(@Nullable String currentBranch, @NotNull String baseBranch) {
                if (baseBranch == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranch", "git4idea/rebase/GitRebaseProcess$SuccessType$2", "formatMessage"));
                }
                String string = currentBranch != null ? currentBranch + " is up-to-date with " + baseBranch : "Up-to-date with " + baseBranch;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess$SuccessType$2", "formatMessage"));
                }
                return string;
            }
        }
        ,
        FAST_FORWARDED{

            @Override
            @NotNull
            public String formatMessage(@Nullable String currentBranch, @NotNull String baseBranch) {
                if (baseBranch == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranch", "git4idea/rebase/GitRebaseProcess$SuccessType$3", "formatMessage"));
                }
                String string = "Fast-forwarded" + SuccessType.notNullize(currentBranch) + " to " + baseBranch;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess$SuccessType$3", "formatMessage"));
                }
                return string;
            }
        };


        @NotNull
        private static String notNullize(@Nullable String currentBranch) {
            String string = currentBranch != null ? " " + currentBranch : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess$SuccessType", "notNullize"));
            }
            return string;
        }

        @NotNull
        abstract String formatMessage(@Nullable String var1, @NotNull String var2);

        @NotNull
        static SuccessType fromOutput(@NotNull List<String> output) {
            if (output == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "git4idea/rebase/GitRebaseProcess$SuccessType", "fromOutput"));
            }
            for (String line : output) {
                if (StringUtil.containsIgnoreCase((String)line, (String)"Fast-forwarded")) {
                    SuccessType successType = FAST_FORWARDED;
                    if (successType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess$SuccessType", "fromOutput"));
                    }
                    return successType;
                }
                if (!StringUtil.containsIgnoreCase((String)line, (String)"is up to date")) continue;
                SuccessType successType = UP_TO_DATE;
                if (successType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess$SuccessType", "fromOutput"));
                }
                return successType;
            }
            SuccessType successType = REBASED;
            if (successType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess$SuccessType", "fromOutput"));
            }
            return successType;
        }
    }
}

