/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.Factory;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SetStrategy
implements ModelSchemaExtractionStrategy {
    private final ModelType<?> modelType;
    protected final Factory<String> supportedTypeDescriptions;

    public SetStrategy(ModelType<?> modelType, Factory<String> supportedTypeDescriptions) {
        this.modelType = modelType;
        this.supportedTypeDescriptions = supportedTypeDescriptions;
    }

    @Override
    public <T> ModelSchemaExtractionResult<T> extract(ModelSchemaExtractionContext<T> extractionContext, final ModelSchemaCache cache) {
        ModelType<T> type = extractionContext.getType();
        if (this.modelType.isAssignableFrom(type)) {
            if (!type.getRawClass().equals(this.modelType.getConcreteClass())) {
                throw new InvalidManagedModelElementTypeException(extractionContext, String.format("subtyping %s is not supported", this.modelType.getConcreteClass().getName()));
            }
            if (type.isHasWildcardTypeVariables()) {
                throw new InvalidManagedModelElementTypeException(extractionContext, String.format("type parameter of %s cannot be a wildcard", this.modelType.getConcreteClass().getName()));
            }
            List<ModelType<?>> typeVariables = type.getTypeVariables();
            if (typeVariables.isEmpty()) {
                throw new InvalidManagedModelElementTypeException(extractionContext, String.format("type parameter of %s has to be specified", this.modelType.getConcreteClass().getName()));
            }
            ModelType<?> elementType = typeVariables.get(0);
            if (this.modelType.isAssignableFrom(elementType)) {
                throw new InvalidManagedModelElementTypeException(extractionContext, String.format("%1$s cannot be used as type parameter of %1$s", this.modelType.getConcreteClass().getName()));
            }
            ModelCollectionSchema<T> schema = ModelSchema.collection(extractionContext.getType(), elementType);
            ModelSchemaExtractionContext<?> typeParamExtractionContext = extractionContext.child(elementType, "element type", new Action<ModelSchemaExtractionContext<?>>(){

                public void execute(ModelSchemaExtractionContext<?> context) {
                    ModelSchema<?> typeParamSchema = cache.get(context.getType());
                    if (!typeParamSchema.getKind().isManaged()) {
                        throw new InvalidManagedModelElementTypeException(context.getParent(), String.format("cannot create a managed set of type %s as it is an unmanaged type.%nSupported types:%n%s", context.getType(), SetStrategy.this.supportedTypeDescriptions.create()));
                    }
                }
            });
            return new ModelSchemaExtractionResult<T>(schema, (Iterable<ModelSchemaExtractionContext<?>>)ImmutableList.of(typeParamExtractionContext));
        }
        return null;
    }

    @Override
    public Iterable<String> getSupportedManagedTypes() {
        return Collections.singleton(this.modelType + " of a managed type");
    }
}

