/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;

public class RepositoryLibraryProperties
extends LibraryProperties<RepositoryLibraryProperties> {
    private String mavenId;
    private String groupId;
    private String artifactId;
    private String version;

    public RepositoryLibraryProperties() {
    }

    public RepositoryLibraryProperties(String mavenId) {
        this.setMavenId(mavenId);
    }

    public RepositoryLibraryProperties(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.mavenId = groupId + ":" + artifactId + ":" + version;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RepositoryLibraryProperties)) {
            return false;
        }
        RepositoryLibraryProperties other = (RepositoryLibraryProperties)((Object)obj);
        return Comparing.equal((String)this.mavenId, (String)other.mavenId);
    }

    public int hashCode() {
        return Comparing.hashcode((Object)this.getMavenId());
    }

    public RepositoryLibraryProperties getState() {
        return this;
    }

    public void loadState(RepositoryLibraryProperties state) {
        this.setMavenId(state.mavenId);
    }

    @Attribute(value="maven-id")
    public String getMavenId() {
        return this.mavenId;
    }

    public void setMavenId(String mavenId) {
        this.mavenId = mavenId;
        if (mavenId == null) {
            this.version = null;
            this.artifactId = null;
            this.groupId = null;
        } else {
            String[] parts = mavenId.split(":");
            this.groupId = parts.length > 0 ? parts[0] : null;
            this.artifactId = parts.length > 1 ? parts[1] : null;
            this.version = parts.length > 2 ? parts[2] : null;
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void changeVersion(String version) {
        this.version = version;
        this.mavenId = this.groupId + ":" + this.artifactId + ":" + version;
    }
}

