/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;

public class ArchetypeConfiguration
implements Serializable {
    private String GroupId;
    private String ArtifactId;
    private String Version;
    private String Name;
    private String goals;
    private List RequiredProperties;
    private Properties properties = new Properties();
    private Properties defaultProperties = new Properties();
    private String modelEncoding = "UTF-8";

    public void addRequiredProperty(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("ArchetypeConfiguration.addRequiredProperties(string) parameter must be instanceof " + String.class.getName());
        }
        this.getRequiredProperties().add(string);
    }

    public String getArtifactId() {
        return this.ArtifactId;
    }

    public String getGoals() {
        return this.goals;
    }

    public String getGroupId() {
        return this.GroupId;
    }

    public String getName() {
        return this.Name;
    }

    public List getRequiredProperties() {
        if (this.RequiredProperties == null) {
            this.RequiredProperties = new ArrayList();
        }
        return this.RequiredProperties;
    }

    public String getVersion() {
        return this.Version;
    }

    public void removeRequiredProperty(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("ArchetypeConfiguration.removeRequiredProperties(string) parameter must be instanceof " + String.class.getName());
        }
        this.getRequiredProperties().remove(string);
    }

    public void setArtifactId(String ArtifactId) {
        this.ArtifactId = ArtifactId;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    public void setGroupId(String GroupId) {
        this.GroupId = GroupId;
    }

    public void setName(String Name) {
        this.Name = Name;
    }

    public void setRequiredProperties(List RequiredProperties) {
        this.RequiredProperties = RequiredProperties;
    }

    public void setVersion(String Version) {
        this.Version = Version;
    }

    public void reset() {
        this.properties.clear();
    }

    public void setProperty(String requiredProperty, String propertyValue) {
        this.properties.setProperty(requiredProperty, propertyValue);
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property, null);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Properties toProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.properties);
        result.setProperty("archetype.groupId", StringUtils.isNotEmpty((String)this.getGroupId()) ? this.getGroupId() : "");
        result.setProperty("archetype.artifactId", StringUtils.isNotEmpty((String)this.getArtifactId()) ? this.getArtifactId() : "");
        result.setProperty("archetype.version", StringUtils.isNotEmpty((String)this.getVersion()) ? this.getVersion() : "");
        this.properties.setProperty("archetype.goals", StringUtils.isNotEmpty((String)this.getGoals()) ? this.getGoals() : "");
        return result;
    }

    public boolean isConfigured() {
        boolean configured = true;
        Iterator requiredProperties = this.getRequiredProperties().iterator();
        while (configured && requiredProperties.hasNext()) {
            String requiredProperty = (String)requiredProperties.next();
            configured = configured && StringUtils.isNotEmpty((String)this.properties.getProperty(requiredProperty));
        }
        return configured;
    }

    public boolean isConfigured(String requiredProperties) {
        return StringUtils.isNotEmpty((String)this.properties.getProperty(requiredProperties));
    }

    public void setDefaultProperty(String requiredProperty, String propertyValue) {
        this.defaultProperties.setProperty(requiredProperty, propertyValue);
    }

    public String getDefaultValue(String requiredProperty) {
        return this.defaultProperties.getProperty(requiredProperty, null);
    }

    public Properties getDefaultValues() {
        return this.defaultProperties;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

