/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console.actions;

import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.console.GroovyConsole;
import org.jetbrains.plugins.groovy.console.GroovyConsoleRootType;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtil;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

public class GrNewConsoleAction
extends AnAction {
    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(this.getModule(e) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        Module module = this.getModule(e);
        if (project == null || module == null) {
            return;
        }
        VirtualFile contentFile = ConsoleHistoryController.getContentFile((ConsoleRootType)GroovyConsoleRootType.getInstance(), (String)"groovy_console", (ScratchFileService.Option)ScratchFileService.Option.create_new_always);
        assert (contentFile != null);
        GroovyConsole.createConsole(project, contentFile, module);
        FileEditorManager.getInstance((Project)project).openFile(contentFile, true);
    }

    @Nullable
    protected Module getModule(AnActionEvent e) {
        Module moduleForFile;
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (file != null && (moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null) {
            return moduleForFile;
        }
        List<Module> modules = ModuleChooserUtil.getGroovyCompatibleModules(project, GroovyConsoleUtil.APPLICABLE_MODULE);
        return modules.isEmpty() ? null : modules.get(0);
    }
}

