/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrForBodyFixer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GrMissingIfStatement
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        PsiElement rParenth;
        GrStatement thenBranch;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrMissingIfStatement", "apply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrMissingIfStatement", "apply"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrMissingIfStatement", "apply"));
        }
        if (!(psiElement instanceof GrIfStatement)) {
            return;
        }
        GrIfStatement ifStatement = (GrIfStatement)psiElement;
        Document document = editor.getDocument();
        GrStatement elseBranch = ifStatement.getElseBranch();
        PsiElement elseElement = ifStatement.getElseKeyword();
        if (elseElement != null && (elseBranch == null || !(elseBranch instanceof GrBlockStatement) && GrForBodyFixer.startLine(editor.getDocument(), elseBranch) > GrForBodyFixer.startLine(editor.getDocument(), elseElement))) {
            document.insertString(elseElement.getTextRange().getEndOffset(), (CharSequence)"{}");
        }
        if ((thenBranch = ifStatement.getThenBranch()) instanceof GrBlockStatement) {
            return;
        }
        boolean transformingOneLiner = false;
        if (thenBranch != null && GrForBodyFixer.startLine(editor.getDocument(), thenBranch) == GrForBodyFixer.startLine(editor.getDocument(), ifStatement)) {
            if (ifStatement.getCondition() != null) {
                return;
            }
            transformingOneLiner = true;
        }
        if ((rParenth = ifStatement.getRParenth()) == null) {
            return;
        }
        if (elseBranch == null && !transformingOneLiner || thenBranch == null) {
            document.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{}");
        } else {
            document.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{");
            document.insertString(thenBranch.getTextRange().getEndOffset() + 1, (CharSequence)"}");
        }
    }
}

