/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import java.util.Collections;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;

public class CallInstruction
extends InstructionImpl {
    private final InstructionImpl myCallee;

    public CallInstruction(InstructionImpl callee) {
        super(null);
        this.myCallee = callee;
    }

    @Override
    public String toString() {
        return super.toString() + " CALL " + this.myCallee.num();
    }

    @Override
    public Iterable<? extends Instruction> successors(CallEnvironment environment) {
        environment.callStack(this.myCallee).push(this);
        return Collections.singletonList(this.myCallee);
    }

    @Override
    public Iterable<? extends Instruction> allSuccessors() {
        return Collections.singletonList(this.myCallee);
    }

    @Override
    protected String getElementPresentation() {
        return "";
    }
}

