/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class StringPartInfo {
    private final GrLiteral myLiteral;
    private final TextRange myRange;
    private final List<GrStringInjection> myInjections;
    private final String myText;
    private final String myStartQuote;
    private final String myEndQuote;

    @Nullable
    public static StringPartInfo findStringPart(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "findStringPart"));
        }
        PsiElement start = file.findElementAt(startOffset);
        PsiElement fin = file.findElementAt(endOffset - 1);
        if (start == null || fin == null) {
            return null;
        }
        PsiElement psi = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)fin);
        if (psi == null) {
            return null;
        }
        GrLiteral literal = StringPartInfo.findLiteral(psi);
        if (literal != null && StringPartInfo.checkSelectedRange(startOffset, endOffset, literal)) {
            return new StringPartInfo(literal, new TextRange(startOffset, endOffset));
        }
        return null;
    }

    public StringPartInfo(@NotNull GrLiteral literal, final @NotNull TextRange range) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "<init>"));
        }
        this.myLiteral = literal;
        if (literal instanceof GrString) {
            Object[] injections = ((GrString)literal).getInjections();
            this.myInjections = ContainerUtil.filter((Object[])injections, (Condition)new Condition<GrStringInjection>(){

                public boolean value(GrStringInjection injection) {
                    return range.contains(injection.getTextRange());
                }
            });
        } else {
            this.myInjections = Collections.emptyList();
        }
        this.myText = this.myLiteral.getText();
        this.myStartQuote = GrStringUtil.getStartQuote(this.myText);
        this.myEndQuote = GrStringUtil.getEndQuote(this.myText);
        TextRange dataRange = new TextRange(this.myStartQuote.length(), this.myText.length() - this.myEndQuote.length());
        this.myRange = range.shiftRight(-literal.getTextRange().getStartOffset()).intersection(dataRange);
    }

    private static boolean checkSelectedRange(int startOffset, int endOffset, GrLiteral literal) {
        if (StringPartInfo.isWholeLiteralContentSelected(literal, startOffset, endOffset)) {
            return false;
        }
        if (literal instanceof GrString && StringPartInfo.areInjectionsCut((GrString)literal, startOffset, endOffset)) {
            return false;
        }
        return !StringPartInfo.isEscapesCut(literal, startOffset, endOffset);
    }

    private static boolean isEscapesCut(GrLiteral literal, int startOffset, int endOffset) {
        String rawContent = GrStringUtil.removeQuotes(literal.getText());
        int[] offsets = new int[rawContent.length() + 1];
        if (GrStringUtil.isSingleQuoteString(literal) || GrStringUtil.isDoubleQuoteString(literal)) {
            GrStringUtil.parseStringCharacters(rawContent, new StringBuilder(), offsets);
        } else if (GrStringUtil.isSlashyString(literal)) {
            GrStringUtil.parseRegexCharacters(rawContent, new StringBuilder(), offsets, true);
        } else if (GrStringUtil.isDollarSlashyString(literal)) {
            GrStringUtil.parseRegexCharacters(rawContent, new StringBuilder(), offsets, false);
        }
        int contentStart = literal.getTextRange().getStartOffset() + GrStringUtil.getStartQuote(literal.getText()).length();
        int relativeStart = startOffset - contentStart;
        int relativeEnd = endOffset - contentStart;
        return ArrayUtil.find((int[])offsets, (int)relativeStart) < 0 || ArrayUtil.find((int[])offsets, (int)relativeEnd) < 0;
    }

    public static boolean isWholeLiteralContentSelected(GrLiteral literal, int startOffset, int endOffset) {
        TextRange literalRange = literal.getTextRange();
        String literalText = literal.getText();
        String startQuote = GrStringUtil.getStartQuote(literalText);
        String endQuote = GrStringUtil.getEndQuote(literalText);
        return literalRange.getStartOffset() <= startOffset && startOffset <= literalRange.getStartOffset() + startQuote.length() && literalRange.getEndOffset() - endQuote.length() <= endOffset && endOffset <= literalRange.getEndOffset();
    }

    private static boolean areInjectionsCut(GrString literal, int startOffset, int endOffset) {
        GrStringInjection[] injections;
        TextRange selectionRange = new TextRange(startOffset, endOffset);
        for (GrStringInjection injection : injections = literal.getInjections()) {
            TextRange range = injection.getTextRange();
            if (selectionRange.contains(range) || range.contains(selectionRange) || !range.intersects(selectionRange)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static GrLiteral findLiteral(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "findLiteral"));
        }
        if (StringPartInfo.isStringLiteral(psi.getParent())) {
            return (GrLiteral)psi.getParent();
        }
        if (StringPartInfo.isStringLiteral(psi.getParent().getParent())) {
            return (GrLiteral)psi.getParent().getParent();
        }
        if (psi instanceof GrString) {
            return (GrLiteral)psi;
        }
        return null;
    }

    private static boolean isStringLiteral(PsiElement psi) {
        return psi instanceof GrLiteral && TokenSets.STRING_LITERAL_SET.contains(GrLiteralImpl.getLiteralType((GrLiteral)psi)) || psi instanceof GrString;
    }

    @NotNull
    public GrExpression replaceLiteralWithConcatenation(@Nullable String varName) {
        StringBuilder buffer;
        block14: {
            GrExpression replaced;
            boolean suffixExists;
            boolean prefixExists;
            block13: {
                block12: {
                    block11: {
                        GrExpression grExpression;
                        String prefix = this.preparePrefix();
                        String suffix = this.prepareSuffix();
                        buffer = new StringBuilder();
                        boolean bl = prefixExists = !GrStringUtil.removeQuotes(prefix).isEmpty();
                        if (prefixExists) {
                            buffer.append(prefix).append('+');
                        }
                        buffer.append(varName != null ? varName : this.prepareSelected());
                        boolean bl2 = suffixExists = !GrStringUtil.removeQuotes(suffix).isEmpty();
                        if (suffixExists) {
                            buffer.append('+').append(suffix);
                        }
                        GrExpression concatenation = GroovyPsiElementFactory.getInstance(this.myLiteral.getProject()).createExpressionFromText(buffer);
                        replaced = this.getLiteral().replaceWithExpression(concatenation, false);
                        try {
                            if (!prefixExists || !suffixExists) break block11;
                            grExpression = ((GrBinaryExpression)((GrBinaryExpression)replaced).getLeftOperand()).getRightOperand();
                        }
                        catch (ClassCastException c) {
                            throw new IncorrectOperationException(buffer.toString());
                        }
                        if (grExpression == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "replaceLiteralWithConcatenation"));
                        }
                        return grExpression;
                    }
                    if (prefixExists || !suffixExists) break block12;
                    GrExpression grExpression = ((GrBinaryExpression)replaced).getLeftOperand();
                    if (grExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "replaceLiteralWithConcatenation"));
                    }
                    return grExpression;
                }
                if (!prefixExists || suffixExists) break block13;
                GrExpression grExpression = ((GrBinaryExpression)replaced).getRightOperand();
                if (grExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "replaceLiteralWithConcatenation"));
                }
                return grExpression;
            }
            if (prefixExists || suffixExists) break block14;
            GrExpression grExpression = replaced;
            if (grExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "replaceLiteralWithConcatenation"));
            }
            return grExpression;
        }
        throw new IncorrectOperationException(buffer.toString());
    }

    private String prepareSelected() {
        String content = this.myRange.substring(this.myLiteral.getText());
        return this.prepareLiteral(content);
    }

    private String prepareSuffix() {
        return this.myStartQuote + this.myText.substring(this.myRange.getEndOffset());
    }

    private String preparePrefix() {
        String prefix = this.myText.substring(0, this.myRange.getStartOffset());
        String content = GrStringUtil.removeQuotes(prefix);
        return this.prepareLiteral(content);
    }

    private String prepareLiteral(String content) {
        if (GrStringUtil.isSlashyString(this.myLiteral)) {
            if (content.endsWith("\\")) {
                String unescaped = GrStringUtil.unescapeSlashyString(content);
                return StringPartInfo.prepareGString(unescaped);
            }
        } else if (GrStringUtil.isDollarSlashyString(this.myLiteral) && content.endsWith("$")) {
            String unescaped = GrStringUtil.unescapeDollarSlashyString(content);
            return StringPartInfo.prepareGString(unescaped);
        }
        return this.myStartQuote + content + this.myEndQuote;
    }

    @NotNull
    private static String prepareGString(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "prepareGString"));
        }
        StringBuilder buffer = new StringBuilder();
        boolean multiline = content.contains("\n");
        buffer.append(multiline ? "\"\"\"" : "\"");
        GrStringUtil.escapeSymbolsForGString(content, multiline, false, buffer);
        buffer.append(multiline ? "\"\"\"" : "\"");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "prepareGString"));
        }
        return string;
    }

    @NotNull
    public GrLiteral getLiteral() {
        GrLiteral grLiteral = this.myLiteral;
        if (grLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "getLiteral"));
        }
        return grLiteral;
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "getRange"));
        }
        return textRange;
    }

    @NotNull
    public List<GrStringInjection> getInjections() {
        List<GrStringInjection> list = this.myInjections;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "getInjections"));
        }
        return list;
    }

    @NotNull
    public GrLiteral createLiteralFromSelected() {
        GrLiteral grLiteral = (GrLiteral)GroovyPsiElementFactory.getInstance(this.myLiteral.getProject()).createExpressionFromText(this.prepareSelected());
        if (grLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo", "createLiteralFromSelected"));
        }
        return grLiteral;
    }
}

