@file:kotlin.jvm.JvmMultifileClass
@file:kotlin.jvm.JvmName("SetsKt")

package kotlin

//
// NOTE THIS FILE IS AUTO-GENERATED by the GenerateStandardLib.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import java.util.*

import java.util.Collections // TODO: it's temporary while we have java.util.Collections in js

/**
 * Returns a set containing all elements of the original set except the elements contained in the given [array].
 */
public operator fun <T> Set<T>.minus(array: Array<out T>): Set<T> {
    val result = LinkedHashSet<T>(this)
    result.removeAll(array)
    return result
}

/**
 * Returns a set containing all elements of the original set except the elements contained in the given [collection].
 */
public operator fun <T> Set<T>.minus(collection: Iterable<T>): Set<T> {
    val other = collection.convertToSetForSetOperationWith(this)
    if (other.isEmpty())
        return this.toSet()
    if (other is Set)
        return this.filterNotTo(LinkedHashSet<T>()) { it in other }
    val result = LinkedHashSet<T>(this)
    result.removeAll(other)
    return result
}

/**
 * Returns a set containing all elements of the original set except the given [element].
 */
public operator fun <T> Set<T>.minus(element: T): Set<T> {
    val result = LinkedHashSet<T>(mapCapacity(size()))
    var removed = false
    return this.filterTo(result) { if (!removed && it == element) { removed = true; false } else true }
}

/**
 * Returns a set containing all elements of the original set except the elements contained in the given [sequence].
 */
public operator fun <T> Set<T>.minus(sequence: Sequence<T>): Set<T> {
    val result = LinkedHashSet<T>(this)
    result.removeAll(sequence)
    return result
}

/**
 * Returns a set containing all elements both of the original set and the given [array].
 */
public operator fun <T> Set<T>.plus(array: Array<out T>): Set<T> {
    val result = LinkedHashSet<T>(mapCapacity(this.size() + array.size()))
    result.addAll(this)
    result.addAll(array)
    return result
}

/**
 * Returns a set containing all elements both of the original set and the given [collection].
 */
public operator fun <T> Set<T>.plus(collection: Iterable<T>): Set<T> {
    val result = LinkedHashSet<T>(mapCapacity(collection.collectionSizeOrNull()?.let { this.size() + it } ?: this.size() * 2))
    result.addAll(this)
    result.addAll(collection)
    return result
}

/**
 * Returns a set containing all elements of the original set and then the given [element].
 */
public operator fun <T> Set<T>.plus(element: T): Set<T> {
    val result = LinkedHashSet<T>(mapCapacity(size() + 1))
    result.addAll(this)
    result.add(element)
    return result
}

/**
 * Returns a set containing all elements both of the original set and the given [sequence].
 */
public operator fun <T> Set<T>.plus(sequence: Sequence<T>): Set<T> {
    val result = LinkedHashSet<T>(mapCapacity(this.size() * 2))
    result.addAll(this)
    result.addAll(sequence)
    return result
}

