/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class MorphologyOp
implements BufferedImageOp,
RasterOp {
    private int radiusX;
    private int radiusY;
    private boolean doDilation;
    private final int rangeX;
    private final int rangeY;
    private final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private final ColorSpace lRGB = ColorSpace.getInstance(1004);

    public MorphologyOp(int n, int n2, boolean bl) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("The radius of X-axis or Y-axis should not be Zero or Negatives.");
        }
        this.radiusX = n;
        this.radiusY = n2;
        this.doDilation = bl;
        this.rangeX = 2 * n + 1;
        this.rangeY = 2 * n2 + 1;
    }

    @Override
    public Rectangle2D getBounds2D(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    @Override
    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    private void checkCompatible(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (!colorSpace.equals(this.sRGB) && !colorSpace.equals(this.lRGB)) {
            throw new IllegalArgumentException("Expected CS_sRGB or CS_LINEAR_RGB color model");
        }
        if (!(colorModel instanceof DirectColorModel)) {
            throw new IllegalArgumentException("colorModel should be an instance of DirectColorModel");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("colorModel's transferType should be DataBuffer.TYPE_INT");
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000) {
            throw new IllegalArgumentException("red mask in source should be 0x00ff0000");
        }
        if (directColorModel.getGreenMask() != 65280) {
            throw new IllegalArgumentException("green mask in source should be 0x0000ff00");
        }
        if (directColorModel.getBlueMask() != 255) {
            throw new IllegalArgumentException("blue mask in source should be 0x000000ff");
        }
        if (directColorModel.getAlphaMask() != -16777216) {
            throw new IllegalArgumentException("alpha mask in source should be 0xff000000");
        }
    }

    private boolean isCompatible(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace != ColorSpace.getInstance(1000) && colorSpace != ColorSpace.getInstance(1004)) {
            return false;
        }
        if (!(colorModel instanceof DirectColorModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000) {
            return false;
        }
        if (directColorModel.getGreenMask() != 65280) {
            return false;
        }
        if (directColorModel.getBlueMask() != 255) {
            return false;
        }
        return directColorModel.getAlphaMask() == -16777216;
    }

    private void checkCompatible(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalArgumentException("MorphologyOp only works with Rasters using SinglePixelPackedSampleModels");
        }
        int n = sampleModel.getNumBands();
        if (n != 4) {
            throw new IllegalArgumentException("MorphologyOp only words with Rasters having 4 bands");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("MorphologyOp only works with Rasters using DataBufferInt");
        }
        int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] % 8 == 0) continue;
            throw new IllegalArgumentException("MorphologyOp only works with Rasters using 8 bits per band : " + i + " : " + nArray[i]);
        }
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return raster.createCompatibleWritableRaster();
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        BufferedImage bufferedImage2 = null;
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.checkCompatible(colorModel, writableRaster.getSampleModel());
        bufferedImage2 = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        return bufferedImage2;
    }

    static final boolean isBetter(int n, int n2, boolean bl) {
        if (n > n2) {
            return bl;
        }
        if (n < n2) {
            return !bl;
        }
        return true;
    }

    private void specialProcessRow(Raster raster, WritableRaster writableRaster) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n4 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n5 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n6 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        if (n <= this.radiusX) {
            for (int i = 0; i < n2; ++i) {
                int n7;
                int n8 = n3 + i * n5;
                int n9 = n4 + i * n6;
                int n10 = nArray[n8++];
                int n11 = n10 >>> 24;
                int n12 = n10 & 0xFF0000;
                int n13 = n10 & 0xFF00;
                int n14 = n10 & 0xFF;
                for (n7 = 1; n7 < n; ++n7) {
                    int n15 = nArray[n8++];
                    int n16 = n15 >>> 24;
                    int n17 = n15 & 0xFF0000;
                    int n18 = n15 & 0xFF00;
                    int n19 = n15 & 0xFF;
                    if (MorphologyOp.isBetter(n16, n11, this.doDilation)) {
                        n11 = n16;
                    }
                    if (MorphologyOp.isBetter(n17, n12, this.doDilation)) {
                        n12 = n17;
                    }
                    if (MorphologyOp.isBetter(n18, n13, this.doDilation)) {
                        n13 = n18;
                    }
                    if (!MorphologyOp.isBetter(n19, n14, this.doDilation)) continue;
                    n14 = n19;
                }
                for (n7 = 0; n7 < n; ++n7) {
                    nArray2[n9++] = n11 << 24 | n12 | n13 | n14;
                }
            }
        } else {
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            int[] nArray5 = new int[n];
            int[] nArray6 = new int[n];
            for (int i = 0; i < n2; ++i) {
                int n20;
                int n21;
                int n22;
                int n23;
                int n24;
                int n25 = n3 + i * n5;
                int n26 = n4 + i * n6;
                int n27 = 0;
                int n28 = 0;
                int n29 = 0;
                int n30 = 0;
                int n31 = 0;
                int n32 = nArray[n25++];
                int n33 = n32 >>> 24;
                int n34 = n32 & 0xFF0000;
                int n35 = n32 & 0xFF00;
                int n36 = n32 & 0xFF;
                nArray3[0] = n33;
                nArray4[0] = n34;
                nArray5[0] = n35;
                nArray6[0] = n36;
                for (n24 = 1; n24 <= this.radiusX; ++n24) {
                    int n37 = nArray[n25++];
                    n23 = n37 >>> 24;
                    n22 = n37 & 0xFF0000;
                    n21 = n37 & 0xFF00;
                    n20 = n37 & 0xFF;
                    nArray3[n24] = n23;
                    nArray4[n24] = n22;
                    nArray5[n24] = n21;
                    nArray6[n24] = n20;
                    if (MorphologyOp.isBetter(n23, n33, this.doDilation)) {
                        n33 = n23;
                        n28 = n24;
                    }
                    if (MorphologyOp.isBetter(n22, n34, this.doDilation)) {
                        n34 = n22;
                        n29 = n24;
                    }
                    if (MorphologyOp.isBetter(n21, n35, this.doDilation)) {
                        n35 = n21;
                        n30 = n24;
                    }
                    if (!MorphologyOp.isBetter(n20, n36, this.doDilation)) continue;
                    n36 = n20;
                    n31 = n24;
                }
                nArray2[n26++] = n33 << 24 | n34 | n35 | n36;
                for (n24 = 1; n24 <= n - this.radiusX - 1; ++n24) {
                    int n38 = nArray[n25++];
                    n33 = nArray3[n28];
                    nArray3[n24 + this.radiusX] = n23 = n38 >>> 24;
                    if (MorphologyOp.isBetter(n23, n33, this.doDilation)) {
                        n33 = n23;
                        n28 = n24 + this.radiusX;
                    }
                    n34 = nArray4[n29];
                    nArray4[n24 + this.radiusX] = n22 = n38 & 0xFF0000;
                    if (MorphologyOp.isBetter(n22, n34, this.doDilation)) {
                        n34 = n22;
                        n29 = n24 + this.radiusX;
                    }
                    n35 = nArray5[n30];
                    nArray5[n24 + this.radiusX] = n21 = n38 & 0xFF00;
                    if (MorphologyOp.isBetter(n21, n35, this.doDilation)) {
                        n35 = n21;
                        n30 = n24 + this.radiusX;
                    }
                    n36 = nArray6[n31];
                    nArray6[n24 + this.radiusX] = n20 = n38 & 0xFF;
                    if (MorphologyOp.isBetter(n20, n36, this.doDilation)) {
                        n36 = n20;
                        n31 = n24 + this.radiusX;
                    }
                    nArray2[n26++] = n33 << 24 | n34 | n35 | n36;
                }
                for (n24 = n - this.radiusX; n24 <= this.radiusX; ++n24) {
                    nArray2[n26] = nArray2[n26 - 1];
                    ++n26;
                }
                for (n24 = this.radiusX + 1; n24 < n; ++n24) {
                    int n39;
                    if (n28 == n27) {
                        n33 = nArray3[n27 + 1];
                        n28 = n27 + 1;
                        for (n39 = n27 + 2; n39 < n; ++n39) {
                            n23 = nArray3[n39];
                            if (!MorphologyOp.isBetter(n23, n33, this.doDilation)) continue;
                            n33 = n23;
                            n28 = n39;
                        }
                    } else {
                        n33 = nArray3[n28];
                    }
                    if (n29 == n27) {
                        n34 = nArray4[n27 + 1];
                        n29 = n27 + 1;
                        for (n39 = n27 + 2; n39 < n; ++n39) {
                            n22 = nArray4[n39];
                            if (!MorphologyOp.isBetter(n22, n34, this.doDilation)) continue;
                            n34 = n22;
                            n29 = n39;
                        }
                    } else {
                        n34 = nArray4[n29];
                    }
                    if (n30 == n27) {
                        n35 = nArray5[n27 + 1];
                        n30 = n27 + 1;
                        for (n39 = n27 + 2; n39 < n; ++n39) {
                            n21 = nArray5[n39];
                            if (!MorphologyOp.isBetter(n21, n35, this.doDilation)) continue;
                            n35 = n21;
                            n30 = n39;
                        }
                    } else {
                        n35 = nArray5[n30];
                    }
                    if (n31 == n27) {
                        n36 = nArray6[n27 + 1];
                        n31 = n27 + 1;
                        for (n39 = n27 + 2; n39 < n; ++n39) {
                            n20 = nArray6[n39];
                            if (!MorphologyOp.isBetter(n20, n36, this.doDilation)) continue;
                            n36 = n20;
                            n31 = n39;
                        }
                    } else {
                        n36 = nArray6[n31];
                    }
                    ++n27;
                    nArray2[n26++] = n33 << 24 | n34 | n35 | n36;
                }
            }
        }
    }

    private void specialProcessColumn(Raster raster, WritableRaster writableRaster) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset();
        int n4 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int[] nArray = dataBufferInt.getBankData()[0];
        if (n2 <= this.radiusY) {
            for (int i = 0; i < n; ++i) {
                int n5;
                int n6 = n3 + i;
                int n7 = n3 + i;
                int n8 = nArray[n7];
                n7 += n4;
                int n9 = n8 >>> 24;
                int n10 = n8 & 0xFF0000;
                int n11 = n8 & 0xFF00;
                int n12 = n8 & 0xFF;
                for (n5 = 1; n5 < n2; ++n5) {
                    int n13 = nArray[n7];
                    n7 += n4;
                    int n14 = n13 >>> 24;
                    int n15 = n13 & 0xFF0000;
                    int n16 = n13 & 0xFF00;
                    int n17 = n13 & 0xFF;
                    if (MorphologyOp.isBetter(n14, n9, this.doDilation)) {
                        n9 = n14;
                    }
                    if (MorphologyOp.isBetter(n15, n10, this.doDilation)) {
                        n10 = n15;
                    }
                    if (MorphologyOp.isBetter(n16, n11, this.doDilation)) {
                        n11 = n16;
                    }
                    if (!MorphologyOp.isBetter(n17, n12, this.doDilation)) continue;
                    n12 = n17;
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    nArray[n6] = n9 << 24 | n10 | n11 | n12;
                    n6 += n4;
                }
            }
        } else {
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            int[] nArray5 = new int[n2];
            for (int i = 0; i < n; ++i) {
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23 = n3 + i;
                int n24 = n3 + i;
                int n25 = 0;
                int n26 = 0;
                int n27 = 0;
                int n28 = 0;
                int n29 = 0;
                int n30 = nArray[n24];
                n24 += n4;
                int n31 = n30 >>> 24;
                int n32 = n30 & 0xFF0000;
                int n33 = n30 & 0xFF00;
                int n34 = n30 & 0xFF;
                nArray2[0] = n31;
                nArray3[0] = n32;
                nArray4[0] = n33;
                nArray5[0] = n34;
                for (n22 = 1; n22 <= this.radiusY; ++n22) {
                    int n35 = nArray[n24];
                    n24 += n4;
                    n21 = n35 >>> 24;
                    n20 = n35 & 0xFF0000;
                    n19 = n35 & 0xFF00;
                    n18 = n35 & 0xFF;
                    nArray2[n22] = n21;
                    nArray3[n22] = n20;
                    nArray4[n22] = n19;
                    nArray5[n22] = n18;
                    if (MorphologyOp.isBetter(n21, n31, this.doDilation)) {
                        n31 = n21;
                        n26 = n22;
                    }
                    if (MorphologyOp.isBetter(n20, n32, this.doDilation)) {
                        n32 = n20;
                        n27 = n22;
                    }
                    if (MorphologyOp.isBetter(n19, n33, this.doDilation)) {
                        n33 = n19;
                        n28 = n22;
                    }
                    if (!MorphologyOp.isBetter(n18, n34, this.doDilation)) continue;
                    n34 = n18;
                    n29 = n22;
                }
                nArray[n23] = n31 << 24 | n32 | n33 | n34;
                n23 += n4;
                for (n22 = 1; n22 <= n2 - this.radiusY - 1; ++n22) {
                    int n36 = nArray[n24];
                    n24 += n4;
                    n31 = nArray2[n26];
                    nArray2[n22 + this.radiusY] = n21 = n36 >>> 24;
                    if (MorphologyOp.isBetter(n21, n31, this.doDilation)) {
                        n31 = n21;
                        n26 = n22 + this.radiusY;
                    }
                    n32 = nArray3[n27];
                    nArray3[n22 + this.radiusY] = n20 = n36 & 0xFF0000;
                    if (MorphologyOp.isBetter(n20, n32, this.doDilation)) {
                        n32 = n20;
                        n27 = n22 + this.radiusY;
                    }
                    n33 = nArray4[n28];
                    nArray4[n22 + this.radiusY] = n19 = n36 & 0xFF00;
                    if (MorphologyOp.isBetter(n19, n33, this.doDilation)) {
                        n33 = n19;
                        n28 = n22 + this.radiusY;
                    }
                    n34 = nArray5[n29];
                    nArray5[n22 + this.radiusY] = n18 = n36 & 0xFF;
                    if (MorphologyOp.isBetter(n18, n34, this.doDilation)) {
                        n34 = n18;
                        n29 = n22 + this.radiusY;
                    }
                    nArray[n23] = n31 << 24 | n32 | n33 | n34;
                    n23 += n4;
                }
                for (n22 = n2 - this.radiusY; n22 <= this.radiusY; ++n22) {
                    nArray[n23] = nArray[n23 - n4];
                    n23 += n4;
                }
                for (n22 = this.radiusY + 1; n22 < n2; ++n22) {
                    int n37;
                    if (n26 == n25) {
                        n31 = nArray2[n25 + 1];
                        n26 = n25 + 1;
                        for (n37 = n25 + 2; n37 < n2; ++n37) {
                            n21 = nArray2[n37];
                            if (!MorphologyOp.isBetter(n21, n31, this.doDilation)) continue;
                            n31 = n21;
                            n26 = n37;
                        }
                    } else {
                        n31 = nArray2[n26];
                    }
                    if (n27 == n25) {
                        n32 = nArray3[n25 + 1];
                        n27 = n25 + 1;
                        for (n37 = n25 + 2; n37 < n2; ++n37) {
                            n20 = nArray3[n37];
                            if (!MorphologyOp.isBetter(n20, n32, this.doDilation)) continue;
                            n32 = n20;
                            n27 = n37;
                        }
                    } else {
                        n32 = nArray3[n27];
                    }
                    if (n28 == n25) {
                        n33 = nArray4[n25 + 1];
                        n28 = n25 + 1;
                        for (n37 = n25 + 2; n37 < n2; ++n37) {
                            n19 = nArray4[n37];
                            if (!MorphologyOp.isBetter(n19, n33, this.doDilation)) continue;
                            n33 = n19;
                            n28 = n37;
                        }
                    } else {
                        n33 = nArray4[n28];
                    }
                    if (n29 == n25) {
                        n34 = nArray5[n25 + 1];
                        n29 = n25 + 1;
                        for (n37 = n25 + 2; n37 < n2; ++n37) {
                            n18 = nArray5[n37];
                            if (!MorphologyOp.isBetter(n18, n34, this.doDilation)) continue;
                            n34 = n18;
                            n29 = n37;
                        }
                    } else {
                        n34 = nArray5[n29];
                    }
                    ++n25;
                    nArray[n23] = n31 << 24 | n32 | n33 | n34;
                    n23 += n4;
                }
            }
        }
    }

    @Override
    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24;
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        if (writableRaster != null) {
            this.checkCompatible(writableRaster.getSampleModel());
        } else {
            if (raster == null) {
                throw new IllegalArgumentException("src should not be null when dest is null");
            }
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        int n25 = raster.getWidth();
        int n26 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n27 = dataBufferInt.getOffset();
        int n28 = dataBufferInt2.getOffset();
        int n29 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n30 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        if (n25 <= 2 * this.radiusX) {
            this.specialProcessRow(raster, writableRaster);
        } else {
            nArray4 = new int[this.rangeX];
            nArray3 = new int[this.rangeX];
            nArray2 = new int[this.rangeX];
            nArray = new int[this.rangeX];
            for (n24 = 0; n24 < n26; ++n24) {
                int n31 = n27 + n24 * n29;
                n23 = n28 + n24 * n30;
                n22 = 0;
                n21 = 0;
                n20 = 0;
                n19 = 0;
                n18 = 0;
                n17 = nArray5[n31++];
                n16 = n17 >>> 24;
                n15 = n17 & 0xFF0000;
                n14 = n17 & 0xFF00;
                n13 = n17 & 0xFF;
                nArray4[0] = n16;
                nArray3[0] = n15;
                nArray2[0] = n14;
                nArray[0] = n13;
                for (n12 = 1; n12 <= this.radiusX; ++n12) {
                    n11 = nArray5[n31++];
                    n10 = n11 >>> 24;
                    n9 = n11 & 0xFF0000;
                    n8 = n11 & 0xFF00;
                    n7 = n11 & 0xFF;
                    nArray4[n12] = n10;
                    nArray3[n12] = n9;
                    nArray2[n12] = n8;
                    nArray[n12] = n7;
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n12;
                    }
                    if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                        n15 = n9;
                        n20 = n12;
                    }
                    if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                        n14 = n8;
                        n19 = n12;
                    }
                    if (!MorphologyOp.isBetter(n7, n13, this.doDilation)) continue;
                    n13 = n7;
                    n18 = n12;
                }
                nArray6[n23++] = n16 << 24 | n15 | n14 | n13;
                for (n12 = 1; n12 <= this.radiusX; ++n12) {
                    n6 = nArray5[n31++];
                    n16 = nArray4[n21];
                    nArray4[n12 + this.radiusX] = n10 = n6 >>> 24;
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n12 + this.radiusX;
                    }
                    n15 = nArray3[n20];
                    nArray3[n12 + this.radiusX] = n9 = n6 & 0xFF0000;
                    if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                        n15 = n9;
                        n20 = n12 + this.radiusX;
                    }
                    n14 = nArray2[n19];
                    nArray2[n12 + this.radiusX] = n8 = n6 & 0xFF00;
                    if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                        n14 = n8;
                        n19 = n12 + this.radiusX;
                    }
                    n13 = nArray[n18];
                    nArray[n12 + this.radiusX] = n7 = n6 & 0xFF;
                    if (MorphologyOp.isBetter(n7, n13, this.doDilation)) {
                        n13 = n7;
                        n18 = n12 + this.radiusX;
                    }
                    nArray6[n23++] = n16 << 24 | n15 | n14 | n13;
                }
                for (n12 = this.radiusX + 1; n12 <= n25 - 1 - this.radiusX; ++n12) {
                    n6 = nArray5[n31++];
                    n10 = n6 >>> 24;
                    n9 = n6 & 0xFF0000;
                    n8 = n6 & 0xFF00;
                    n7 = n6 & 0xFF;
                    nArray4[n22] = n10;
                    nArray3[n22] = n9;
                    nArray2[n22] = n8;
                    nArray[n22] = n7;
                    if (n21 == n22) {
                        n16 = nArray4[0];
                        n21 = 0;
                        for (n5 = 1; n5 < this.rangeX; ++n5) {
                            n10 = nArray4[n5];
                            if (!MorphologyOp.isBetter(n10, n16, this.doDilation)) continue;
                            n16 = n10;
                            n21 = n5;
                        }
                    } else {
                        n16 = nArray4[n21];
                        if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                            n16 = n10;
                            n21 = n22;
                        }
                    }
                    if (n20 == n22) {
                        n15 = nArray3[0];
                        n20 = 0;
                        for (n5 = 1; n5 < this.rangeX; ++n5) {
                            n9 = nArray3[n5];
                            if (!MorphologyOp.isBetter(n9, n15, this.doDilation)) continue;
                            n15 = n9;
                            n20 = n5;
                        }
                    } else {
                        n15 = nArray3[n20];
                        if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                            n15 = n9;
                            n20 = n22;
                        }
                    }
                    if (n19 == n22) {
                        n14 = nArray2[0];
                        n19 = 0;
                        for (n5 = 1; n5 < this.rangeX; ++n5) {
                            n8 = nArray2[n5];
                            if (!MorphologyOp.isBetter(n8, n14, this.doDilation)) continue;
                            n14 = n8;
                            n19 = n5;
                        }
                    } else {
                        n14 = nArray2[n19];
                        if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                            n14 = n8;
                            n19 = n22;
                        }
                    }
                    if (n18 == n22) {
                        n13 = nArray[0];
                        n18 = 0;
                        for (n5 = 1; n5 < this.rangeX; ++n5) {
                            n7 = nArray[n5];
                            if (!MorphologyOp.isBetter(n7, n13, this.doDilation)) continue;
                            n13 = n7;
                            n18 = n5;
                        }
                    } else {
                        n13 = nArray[n18];
                        if (MorphologyOp.isBetter(n7, n13, this.doDilation)) {
                            n13 = n7;
                            n18 = n22;
                        }
                    }
                    nArray6[n23++] = n16 << 24 | n15 | n14 | n13;
                    n22 = (n22 + 1) % this.rangeX;
                }
                n5 = n22 == 0 ? this.rangeX - 1 : n22 - 1;
                n4 = this.rangeX - 1;
                for (n3 = n25 - this.radiusX; n3 < n25; ++n3) {
                    n12 = (n22 + 1) % this.rangeX;
                    if (n21 == n22) {
                        n16 = nArray4[n5];
                        n2 = n12;
                        for (n = 1; n < n4; ++n) {
                            n10 = nArray4[n2];
                            if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                                n16 = n10;
                                n21 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeX;
                        }
                    }
                    if (n20 == n22) {
                        n15 = nArray3[n5];
                        n2 = n12;
                        for (n = 1; n < n4; ++n) {
                            n9 = nArray3[n2];
                            if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                                n15 = n9;
                                n20 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeX;
                        }
                    }
                    if (n19 == n22) {
                        n14 = nArray2[n5];
                        n2 = n12;
                        for (n = 1; n < n4; ++n) {
                            n8 = nArray2[n2];
                            if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                                n14 = n8;
                                n19 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeX;
                        }
                    }
                    if (n18 == n22) {
                        n13 = nArray[n5];
                        n2 = n12;
                        for (n = 1; n < n4; ++n) {
                            n7 = nArray[n2];
                            if (MorphologyOp.isBetter(n7, n13, this.doDilation)) {
                                n13 = n7;
                                n18 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeX;
                        }
                    }
                    nArray6[n23++] = n16 << 24 | n15 | n14 | n13;
                    n22 = (n22 + 1) % this.rangeX;
                    --n4;
                }
            }
        }
        if (n26 <= 2 * this.radiusY) {
            this.specialProcessColumn(raster, writableRaster);
        } else {
            nArray4 = new int[this.rangeY];
            nArray3 = new int[this.rangeY];
            nArray2 = new int[this.rangeY];
            nArray = new int[this.rangeY];
            for (n24 = 0; n24 < n25; ++n24) {
                n23 = n28 + n24;
                int n32 = n28 + n24;
                n22 = 0;
                n21 = 0;
                n20 = 0;
                n19 = 0;
                n18 = 0;
                n17 = nArray6[n32];
                n32 += n30;
                n16 = n17 >>> 24;
                n15 = n17 & 0xFF0000;
                n14 = n17 & 0xFF00;
                n13 = n17 & 0xFF;
                nArray4[0] = n16;
                nArray3[0] = n15;
                nArray2[0] = n14;
                nArray[0] = n13;
                for (n12 = 1; n12 <= this.radiusY; ++n12) {
                    n11 = nArray6[n32];
                    n32 += n30;
                    n10 = n11 >>> 24;
                    n9 = n11 & 0xFF0000;
                    n8 = n11 & 0xFF00;
                    n7 = n11 & 0xFF;
                    nArray4[n12] = n10;
                    nArray3[n12] = n9;
                    nArray2[n12] = n8;
                    nArray[n12] = n7;
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n12;
                    }
                    if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                        n15 = n9;
                        n20 = n12;
                    }
                    if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                        n14 = n8;
                        n19 = n12;
                    }
                    if (!MorphologyOp.isBetter(n7, n13, this.doDilation)) continue;
                    n13 = n7;
                    n18 = n12;
                }
                nArray6[n23] = n16 << 24 | n15 | n14 | n13;
                n23 += n30;
                for (n12 = 1; n12 <= this.radiusY; ++n12) {
                    n5 = n12 + this.radiusY;
                    n6 = nArray6[n32];
                    n32 += n30;
                    n16 = nArray4[n21];
                    nArray4[n5] = n10 = n6 >>> 24;
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n5;
                    }
                    n15 = nArray3[n20];
                    nArray3[n5] = n9 = n6 & 0xFF0000;
                    if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                        n15 = n9;
                        n20 = n5;
                    }
                    n14 = nArray2[n19];
                    nArray2[n5] = n8 = n6 & 0xFF00;
                    if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                        n14 = n8;
                        n19 = n5;
                    }
                    n13 = nArray[n18];
                    nArray[n5] = n7 = n6 & 0xFF;
                    if (MorphologyOp.isBetter(n7, n13, this.doDilation)) {
                        n13 = n7;
                        n18 = n5;
                    }
                    nArray6[n23] = n16 << 24 | n15 | n14 | n13;
                    n23 += n30;
                }
                for (n12 = this.radiusY + 1; n12 <= n26 - 1 - this.radiusY; ++n12) {
                    n6 = nArray6[n32];
                    n32 += n30;
                    n10 = n6 >>> 24;
                    n9 = n6 & 0xFF0000;
                    n8 = n6 & 0xFF00;
                    n7 = n6 & 0xFF;
                    nArray4[n22] = n10;
                    nArray3[n22] = n9;
                    nArray2[n22] = n8;
                    nArray[n22] = n7;
                    if (n21 == n22) {
                        n16 = nArray4[0];
                        n21 = 0;
                        for (n5 = 1; n5 <= 2 * this.radiusY; ++n5) {
                            n10 = nArray4[n5];
                            if (!MorphologyOp.isBetter(n10, n16, this.doDilation)) continue;
                            n16 = n10;
                            n21 = n5;
                        }
                    } else {
                        n16 = nArray4[n21];
                        if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                            n16 = n10;
                            n21 = n22;
                        }
                    }
                    if (n20 == n22) {
                        n15 = nArray3[0];
                        n20 = 0;
                        for (n5 = 1; n5 <= 2 * this.radiusY; ++n5) {
                            n9 = nArray3[n5];
                            if (!MorphologyOp.isBetter(n9, n15, this.doDilation)) continue;
                            n15 = n9;
                            n20 = n5;
                        }
                    } else {
                        n15 = nArray3[n20];
                        if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                            n15 = n9;
                            n20 = n22;
                        }
                    }
                    if (n19 == n22) {
                        n14 = nArray2[0];
                        n19 = 0;
                        for (n5 = 1; n5 <= 2 * this.radiusY; ++n5) {
                            n8 = nArray2[n5];
                            if (!MorphologyOp.isBetter(n8, n14, this.doDilation)) continue;
                            n14 = n8;
                            n19 = n5;
                        }
                    } else {
                        n14 = nArray2[n19];
                        if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                            n14 = n8;
                            n19 = n22;
                        }
                    }
                    if (n18 == n22) {
                        n13 = nArray[0];
                        n18 = 0;
                        for (n5 = 1; n5 <= 2 * this.radiusY; ++n5) {
                            n7 = nArray[n5];
                            if (!MorphologyOp.isBetter(n7, n13, this.doDilation)) continue;
                            n13 = n7;
                            n18 = n5;
                        }
                    } else {
                        n13 = nArray[n18];
                        if (MorphologyOp.isBetter(n7, n13, this.doDilation)) {
                            n13 = n7;
                            n18 = n22;
                        }
                    }
                    nArray6[n23] = n16 << 24 | n15 | n14 | n13;
                    n23 += n30;
                    n22 = (n22 + 1) % this.rangeY;
                }
                n5 = n22 == 0 ? 2 * this.radiusY : n22 - 1;
                n4 = this.rangeY - 1;
                for (n3 = n26 - this.radiusY; n3 < n26 - 1; ++n3) {
                    n12 = (n22 + 1) % this.rangeY;
                    if (n21 == n22) {
                        n16 = nArray4[n5];
                        n2 = n12;
                        for (n = 1; n < n4; ++n) {
                            n10 = nArray4[n2];
                            if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                                n16 = n10;
                                n21 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeY;
                        }
                    }
                    if (n20 == n22) {
                        n15 = nArray3[n5];
                        n2 = n12;
                        for (n = 1; n < n4; ++n) {
                            n9 = nArray3[n2];
                            if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                                n15 = n9;
                                n20 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeY;
                        }
                    }
                    if (n19 == n22) {
                        n14 = nArray2[n5];
                        n2 = n12;
                        for (n = 1; n < n4; ++n) {
                            n8 = nArray2[n2];
                            if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                                n14 = n8;
                                n19 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeY;
                        }
                    }
                    if (n18 == n22) {
                        n13 = nArray[n5];
                        n2 = n12;
                        for (n = 1; n < n4; ++n) {
                            n7 = nArray[n2];
                            if (MorphologyOp.isBetter(n7, n13, this.doDilation)) {
                                n13 = n7;
                                n18 = n2;
                            }
                            n2 = (n2 + 1) % this.rangeY;
                        }
                    }
                    nArray6[n23] = n16 << 24 | n15 | n14 | n13;
                    n23 += n30;
                    n22 = (n22 + 1) % this.rangeY;
                    --n4;
                }
            }
        }
        return writableRaster;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ColorModel colorModel;
        ColorModel colorModel2;
        if (bufferedImage == null) {
            throw new NullPointerException("Source image should not be null");
        }
        BufferedImage bufferedImage3 = bufferedImage;
        BufferedImage bufferedImage4 = bufferedImage2;
        if (!this.isCompatible(bufferedImage.getColorModel(), bufferedImage.getSampleModel())) {
            bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
            GraphicsUtil.copyData(bufferedImage3, bufferedImage);
        } else if (!bufferedImage.isAlphaPremultiplied()) {
            colorModel2 = bufferedImage.getColorModel();
            colorModel = GraphicsUtil.coerceColorModel(colorModel2, true);
            bufferedImage = new BufferedImage(colorModel, bufferedImage.getRaster(), true, null);
            GraphicsUtil.copyData(bufferedImage3, bufferedImage);
        }
        if (bufferedImage2 == null) {
            bufferedImage4 = bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else if (!this.isCompatible(bufferedImage2.getColorModel(), bufferedImage2.getSampleModel())) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else if (!bufferedImage2.isAlphaPremultiplied()) {
            colorModel2 = bufferedImage2.getColorModel();
            colorModel = GraphicsUtil.coerceColorModel(colorModel2, true);
            bufferedImage2 = new BufferedImage(colorModel, bufferedImage4.getRaster(), true, null);
        }
        this.filter(bufferedImage.getRaster(), bufferedImage2.getRaster());
        if (bufferedImage.getRaster() == bufferedImage3.getRaster() && bufferedImage.isAlphaPremultiplied() != bufferedImage3.isAlphaPremultiplied()) {
            GraphicsUtil.copyData(bufferedImage, bufferedImage3);
        }
        if (bufferedImage2.getRaster() != bufferedImage4.getRaster() || bufferedImage2.isAlphaPremultiplied() != bufferedImage4.isAlphaPremultiplied()) {
            GraphicsUtil.copyData(bufferedImage2, bufferedImage4);
        }
        return bufferedImage4;
    }
}

