/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferio;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;

public class MarkersSaveRequest
extends Task {
    public static final String ERROR_OCCURRED = "MarkersSaveRequest__error";
    protected View view;
    protected Buffer buffer;
    protected Object session;
    protected VFS vfs;
    protected String path;
    protected String markersPath;

    public MarkersSaveRequest(View view, Buffer buffer, Object object, VFS vFS, String string) {
        this.view = view;
        this.buffer = buffer;
        this.session = object;
        this.vfs = vFS;
        this.path = string;
        this.markersPath = Buffer.getMarkersPath(vFS, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _run() {
        OutputStream outputStream = null;
        try {
            if ((this.vfs.getCapabilities() & 8) != 0) {
                if (this.buffer.getMarkers().isEmpty()) {
                    this.vfs._delete(this.session, this.markersPath, this.view);
                } else {
                    Object[] objectArray = new String[]{this.vfs.getFileName(this.path)};
                    this.setStatus(jEdit.getProperty("vfs.status.save-markers", objectArray));
                    outputStream = this.vfs._createOutputStream(this.session, this.markersPath, this.view);
                    if (outputStream != null) {
                        this.writeMarkers(outputStream);
                    }
                }
            }
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
            this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
        }
        finally {
            IOUtilities.closeQuietly(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMarkers(OutputStream outputStream) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));){
            Vector<Marker> vector;
            Vector<Marker> vector2 = vector = this.buffer.getMarkers();
            synchronized (vector2) {
                this.setMaximum(vector.size());
                for (int i = 0; i < vector.size(); ++i) {
                    this.setValue(i + 1);
                    Marker marker = (Marker)vector.get(i);
                    ((Writer)bufferedWriter).write(33);
                    ((Writer)bufferedWriter).write(marker.getShortcut());
                    ((Writer)bufferedWriter).write(59);
                    String string = String.valueOf(marker.getPosition());
                    bufferedWriter.write(string);
                    ((Writer)bufferedWriter).write(59);
                    bufferedWriter.write(string);
                    ((Writer)bufferedWriter).write(10);
                }
            }
        }
    }
}

