/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.GeneralPath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CreateMultipolygonAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class MultipolygonTest
extends Test {
    protected static final int WRONG_MEMBER_TYPE = 1601;
    protected static final int WRONG_MEMBER_ROLE = 1602;
    protected static final int NON_CLOSED_WAY = 1603;
    protected static final int MISSING_OUTER_WAY = 1604;
    protected static final int INNER_WAY_OUTSIDE = 1605;
    protected static final int CROSSING_WAYS = 1606;
    protected static final int OUTER_STYLE_MISMATCH = 1607;
    protected static final int INNER_STYLE_MISMATCH = 1608;
    protected static final int NOT_CLOSED = 1609;
    protected static final int NO_STYLE = 1610;
    protected static final int NO_STYLE_POLYGON = 1611;
    protected static final int OUTER_STYLE = 1613;
    private static volatile ElemStyles styles;
    private final Set<String> keysCheckedByAnotherTest = new HashSet<String>();

    public MultipolygonTest() {
        super(I18n.tr("Multipolygon", new Object[0]), I18n.tr("This test checks if multipolygons are valid.", new Object[0]));
    }

    @Override
    public void initialize() {
        styles = MapPaintStyles.getStyles();
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.keysCheckedByAnotherTest.clear();
        for (Test test : OsmValidator.getEnabledTests(false)) {
            if (!(test instanceof UnclosedWays)) continue;
            this.keysCheckedByAnotherTest.addAll(((UnclosedWays)test).getCheckedKeys());
            break;
        }
    }

    @Override
    public void endTest() {
        this.keysCheckedByAnotherTest.clear();
        super.endTest();
    }

    private static GeneralPath createPath(List<Node> list) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)list.get(0).getCoor().lat(), (float)list.get(0).getCoor().lon());
        for (int i = 1; i < list.size(); ++i) {
            Node node = list.get(i);
            generalPath.lineTo((float)node.getCoor().lat(), (float)node.getCoor().lon());
        }
        return generalPath;
    }

    private List<GeneralPath> createPolygons(List<Multipolygon.PolyData> list) {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        for (Multipolygon.PolyData polyData : list) {
            arrayList.add(MultipolygonTest.createPath(polyData.getNodes()));
        }
        return arrayList;
    }

    private static Multipolygon.PolyData.Intersection getPolygonIntersection(GeneralPath generalPath, List<Node> list) {
        boolean bl = false;
        boolean bl2 = false;
        for (Node node : list) {
            boolean bl3 = generalPath.contains(node.getCoor().lat(), node.getCoor().lon());
            if (!((bl |= bl3) & (bl2 |= !bl3))) continue;
            return Multipolygon.PolyData.Intersection.CROSSING;
        }
        return bl ? Multipolygon.PolyData.Intersection.INSIDE : Multipolygon.PolyData.Intersection.OUTSIDE;
    }

    @Override
    public void visit(Way way) {
        if (!way.isArea() && ElemStyles.hasOnlyAreaElemStyle(way)) {
            List<Node> list = way.getNodes();
            if (list.isEmpty()) {
                return;
            }
            for (String string : this.keysCheckedByAnotherTest) {
                if (!way.hasKey(string)) continue;
                return;
            }
            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Area style way is not closed", new Object[0]), 1609, Collections.singletonList(way), Arrays.asList(list.get(0), list.get(list.size() - 1))));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(Relation relation) {
        if (relation.isMultipolygon()) {
            List<Node> list;
            Object object;
            this.checkMembersAndRoles(relation);
            Multipolygon multipolygon = MultipolygonCache.getInstance().get(Main.map.mapView, relation);
            boolean bl = false;
            for (RelationMember object32 : relation.getMembers()) {
                if (!"outer".equals(object32.getRole())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.addError(relation, new TestError((Test)this, Severity.WARNING, I18n.tr("No outer way for multipolygon", new Object[0]), 1604, relation));
            }
            if (relation.hasIncompleteMembers()) {
                return;
            }
            Pair<Relation, Relation> pair = CreateMultipolygonAction.createMultipolygonRelation(relation.getMemberPrimitives(Way.class), false);
            if (pair != null) {
                for (RelationMember relationMember : relation.getMembers()) {
                    object = ((Relation)pair.b).getMembersFor(Collections.singleton(relationMember.getMember()));
                    if (object == null || object.isEmpty()) continue;
                    String string = ((RelationMember)object.iterator().next()).getRole();
                    if (relationMember.getRole().equals(string)) continue;
                    this.addError(relation, new TestError(this, Severity.WARNING, RelationChecker.ROLE_VERIF_PROBLEM_MSG, I18n.tr("Role for ''{0}'' should be ''{1}''", relationMember.getMember().getDisplayName(DefaultNameFormatter.getInstance()), string), MessageFormat.format("Role for ''{0}'' should be ''{1}''", relationMember.getMember().getDisplayName(DefaultNameFormatter.getInstance()), string), 1602, Collections.singleton(relation), Collections.singleton(relationMember.getMember())));
                }
            }
            if (styles != null && !"boundary".equals(relation.get("type"))) {
                void var5_9;
                boolean bl2;
                AreaElemStyle areaElemStyle = ElemStyles.getAreaElemStyle(relation, false);
                boolean bl3 = bl2 = areaElemStyle != null;
                if (areaElemStyle == null) {
                    Way way;
                    AreaElemStyle areaElemStyle2;
                    object = multipolygon.getOuterWays().iterator();
                    while (object.hasNext() && (areaElemStyle2 = ElemStyles.getAreaElemStyle(way = object.next(), true)) == null) {
                    }
                    if (var5_9 == null) {
                        this.addError(relation, new TestError((Test)this, Severity.OTHER, I18n.tr("No area style for multipolygon", new Object[0]), 1610, relation));
                    } else {
                        this.addError(relation, new TestError((Test)this, Severity.WARNING, I18n.trn("Multipolygon relation should be tagged with area tags and not the outer way", "Multipolygon relation should be tagged with area tags and not the outer ways", multipolygon.getOuterWays().size(), new Object[0]), 1611, relation));
                    }
                }
                if (var5_9 != null) {
                    ArrayList<OsmPrimitive> arrayList;
                    AreaElemStyle areaElemStyle3;
                    for (Way way : multipolygon.getInnerWays()) {
                        areaElemStyle3 = ElemStyles.getAreaElemStyle(way, false);
                        if (areaElemStyle3 == null || !var5_9.equals(areaElemStyle3)) continue;
                        arrayList = new ArrayList<OsmPrimitive>();
                        arrayList.add(relation);
                        arrayList.add(way);
                        this.addError(relation, new TestError(this, Severity.OTHER, I18n.tr("With the currently used mappaint style the style for inner way equals the multipolygon style", new Object[0]), 1608, arrayList, Collections.singletonList(way)));
                    }
                    for (Way way : multipolygon.getOuterWays()) {
                        areaElemStyle3 = ElemStyles.getAreaElemStyle(way, false);
                        if (areaElemStyle3 == null) continue;
                        arrayList = new ArrayList();
                        arrayList.add(relation);
                        arrayList.add(way);
                        if (!var5_9.equals(areaElemStyle3)) {
                            this.addError(relation, new TestError(this, Severity.WARNING, !bl2 ? I18n.tr("Style for outer way mismatches", new Object[0]) : I18n.tr("With the currently used mappaint style(s) the style for outer way mismatches polygon", new Object[0]), 1607, arrayList, Collections.singletonList(way)));
                            continue;
                        }
                        if (!bl2) continue;
                        this.addError(relation, new TestError(this, Severity.WARNING, I18n.tr("Area style on outer way", new Object[0]), 1613, arrayList, Collections.singletonList(way)));
                    }
                }
            }
            if (!(list = multipolygon.getOpenEnds()).isEmpty()) {
                LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
                linkedList.add(relation);
                linkedList.addAll(list);
                Arrays.asList(list, relation);
                this.addError(relation, new TestError(this, Severity.WARNING, I18n.tr("Multipolygon is not closed", new Object[0]), 1603, linkedList, list));
            }
            List<GeneralPath> list2 = this.createPolygons(multipolygon.getOuterPolygons());
            for (Multipolygon.PolyData polyData : multipolygon.getInnerPolygons()) {
                boolean bl4 = true;
                boolean bl5 = false;
                Multipolygon.PolyData polyData2 = null;
                for (int i = 0; i < multipolygon.getOuterPolygons().size(); ++i) {
                    GeneralPath generalPath = list2.get(i);
                    Multipolygon.PolyData.Intersection intersection = MultipolygonTest.getPolygonIntersection(generalPath, polyData.getNodes());
                    bl4 &= intersection == Multipolygon.PolyData.Intersection.OUTSIDE;
                    if (intersection != Multipolygon.PolyData.Intersection.CROSSING) continue;
                    bl5 = true;
                    polyData2 = multipolygon.getOuterPolygons().get(i);
                }
                if (!bl4 && !bl5) continue;
                ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
                arrayList.add(polyData.getNodes());
                if (bl4) {
                    this.addError(relation, new TestError(this, Severity.WARNING, I18n.tr("Multipolygon inner way is outside", new Object[0]), 1605, Collections.singletonList(relation), arrayList));
                    continue;
                }
                arrayList.add(polyData2.getNodes());
                this.addError(relation, new TestError(this, Severity.WARNING, I18n.tr("Intersection between multipolygon ways", new Object[0]), 1606, Collections.singletonList(relation), arrayList));
            }
        }
    }

    private void checkMembersAndRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.isWay()) {
                if (relationMember.hasRole("inner", "outer") || !relationMember.hasRole()) continue;
                this.addError(relation, new TestError((Test)this, Severity.WARNING, I18n.tr("No useful role for multipolygon member", new Object[0]), 1602, relationMember.getMember()));
                continue;
            }
            if (relationMember.hasRole("admin_centre", "label", "subarea", "land_area")) continue;
            this.addError(relation, new TestError((Test)this, Severity.WARNING, I18n.tr("Non-Way in multipolygon", new Object[0]), 1601, relationMember.getMember()));
        }
    }

    private static void addRelationIfNeeded(TestError testError, Relation relation) {
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        if (!collection.contains(relation)) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive.isIncomplete()) continue;
                return;
            }
            ArrayList<? extends OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection);
            arrayList.add(0, relation);
            testError.setPrimitives((List<? extends OsmPrimitive>)arrayList);
        }
    }

    private void addError(Relation relation, TestError testError) {
        MultipolygonTest.addRelationIfNeeded(testError, relation);
        this.errors.add(testError);
    }
}

