/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.preferences.projection.AbstractProjectionChoice;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.Utils;

public abstract class ListProjectionChoice
extends AbstractProjectionChoice {
    protected int index;
    protected int defaultIndex;
    protected String[] entries;
    protected String label;

    public ListProjectionChoice(String string, String string2, String[] stringArray, String string3, int n) {
        super(string, string2);
        this.entries = Utils.copyArray(stringArray);
        this.label = string3;
        this.defaultIndex = n;
    }

    public ListProjectionChoice(String string, String string2, String[] stringArray, String string3) {
        this(string, string2, stringArray, string3, 0);
    }

    protected abstract String indexToZone(int var1);

    protected abstract int zoneToIndex(String var1);

    @Override
    public void setPreferences(Collection<String> collection) {
        int n;
        String string = null;
        if (collection != null && !collection.isEmpty()) {
            string = collection.iterator().next();
        }
        if (string == null) {
            n = this.defaultIndex;
        } else {
            n = this.zoneToIndex(string);
            if (n < 0 || n >= this.entries.length) {
                n = this.defaultIndex;
            }
        }
        this.index = n;
    }

    @Override
    public JPanel getPreferencePanel(ActionListener actionListener) {
        return new CBPanel(this.entries, this.index, this.label, actionListener);
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        if (!(jPanel instanceof CBPanel)) {
            throw new IllegalArgumentException("Unsupported panel: " + jPanel);
        }
        CBPanel cBPanel = (CBPanel)jPanel;
        int n = cBPanel.prefcb.getSelectedIndex();
        return Collections.singleton(this.indexToZone(n));
    }

    protected class CBPanel
    extends JPanel {
        public JosmComboBox<String> prefcb;

        public CBPanel(String[] stringArray, int n, String string, ActionListener actionListener) {
            this.prefcb = new JosmComboBox<String>(stringArray);
            this.prefcb.setSelectedIndex(n);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(string), GBC.std().insets(5, 5, 0, 5));
            this.add(GBC.glue(1, 0), GBC.std().fill(2));
            this.add(this.prefcb, GBC.eop().fill(2));
            this.add(GBC.glue(1, 1), GBC.eol().fill(1));
            if (actionListener != null) {
                this.prefcb.addActionListener(actionListener);
            }
        }
    }
}

