/*
 * Decompiled with CFR 0.152.
 */
package de.danielnaber.jwordsplitter;

import de.danielnaber.jwordsplitter.ExceptionSplits;
import de.danielnaber.jwordsplitter.GermanInterfixDisambiguator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractWordSplitter {
    protected Set<String> words = null;
    private final boolean hideInterfixCharacters;
    private ExceptionSplits exceptionSplits;
    private boolean strictMode = true;
    private int minimumWordLength = this.getDefaultMinimumWordLength();

    protected abstract Set<String> getWordList(InputStream var1) throws IOException;

    protected abstract Set<String> getWordList() throws IOException;

    protected abstract GermanInterfixDisambiguator getDisambiguator();

    protected abstract int getDefaultMinimumWordLength();

    protected abstract Collection<String> getInterfixCharacters();

    public AbstractWordSplitter(boolean hideInterfixCharacters) throws IOException {
        this.hideInterfixCharacters = hideInterfixCharacters;
        this.words = this.getWordList();
    }

    public AbstractWordSplitter(boolean hideInterfixCharacters, InputStream plainTextDict) throws IOException {
        this.hideInterfixCharacters = hideInterfixCharacters;
        this.words = this.getWordList(plainTextDict);
    }

    public AbstractWordSplitter(boolean hideInterfixCharacters, File plainTextDict) throws IOException {
        this.hideInterfixCharacters = hideInterfixCharacters;
        this.words = this.getWordList(plainTextDict);
    }

    public AbstractWordSplitter(boolean hideInterfixCharacters, Set<String> words) throws IOException {
        this.hideInterfixCharacters = hideInterfixCharacters;
        this.words = words;
    }

    private Set<String> getWordList(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            Set<String> set = this.getWordList(fis);
            return set;
        }
    }

    public void setMinimumWordLength(int minimumWordLength) {
        this.minimumWordLength = minimumWordLength;
    }

    public void setExceptionFile(String filename) throws IOException {
        this.exceptionSplits = new ExceptionSplits(filename);
    }

    public void addException(String completeWord, List<String> wordParts) {
        this.exceptionSplits.addSplit(completeWord.toLowerCase(), wordParts);
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public List<List<String>> getAllSplits(String word) {
        List<List<String>> result1 = this.getAllSplits(word, true);
        List<List<String>> result2 = this.getAllSplits(word, false);
        ArrayList<List<String>> result = new ArrayList<List<String>>(result1);
        for (List<String> split : result2) {
            if (result.contains(split)) continue;
            result.add(split);
        }
        return result;
    }

    List<List<String>> getAllSplits(String word, boolean fromLeft) {
        int start;
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        int i = start = fromLeft ? this.minimumWordLength : word.length() - this.minimumWordLength;
        while (this.isLoopEnd(fromLeft, i, word)) {
            String left = word.substring(0, i);
            String right = word.substring(i, word.length());
            String relevantWord = fromLeft ? left : right;
            boolean isSimpleWord = this.isSimpleWord(relevantWord);
            if (isSimpleWord) {
                result.add(Arrays.asList(left, right));
                List<List<String>> otherSplits = this.getAllSplits(fromLeft ? right : left);
                if (otherSplits.size() > 0) {
                    for (List<String> otherSplit : otherSplits) {
                        ArrayList<String> sub = new ArrayList<String>();
                        if (fromLeft) {
                            sub.add(left);
                            sub.addAll(otherSplit);
                        } else {
                            sub.addAll(otherSplit);
                            sub.add(right);
                        }
                        result.add(new ArrayList(sub));
                    }
                }
            }
            i = fromLeft ? i + 1 : i - 1;
        }
        return result;
    }

    private boolean isLoopEnd(boolean fromLeft, int i, String word) {
        if (fromLeft) {
            return i < word.length() - this.minimumWordLength;
        }
        return i > this.minimumWordLength;
    }

    public List<String> splitWord(String word) {
        if (word == null) {
            return Collections.emptyList();
        }
        String trimmedWord = word.trim();
        List<String> exceptionSplit = this.exceptionSplits.getExceptionSplitOrNull(trimmedWord);
        if (exceptionSplit != null) {
            return exceptionSplit;
        }
        List<String> parts = this.split(trimmedWord, false);
        if (parts == null) {
            return Collections.singletonList(trimmedWord);
        }
        List<String> disambiguatedParts = this.getDisambiguator().disambiguate(parts);
        this.cleanLeadingAndTrailingHyphens(disambiguatedParts);
        return disambiguatedParts;
    }

    private void cleanLeadingAndTrailingHyphens(List<String> disambiguatedParts) {
        for (int i = 0; i < disambiguatedParts.size(); ++i) {
            String element = disambiguatedParts.get(i);
            if (element.startsWith("-")) {
                disambiguatedParts.set(i, element.substring(1));
            }
            if (!element.endsWith("-")) continue;
            disambiguatedParts.set(i, element.substring(0, element.length() - 1));
        }
    }

    private List<String> split(String word, boolean allowInterfixRemoval) {
        List<String> parts;
        boolean canInterfixBeRemoved;
        String lcWord = word.toLowerCase();
        String removableInterfix = this.findInterfixOrNull(lcWord);
        String wordWithoutInterfix = this.removeInterfix(word, removableInterfix);
        boolean bl = canInterfixBeRemoved = removableInterfix != null && allowInterfixRemoval;
        if (this.isSimpleWord(word)) {
            parts = Collections.singletonList(word);
        } else if (canInterfixBeRemoved && this.isSimpleWord(wordWithoutInterfix)) {
            parts = this.hideInterfixCharacters ? Arrays.asList(wordWithoutInterfix) : Arrays.asList(wordWithoutInterfix, removableInterfix);
        } else {
            parts = this.splitFromRight(word);
            if (parts == null && this.endsWithInterfix(lcWord) && (parts = this.splitFromRight(wordWithoutInterfix)) != null && !this.hideInterfixCharacters) {
                parts.add(removableInterfix);
            }
        }
        return parts;
    }

    private List<String> splitFromRight(String word) {
        List<String> parts = null;
        for (int i = word.length() - this.minimumWordLength; i >= this.minimumWordLength; --i) {
            List<String> exceptionSplit;
            String leftPart = word.substring(0, i);
            String rightPart = word.substring(i);
            if (!this.strictMode && (exceptionSplit = this.getExceptionSplitOrNull(rightPart, leftPart)) != null) {
                return exceptionSplit;
            }
            if (this.isSimpleWord(rightPart)) {
                boolean isLeftPartAWord;
                List<String> leftPartParts = this.split(leftPart, true);
                boolean bl = isLeftPartAWord = leftPartParts != null;
                if (isLeftPartAWord) {
                    parts = new ArrayList<String>(leftPartParts);
                    parts.add(rightPart);
                    continue;
                }
                if (this.strictMode) continue;
                parts = Arrays.asList(leftPart, rightPart);
                continue;
            }
            if (this.strictMode || !this.isSimpleWord(leftPart)) continue;
            parts = Arrays.asList(leftPart, rightPart);
        }
        return parts;
    }

    private List<String> getExceptionSplitOrNull(String rightPart, String leftPart) {
        List<String> exceptionSplit = this.exceptionSplits.getExceptionSplitOrNull(rightPart);
        if (exceptionSplit != null) {
            ArrayList<String> parts = new ArrayList<String>();
            parts.add(leftPart);
            parts.addAll(exceptionSplit);
            return parts;
        }
        List<String> exceptionSplit2 = this.exceptionSplits.getExceptionSplitOrNull(leftPart);
        if (exceptionSplit2 != null) {
            ArrayList<String> parts = new ArrayList<String>();
            parts.addAll(exceptionSplit2);
            parts.add(rightPart);
            return parts;
        }
        return null;
    }

    private String findInterfixOrNull(String word) {
        Collection<String> interfixes = this.getInterfixCharacters();
        String lcWord = word.toLowerCase();
        for (String interfix : interfixes) {
            if (!lcWord.endsWith(interfix)) continue;
            return interfix;
        }
        return null;
    }

    private boolean endsWithInterfix(String word) {
        Collection<String> interfixes = this.getInterfixCharacters();
        for (String interfix : interfixes) {
            if (!word.endsWith(interfix)) continue;
            return true;
        }
        return false;
    }

    private String removeInterfix(String word, String interfixOrNull) {
        if (interfixOrNull != null) {
            return word.substring(0, word.length() - interfixOrNull.length());
        }
        return word;
    }

    private boolean isSimpleWord(String part) {
        return part.length() >= this.minimumWordLength && this.words.contains(part.toLowerCase());
    }
}

