/*
 * Decompiled with CFR 0.152.
 */
package de.danielnaber.jwordsplitter;

import de.danielnaber.jwordsplitter.AbstractWordSplitter;
import de.danielnaber.jwordsplitter.tools.FileTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

class ExceptionSplits {
    private static final String COMMENT_CHAR = "#";
    private static final String DELIMITER_CHAR = "|";
    private final Map<String, List<String>> exceptionMap = new HashMap<String, List<String>>();

    ExceptionSplits(String filename) throws IOException {
        try (InputStream is = AbstractWordSplitter.class.getResourceAsStream(filename);){
            if (is == null) {
                throw new IOException("Cannot locate exception list in class path: " + filename);
            }
            String exceptions = FileTools.loadFile(is, "UTF-8");
            try (Scanner scanner = new Scanner(exceptions);){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (line.isEmpty() || line.startsWith(COMMENT_CHAR)) continue;
                    String[] parts = line.replace("/NS", "").split("\\|");
                    String completeWord = line.replace(DELIMITER_CHAR, "");
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(parts));
                    if (completeWord.contains("/")) {
                        if (completeWord.endsWith("/NS")) {
                            String realWord = completeWord.replace("/NS", "").toLowerCase();
                            this.exceptionMap.put(realWord, list);
                            this.exceptionMap.put(realWord + "n", this.addToLastPart(list, "n"));
                            this.exceptionMap.put(realWord + "s", this.addToLastPart(list, "s"));
                            continue;
                        }
                        throw new RuntimeException("Unknown suffix in line: " + line);
                    }
                    this.exceptionMap.put(completeWord.toLowerCase(), list);
                }
            }
        }
    }

    private List<String> addToLastPart(List<String> list, String suffix) {
        ArrayList<String> result = new ArrayList<String>(list);
        int lastPos = result.size() - 1;
        result.set(lastPos, (String)result.get(lastPos) + suffix);
        return result;
    }

    List<String> getExceptionSplitOrNull(String word) {
        String check;
        String lcWord = word.toLowerCase();
        List<String> result = this.exceptionMap.get(lcWord);
        if (result != null && lcWord.equals((check = this.join(result, "")).toLowerCase())) {
            result = this.splitEqually(result, word);
        }
        return result;
    }

    protected List<String> splitEqually(List<String> splitted, String original) {
        ArrayList<String> list = new ArrayList<String>();
        int offset = 0;
        for (String s : splitted) {
            int length = s.length();
            list.add(original.substring(offset, offset + length));
            offset += length;
        }
        return list;
    }

    protected String join(List<String> elements, String separator) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = elements.iterator();
        if (iter.hasNext()) {
            builder.append(iter.next());
            while (iter.hasNext()) {
                builder.append(separator).append(iter.next());
            }
        }
        return builder.toString();
    }

    void addSplit(String word, List<String> wordParts) {
        this.exceptionMap.put(word.toLowerCase(), wordParts);
    }
}

