/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class GenericUnpairedBracketsRuleTest {
    private JLanguageTool langTool;

    @Test
    public void testRule() throws IOException {
        this.setUpRule(new FakeLanguage());
        this.assertMatches(0, "This is \u00bbcorrect\u00ab.");
        this.assertMatches(0, "\u00bbCorrect\u00ab\n\u00bbAnd \u00bbhere\u00ab it ends.\u00ab");
        this.assertMatches(0, "\u00bbCorrect. This is more than one sentence.\u00ab");
        this.assertMatches(0, "\u00bbCorrect. This is more than one sentence.\u00ab\n\u00bbAnd \u00bbhere\u00ab it ends.\u00ab");
        this.assertMatches(0, "\u00bbCorrect\u00ab\n\n\u00bbAnd here it ends.\u00ab\n\nMore text.");
        this.assertMatches(0, "\u00bbCorrect, he said. This is the next sentence.\u00ab Here's another sentence.");
        this.assertMatches(0, "\u00bbCorrect, he said.\n\nThis is the next sentence.\u00ab Here's another sentence.");
        this.assertMatches(0, "\u00bbCorrect, he said.\n\n\n\nThis is the next sentence.\u00ab Here's another sentence.");
        this.assertMatches(0, "This \u00bbis also \u00bbcorrect\u00ab\u00ab.");
        this.assertMatches(0, "Good.\n\nThis \u00bbis also \u00bbcorrect\u00ab\u00ab.");
        this.assertMatches(0, "Good.\n\n\nThis \u00bbis also \u00bbcorrect\u00ab\u00ab.");
        this.assertMatches(0, "Good.\n\n\n\nThis \u00bbis also \u00bbcorrect\u00ab\u00ab.");
        this.assertMatches(1, "This is not correct\u00ab");
        this.assertMatches(1, "This is \u00bbnot correct");
        this.assertMatches(1, "This is correct.\n\n\u00bbBut this is not.");
        this.assertMatches(1, "This is correct.\n\nBut this is not\u00ab");
        this.assertMatches(1, "\u00bbThis is correct\u00ab\n\nBut this is not\u00ab");
        this.assertMatches(1, "\u00bbThis is correct\u00ab\n\nBut this \u00bbis\u00ab not\u00ab");
        this.assertMatches(1, "This is not correct. No matter if it's more than one sentence\u00ab");
        this.assertMatches(1, "\u00bbThis is not correct. No matter if it's more than one sentence");
        this.assertMatches(1, "Correct, he said. This is the next sentence.\u00ab Here's another sentence.");
        this.assertMatches(1, "\u00bbCorrect, he said. This is the next sentence. Here's another sentence.");
        this.assertMatches(1, "\u00bbCorrect, he said. This is the next sentence.\n\nHere's another sentence.");
        this.assertMatches(1, "\u00bbCorrect, he said. This is the next sentence.\n\n\n\nHere's another sentence.");
    }

    @Test
    public void testRuleMatchPositions() throws IOException {
        this.setUpRule(new FakeLanguage());
        RuleMatch match1 = (RuleMatch)this.langTool.check("This \u00bbis a test.").get(0);
        Assert.assertThat((Object)match1.getFromPos(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)match1.getToPos(), (Matcher)CoreMatchers.is((Object)6));
        Assert.assertThat((Object)match1.getLine(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)match1.getEndLine(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)match1.getColumn(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)match1.getEndColumn(), (Matcher)CoreMatchers.is((Object)6));
        RuleMatch match2 = (RuleMatch)this.langTool.check("This.\nSome stuff.\nIt \u00bbis a test.").get(0);
        Assert.assertThat((Object)match2.getFromPos(), (Matcher)CoreMatchers.is((Object)21));
        Assert.assertThat((Object)match2.getToPos(), (Matcher)CoreMatchers.is((Object)22));
        Assert.assertThat((Object)match2.getLine(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)match2.getEndLine(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)match2.getColumn(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)match2.getEndColumn(), (Matcher)CoreMatchers.is((Object)5));
    }

    private void setUpRule(Language language) {
        this.langTool = new JLanguageTool(language);
        for (Rule rule : this.langTool.getAllRules()) {
            this.langTool.disableRule(rule.getId());
        }
        GenericUnpairedBracketsRule rule = new GenericUnpairedBracketsRule(TestTools.getEnglishMessages(), Arrays.asList("\u00bb"), Arrays.asList("\u00ab"));
        this.langTool.addRule((Rule)rule);
    }

    private void assertMatches(int expectedMatches, String input) throws IOException {
        List ruleMatches = this.langTool.check(input);
        Assert.assertEquals((String)("Expected " + expectedMatches + " matches, got: " + ruleMatches), (long)expectedMatches, (long)ruleMatches.size());
    }

    public static GenericUnpairedBracketsRule getBracketsRule(JLanguageTool langTool) {
        for (Rule rule : langTool.getAllActiveRules()) {
            if (!(rule instanceof GenericUnpairedBracketsRule)) continue;
            return (GenericUnpairedBracketsRule)rule;
        }
        throw new RuntimeException("Rule not found: " + GenericUnpairedBracketsRule.class);
    }
}

